/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.LegacyConnectionOwnerUtil;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionPool;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Pair;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionManager
implements DeploymentConfigChangeListener {
    @NonNls
    public static final String DEFAULT_IDE_FTP_SYSTEM_TYPE = "UNIX default system type provided by IDE";
    private static final Logger LOG = Logger.getInstance(RemoteConnectionManager.class);
    private final Object LOCK = new Object();
    private final Map<ConnectionKey, RemoteConnectionPool> myPools = new TreeMap<ConnectionKey, RemoteConnectionPool>();

    public static RemoteConnectionManager getInstance() {
        return (RemoteConnectionManager)ServiceManager.getService(RemoteConnectionManager.class);
    }

    public RemoteConnectionManager() {
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)this);
        if (System.getProperty("org.apache.commons.net.ftp.systemType.default") == null) {
            System.setProperty("org.apache.commons.net.ftp.systemType.default", DEFAULT_IDE_FTP_SYSTEM_TYPE);
        }
        RemoteConnectionManager.updateProvider();
        this.deploymentConfigChanged();
    }

    public RemoteConnection openConnection(@NotNull com.intellij.ssh.interaction.ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        if (connectionOwner == null) {
            RemoteConnectionManager.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteConnectionManager.$$$reportNull$$$0(1);
        }
        if (connectable == null) {
            RemoteConnectionManager.$$$reportNull$$$0(2);
        }
        if (origin == null) {
            RemoteConnectionManager.$$$reportNull$$$0(3);
        }
        return this.openConnection(LegacyConnectionOwnerUtil.adapt(connectionOwner), title, connectable, origin, forceDisconnectDispatcher, pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RemoteConnection openConnection(@NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        RemoteConnectionPool pool;
        if (connectionOwner == null) {
            RemoteConnectionManager.$$$reportNull$$$0(4);
        }
        if (title == null) {
            RemoteConnectionManager.$$$reportNull$$$0(5);
        }
        if (connectable == null) {
            RemoteConnectionManager.$$$reportNull$$$0(6);
        }
        if (origin == null) {
            RemoteConnectionManager.$$$reportNull$$$0(7);
        }
        final ConnectionKey key = new ConnectionKey(connectable.getRootUri(), connectable.getConnectionOptions(connectionOwner, title, origin, forceDisconnectDispatcher, pi));
        Object object = this.LOCK;
        synchronized (object) {
            pool = this.myPools.get(key);
            if (pool == null) {
                try {
                    connectionOwner.checkDisposed();
                }
                catch (IllegalStateException e) {
                    throw new FileSystemException((Throwable)e);
                }
                pool = new RemoteConnectionPool(connectable, connectionOwner, title, origin, forceDisconnectDispatcher);
                this.myPools.put(key, pool);
                connectionOwner.registerDisposable(new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        RemoteConnectionPool pool;
                        Object object = RemoteConnectionManager.this.LOCK;
                        synchronized (object) {
                            pool = (RemoteConnectionPool)RemoteConnectionManager.this.myPools.remove(key);
                        }
                        if (pool != null) {
                            pool.close();
                        }
                    }
                });
            }
        }
        return pool.createConnection(forceDisconnectDispatcher, pi);
    }

    @Override
    public void deploymentConfigChanged() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            @NotNull List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> newServers = GroupedServersConfigManagerImpl.getServersWithProjectsFromAllOpenProjects(false);
            RemoteConnectionPool[] remoteConnectionPoolArray = this.LOCK;
            synchronized (this.LOCK) {
                RemoteConnectionPool[] pools = this.myPools.values().toArray(new RemoteConnectionPool[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (RemoteConnectionPool pool : pools) {
                    pool.notifyServersUpdated(newServers);
                }
                return;
            }
        });
    }

    private static void updateProvider() {
        if (SftpUtil.getSshBackendLibraryForWebDeployment() == SshBackendLibrary.SSHJ || SshBackendLibrary.get() == SshBackendLibrary.SSHJ) {
            return;
        }
        boolean enabled = Registry.get((String)"deployment.BouncyCastleJCE").asBoolean();
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        LOG.debug("Extended JCE " + (enabled ? "on" : "off"));
        if (enabled) {
            int index = Security.insertProviderAt((Provider)bouncyCastleProvider, 1);
            LOG.debug("BouncyCastleJCE installed at " + index + ", providers " + Arrays.toString(Security.getProviders()));
        } else {
            Security.removeProvider(bouncyCastleProvider.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connectionOwner";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "connectable";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "origin";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager";
        objectArray[2] = "openConnection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConnectionKey
    implements Comparable<ConnectionKey> {
        private final String myUri;
        private final FileSystemOptions myFileSystemOptions;

        private ConnectionKey(String uri, FileSystemOptions fileSystemOptions) {
            this.myUri = uri;
            this.myFileSystemOptions = fileSystemOptions;
        }

        @Override
        public int compareTo(ConnectionKey o) {
            int i = this.myUri.compareTo(o.myUri);
            if (i == 0) {
                i = this.myFileSystemOptions.compareTo(o.myFileSystemOptions);
            }
            return i;
        }
    }
}

