/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MultiResolutionImageProvider {
    public static boolean isMultiResolutionImage(@Nullable Image image) {
        return image != null && Accessor.MRI_CLASS != null && Accessor.MRI_CLASS.isInstance(image);
    }

    public static boolean isMultiResolutionImageAvailable() {
        return Accessor.MRI_CLASS != null;
    }

    @Nullable
    public static Image convertFromJBImage(@Nullable Image jbImage) {
        if (jbImage == null) {
            return null;
        }
        if (!MultiResolutionImageProvider.checkSize(jbImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        return Converter.convert(jbImage);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Accessor getAccessor(@Nullable Image mrImage) {
        if (mrImage == null) {
            return null;
        }
        if (!MultiResolutionImageProvider.checkSize(mrImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        return new Accessor(mrImage);
    }

    private static boolean checkSize(Image image) {
        return image.getWidth(null) != 0 && image.getHeight(null) != 0;
    }

    private static class Converter {
        private static final Constructor BMRI_CLASS_CTOR;

        private Converter() {
        }

        @Nullable
        public static Image convert(Image jbImage) {
            Image[] variants;
            if (BMRI_CLASS_CTOR == null) {
                return null;
            }
            if (jbImage instanceof JBHiDPIScaledImage) {
                JBHiDPIScaledImage scaledImage = (JBHiDPIScaledImage)jbImage;
                BufferedImage lowResImage = ImageUtil.toBufferedImage(scaledImage, true);
                BufferedImage highResImage = ImageUtil.toBufferedImage(scaledImage);
                variants = new Image[]{lowResImage, highResImage};
            } else {
                variants = new Image[]{jbImage};
            }
            try {
                return (Image)BMRI_CLASS_CTOR.newInstance(new Object[]{variants});
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }

        static {
            Class<?> cls = null;
            Constructor<?> ctor = null;
            if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
                try {
                    cls = Class.forName("java.awt.image.BaseMultiResolutionImage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) {
                    try {
                        ctor = cls.getConstructor(Image[].class);
                        ctor.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            BMRI_CLASS_CTOR = ctor;
        }
    }

    public static class Accessor {
        private static final Class MRI_CLASS;
        private static final MethodInvocator GET_RESOLUTION_VARIANTS_METHOD;
        private static final MethodInvocator GET_RESOLUTION_VARIANT_METHOD;
        private final Image myMRImage;

        private Accessor(Image mrImage) {
            this.myMRImage = mrImage;
        }

        public List<Image> getResolutionVariants() {
            if (!MultiResolutionImageProvider.isMultiResolutionImage(this.myMRImage)) {
                return Collections.singletonList(this.myMRImage);
            }
            return (List)GET_RESOLUTION_VARIANTS_METHOD.invoke((Object)this.myMRImage, new Object[0]);
        }

        public Image getResolutionVariant(double width, double height) {
            if (!MultiResolutionImageProvider.isMultiResolutionImage(this.myMRImage)) {
                if (!MultiResolutionImageProvider.checkSize(this.myMRImage)) {
                    return this.myMRImage;
                }
                return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(this.myMRImage), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)((int)width), (int)((int)height), (BufferedImageOp[])null);
            }
            return (Image)GET_RESOLUTION_VARIANT_METHOD.invoke((Object)this.myMRImage, new Object[]{width, height});
        }

        static {
            Class<?> cls = null;
            MethodInvocator m1 = null;
            MethodInvocator m2 = null;
            if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
                try {
                    cls = Class.forName("java.awt.image.MultiResolutionImage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) {
                    m1 = new MethodInvocator(cls, "getResolutionVariants", new Class[0]);
                    m2 = new MethodInvocator(cls, "getResolutionVariant", new Class[]{Double.TYPE, Double.TYPE});
                }
            }
            MRI_CLASS = cls;
            GET_RESOLUTION_VARIANTS_METHOD = m1;
            GET_RESOLUTION_VARIANT_METHOD = m2;
        }
    }
}

