/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;
import org.apache.xmlrpc.XmlRpcServerRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;
import org.xml.sax.SAXParseException;

public class XmlRpcServerImpl
implements XmlRpcServer {
    private static final Logger LOG = Logger.getInstance(XmlRpcServerImpl.class);
    private final Map<String, Object> handlerMapping = new THashMap();

    public boolean hasHandler(String name) {
        return this.handlerMapping.containsKey(name);
    }

    public void addHandler(String name, Object handler2) {
        this.handlerMapping.put(name, handler2);
    }

    public void removeHandler(String name) {
        this.handlerMapping.remove(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(@NotNull String path, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context, @Nullable Map<String, Object> handlers) {
        ByteBuf result2;
        if (path == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(2);
        }
        if (!(path.isEmpty() || path.length() == 1 && path.charAt(0) == '/' || path.equalsIgnoreCase("/rpc2"))) {
            return false;
        }
        if (request2.method() != HttpMethod.POST) {
            return false;
        }
        ByteBuf content2 = request2.content();
        if (content2.readableBytes() == 0) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (Channel)context.channel(), (HttpRequest)request2);
            return true;
        }
        try (ByteBufInputStream in = new ByteBufInputStream(content2);){
            XmlRpcServerRequest xmlRpcServerRequest = new XmlRpcRequestProcessor().decodeRequest((InputStream)in);
            if (StringUtil.isEmpty((String)xmlRpcServerRequest.getMethodName())) {
                LOG.warn("method name empty");
                boolean bl = false;
                return bl;
            }
            Object response = XmlRpcServerImpl.invokeHandler(XmlRpcServerImpl.getHandler(xmlRpcServerRequest.getMethodName(), handlers == null ? this.handlerMapping : handlers), xmlRpcServerRequest);
            result2 = Unpooled.wrappedBuffer((byte[])new XmlRpcResponseProcessor().encodeResponse(response, "UTF-8"));
        }
        catch (SAXParseException e) {
            LOG.warn((Throwable)e);
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (Channel)context.channel(), (HttpRequest)request2);
            return true;
        }
        catch (Throwable e) {
            context.channel().close();
            LOG.error(e);
            return true;
        }
        Responses.send((HttpResponse)Responses.response((String)"text/xml", (ByteBuf)result2), (Channel)context.channel(), (HttpRequest)request2);
        return true;
    }

    private static Object getHandler(@NotNull String methodName, @NotNull Map<String, Object> handlers) {
        if (methodName == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(3);
        }
        if (handlers == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(4);
        }
        Object handler2 = null;
        String handlerName = null;
        int dot = methodName.lastIndexOf(46);
        if (dot > -1) {
            handlerName = methodName.substring(0, dot);
            handler2 = handlers.get(handlerName);
        }
        if (handler2 != null) {
            return handler2;
        }
        if (dot > -1) {
            throw new IllegalStateException("RPC handler object \"" + handlerName + "\" not found");
        }
        throw new IllegalStateException("RPC handler object not found for \"" + methodName);
    }

    private static Object invokeHandler(@NotNull Object handler2, XmlRpcServerRequest request2) throws Throwable {
        if (handler2 == null) {
            XmlRpcServerImpl.$$$reportNull$$$0(5);
        }
        return handler2 instanceof XmlRpcHandler ? (XmlRpcHandler)handler2 : XmlRpcServerImpl.invoke(handler2, request2.getMethodName(), request2.getParameters());
    }

    private static Object invoke(Object target2, String methodName, Vector params) throws Throwable {
        Method method2;
        int dot;
        Class<?> targetClass = target2 instanceof Class ? (Class<?>)target2 : target2.getClass();
        Class[] argClasses = null;
        Object[] argValues = null;
        if (params != null) {
            argClasses = new Class[params.size()];
            argValues = new Object[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                argValues[i] = params.elementAt(i);
                argClasses[i] = argValues[i] instanceof Integer ? Integer.TYPE : (argValues[i] instanceof Double ? Double.TYPE : (argValues[i] instanceof Boolean ? Boolean.TYPE : argValues[i].getClass()));
            }
        }
        if ((dot = methodName.lastIndexOf(46)) > -1 && dot + 1 < methodName.length()) {
            methodName = methodName.substring(dot + 1);
        }
        if ((method2 = targetClass.getMethod(methodName, argClasses)).getDeclaringClass() == Object.class) {
            throw new XmlRpcException(0, "Invoker can't call methods defined in java.lang.Object");
        }
        Object returnValue = method2.invoke(target2, argValues);
        if (returnValue == null && method2.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("void return types for handler methods not supported, " + methodName);
        }
        return returnValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/ide/XmlRpcServerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class XmlRpcRequestHandler
    extends HttpRequestHandler {
        XmlRpcRequestHandler() {
        }

        public boolean isSupported(@NotNull FullHttpRequest request2) {
            if (request2 == null) {
                XmlRpcRequestHandler.$$$reportNull$$$0(0);
            }
            return request2.method() == HttpMethod.POST || request2.method() == HttpMethod.OPTIONS;
        }

        public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) throws IOException {
            if (urlDecoder == null) {
                XmlRpcRequestHandler.$$$reportNull$$$0(1);
            }
            if (request2 == null) {
                XmlRpcRequestHandler.$$$reportNull$$$0(2);
            }
            if (context == null) {
                XmlRpcRequestHandler.$$$reportNull$$$0(3);
            }
            return XmlRpcServer.SERVICE.getInstance().process(urlDecoder.path(), request2, context, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlDecoder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/ide/XmlRpcServerImpl$XmlRpcRequestHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

