/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueMarkers<V extends XValue, M> {
    private final XValueMarkerProvider<V, M> myProvider;
    private final Map<M, ValueMarkup> myMarkers;

    private XValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            XValueMarkers.$$$reportNull$$$0(0);
        }
        this.myProvider = provider;
        this.myMarkers = new HashMap<M, ValueMarkup>();
    }

    public static <V extends XValue, M> XValueMarkers<V, M> createValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            XValueMarkers.$$$reportNull$$$0(1);
        }
        return new XValueMarkers<V, M>(provider);
    }

    @Nullable
    public ValueMarkup getMarkup(@NotNull XValue value2) {
        Class valueClass;
        if (value2 == null) {
            XValueMarkers.$$$reportNull$$$0(2);
        }
        if (!(valueClass = this.myProvider.getValueClass()).isInstance(value2)) {
            return null;
        }
        XValue v = (XValue)valueClass.cast(value2);
        if (!this.myProvider.canMark(v)) {
            return null;
        }
        Object m = this.myProvider.getMarker(v);
        if (m == null) {
            return null;
        }
        return this.myMarkers.get(m);
    }

    public boolean canMarkValue(@NotNull XValue value2) {
        Class valueClass;
        if (value2 == null) {
            XValueMarkers.$$$reportNull$$$0(3);
        }
        if (!(valueClass = this.myProvider.getValueClass()).isInstance(value2)) {
            return false;
        }
        return this.myProvider.canMark((XValue)valueClass.cast(value2));
    }

    public void markValue(@NotNull XValue value2, @NotNull ValueMarkup markup) {
        if (value2 == null) {
            XValueMarkers.$$$reportNull$$$0(4);
        }
        if (markup == null) {
            XValueMarkers.$$$reportNull$$$0(5);
        }
        this.myMarkers.entrySet().stream().filter(entry -> markup.getText().equals(((ValueMarkup)entry.getValue()).getText())).findFirst().ifPresent(entry -> this.myMarkers.remove(entry.getKey()));
        Object m = this.myProvider.markValue(value2);
        this.myMarkers.put(m, markup);
    }

    public void unmarkValue(@NotNull XValue value2) {
        XValue v;
        Object m;
        if (value2 == null) {
            XValueMarkers.$$$reportNull$$$0(6);
        }
        if ((m = this.myProvider.getMarker(v = value2)) != null) {
            this.myProvider.unmarkValue(v, m);
            this.myMarkers.remove(m);
        }
    }

    public Map<M, ValueMarkup> getAllMarkers() {
        return Collections.unmodifiableMap(this.myMarkers);
    }

    public void clear() {
        this.myMarkers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XValueMarkers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canMarkValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "markValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unmarkValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

