/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addPrimaryModuleDependency", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "newModule", "addVcsMapping", "", "primaryModule", "addedModuleContentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachModule", "imlFile", "Ljava/nio/file/Path;", "findMainModule", "projectDir", "removeVcsMapping", "module", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessorKt {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Module findMainModule(Project project, Path projectDir) {
        Path path = projectDir;
        Function1 filter$iv = findMainModule.1.INSTANCE;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                boolean bl2 = false;
                Iterator iterator2 = directoryStream.iterator();
                if (iterator2.hasNext()) {
                    Path file2;
                    Path path2 = file2 = (Path)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    Module module = ModuleAttachProcessorKt.attachModule(project, path2);
                    return module;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return null;
    }

    private static final Module attachModule(Project project, Path imlFile) {
        ModifiableModuleModel model$iv;
        Project $this$modifyModules$iv = project;
        boolean $i$f$modifyModules = false;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)$this$modifyModules$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModuleModel, (String)"ModuleManager.getInstance(this).modifiableModel");
        ModifiableModuleModel $this$modifyModules = model$iv = modifiableModuleModel;
        boolean bl = false;
        Module result$iv = $this$modifyModules.loadModule(PathKt.getSystemIndependentPath((Path)imlFile));
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(model$iv){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        Module module = result$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"project.modifyModules {\n\u2026ystemIndependentPath)\n  }");
        Module module2 = module;
        Module module3 = ModuleManager.getInstance((Project)project).findModuleByName(module2.getName());
        if (module3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"ModuleManager.getInstanc\u2026duleByName(module.name)!!");
        Module newModule = module3;
        Module primaryModule = ModuleAttachProcessorKt.addPrimaryModuleDependency(project, newModule);
        if (primaryModule != null) {
            VirtualFile dotIdeaDirParent;
            VirtualFile virtualFile;
            Path path = imlFile.getParent();
            if (path != null && (path = path.getParent()) != null) {
                Path path2 = path;
                boolean bl2 = false;
                boolean bl3 = false;
                Path it = path2;
                boolean bl4 = false;
                virtualFile = LocalFileSystem.getInstance().findFileByPath(((Object)it).toString());
            } else {
                virtualFile = dotIdeaDirParent = null;
            }
            if (dotIdeaDirParent != null) {
                ModuleAttachProcessorKt.addVcsMapping(primaryModule, dotIdeaDirParent);
            }
        }
        return newModule;
    }

    private static final void addVcsMapping(Module primaryModule, VirtualFile addedModuleContentRoot) {
        AbstractVcs vcs;
        ProjectLevelVcsManager vcsManager;
        Project project = primaryModule.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"primaryModule.project");
        Project project2 = project;
        ProjectLevelVcsManager projectLevelVcsManager = vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"vcsManager");
        List mappings = projectLevelVcsManager.getDirectoryMappings();
        if (mappings.size() == 1) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)primaryModule);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(primaryModule)");
            VirtualFile[] contentRoots2 = moduleRootManager.getContentRoots();
            if (contentRoots2.length == 1) {
                AbstractVcs vcs2;
                VirtualFile virtualFile = contentRoots2[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"contentRoots[0]");
                File file2 = new File(virtualFile.getPath());
                Object e = mappings.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"mappings[0]");
                if (FileUtil.filesEqual((File)file2, (File)new File(((VcsDirectoryMapping)e).getDirectory())) && (vcs2 = vcsManager.findVersioningVcs(addedModuleContentRoot)) != null) {
                    String string = vcs2.getName();
                    Object e2 = mappings.get(0);
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"mappings[0]");
                    if (Intrinsics.areEqual((Object)string, (Object)((VcsDirectoryMapping)e2).getVcs())) {
                        vcsManager.setDirectoryMappings(CollectionsKt.listOf((Object)VcsDirectoryMapping.createDefault((String)vcs2.getName())));
                        return;
                    }
                }
            }
        }
        if ((vcs = vcsManager.findVersioningVcs(addedModuleContentRoot)) != null) {
            ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(mappings);
            newMappings.add(new VcsDirectoryMapping(addedModuleContentRoot.getPath(), vcs.getName()));
            vcsManager.setDirectoryMappings((List)newMappings);
        }
    }

    private static final Module addPrimaryModuleDependency(Project project, Module newModule) {
        Module module = ModuleAttachProcessor.Companion.getPrimaryModule(project);
        if (module != null && module != newModule) {
            ModuleRootModificationUtil.addDependency((Module)module, (Module)newModule);
            return module;
        }
        return null;
    }

    private static final void removeVcsMapping(Module module) {
        ProjectLevelVcsManager vcsManager;
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        ProjectLevelVcsManager projectLevelVcsManager = vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"vcsManager");
        List mappings = projectLevelVcsManager.getDirectoryMappings();
        ArrayList newMappings = new ArrayList(mappings);
        for (VcsDirectoryMapping mapping2 : mappings) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                VirtualFile virtualFile = root = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                File file2 = new File(virtualFile.getPath());
                VcsDirectoryMapping vcsDirectoryMapping = mapping2;
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirectoryMapping, (String)"mapping");
                if (!FileUtil.filesEqual((File)file2, (File)new File(vcsDirectoryMapping.getDirectory()))) continue;
                newMappings.remove(mapping2);
            }
        }
        vcsManager.setDirectoryMappings((List)newMappings);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ModuleAttachProcessor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Module access$findMainModule(Project project, Path projectDir) {
        return ModuleAttachProcessorKt.findMainModule(project, projectDir);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$removeVcsMapping(Module module) {
        ModuleAttachProcessorKt.removeVcsMapping(module);
    }
}

