/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.TaskDefaultFavoriteListProvider;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.LibraryModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleUrl;
import com.intellij.ide.projectView.impl.NamedLibraryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="FavoritesManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class FavoritesManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<TreeItem<Pair<AbstractUrl, String>>>> myName2FavoritesRoots;
    private final List<String> myFavoritesRootsOrder;
    private final Map<String, String> myDescriptions;
    private final Project myProject;
    private final List<FavoritesListener> myListeners;
    private final FavoritesViewSettings myViewSettings;
    private Map<String, FavoritesListProvider> myProviders;
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    private static final ArrayList<AbstractUrl> ourAbstractUrlProviders = new ArrayList();
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    public static FavoritesManager getInstance(@NotNull Project project) {
        if (project == null) {
            FavoritesManager.$$$reportNull$$$0(0);
        }
        return (FavoritesManager)project.getService(FavoritesManager.class);
    }

    public FavoritesManager(@NotNull Project project) {
        if (project == null) {
            FavoritesManager.$$$reportNull$$$0(1);
        }
        this.myName2FavoritesRoots = new TreeMap<String, List<TreeItem<Pair<AbstractUrl, String>>>>();
        this.myFavoritesRootsOrder = new ArrayList<String>();
        this.myDescriptions = new HashMap<String, String>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myViewSettings = new FavoritesViewSettings();
        this.myProject = project;
    }

    @NotNull
    private Map<String, FavoritesListProvider> getProviders() {
        if (this.myProviders != null) {
            Map<String, FavoritesListProvider> map2 = this.myProviders;
            if (map2 == null) {
                FavoritesManager.$$$reportNull$$$0(2);
            }
            return map2;
        }
        this.myProviders = new HashMap<String, FavoritesListProvider>();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FavoritesListProvider[] providers;
            for (FavoritesListProvider provider : providers = (FavoritesListProvider[])FavoritesListProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                this.myProviders.put(provider.getListName(this.myProject), provider);
            }
            MyRootsChangeAdapter myPsiTreeChangeAdapter = new MyRootsChangeAdapter();
            PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)myPsiTreeChangeAdapter, (Disposable)this.myProject);
            if (this.myName2FavoritesRoots.isEmpty()) {
                this.myDescriptions.put(this.myProject.getName(), "auto-added");
                this.createNewList(this.myProject.getName());
            }
        }
        Map<String, FavoritesListProvider> map3 = this.myProviders;
        if (map3 == null) {
            FavoritesManager.$$$reportNull$$$0(3);
        }
        return map3;
    }

    private void rootsChanged() {
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.rootsChanged();
        }
    }

    private void listAdded(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(4);
        }
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listAdded(listName);
        }
    }

    private void listRemoved(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(5);
        }
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listRemoved(listName);
        }
    }

    public void renameList(final Project project, @NotNull String listName) {
        String newName;
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(6);
        }
        if ((newName = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.input.favorites.list.new.name", (Object[])new Object[]{listName}), (String)IdeBundle.message((String)"title.rename.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)listName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (FavoritesManager.this.myName2FavoritesRoots.keySet().contains(inputString) || FavoritesManager.this.getProviders().keySet().contains(inputString)) {
                    Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return !inputString.isEmpty();
            }
        })) != null && this.renameFavoritesList(listName, newName)) {
            this.rootsChanged();
        }
    }

    public void addFavoritesListener(final FavoritesListener listener2, @NotNull Disposable parent) {
        if (parent == null) {
            FavoritesManager.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener2);
        listener2.rootsChanged();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesManager.this.myListeners.remove(listener2);
            }
        });
    }

    List<AbstractTreeNode<?>> createRootNodes() {
        ArrayList result2 = new ArrayList();
        for (String listName : this.myFavoritesRootsOrder) {
            result2.add(new FavoritesListNode(this.myProject, listName, this.myDescriptions.get(listName)));
        }
        ArrayList<FavoritesListProvider> providers = new ArrayList<FavoritesListProvider>(this.getProviders().values());
        Collections.sort(providers);
        for (FavoritesListProvider provider : providers) {
            result2.add(provider.createFavoriteListNode(this.myProject));
        }
        return result2;
    }

    @NotNull
    public List<String> getAvailableFavoritesListNames() {
        return new ArrayList<String>(this.myFavoritesRootsOrder);
    }

    public synchronized void createNewList(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(8);
        }
        this.myName2FavoritesRoots.put(listName, new ArrayList());
        this.myFavoritesRootsOrder.add(listName);
        this.listAdded(listName);
    }

    public synchronized void fireListeners(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(9);
        }
        this.rootsChanged();
    }

    @NotNull
    public FavoritesViewSettings getViewSettings() {
        FavoritesViewSettings favoritesViewSettings = this.myViewSettings;
        if (favoritesViewSettings == null) {
            FavoritesManager.$$$reportNull$$$0(10);
        }
        return favoritesViewSettings;
    }

    public synchronized void removeFavoritesList(@NotNull String name) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(11);
        }
        this.myName2FavoritesRoots.remove(name);
        this.myFavoritesRootsOrder.remove(name);
        this.myDescriptions.remove(name);
        this.listRemoved(name);
    }

    @NotNull
    public List<TreeItem<Pair<AbstractUrl, String>>> getFavoritesListRootUrls(@NotNull String name) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> pairs;
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(12);
        }
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> arrayList = (pairs = this.myName2FavoritesRoots.get(name)) == null ? new ArrayList<TreeItem<Pair<AbstractUrl, String>>>() : pairs;
        if (arrayList == null) {
            FavoritesManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public synchronized boolean addRoots(@NotNull String name, Module moduleContext, @NotNull Object elements2) {
        Collection<AbstractTreeNode<?>> nodes;
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(14);
        }
        if (elements2 == null) {
            FavoritesManager.$$$reportNull$$$0(15);
        }
        return !(nodes = AddToFavoritesAction.createNodes(this.myProject, moduleContext, elements2, true, this.getViewSettings())).isEmpty() && this.addRoots(name, nodes);
    }

    public synchronized Comparator<FavoriteTreeNodeDescriptor> getCustomComparator(@NotNull String name) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(16);
        }
        return this.getProviders().get(name);
    }

    private Pair<AbstractUrl, String> createPairForNode(AbstractTreeNode node) {
        String className = node.getClass().getName();
        Object value2 = node.getValue();
        AbstractUrl url = FavoritesManager.createUrlByElement(value2, this.myProject);
        if (url == null) {
            return null;
        }
        return Pair.create((Object)url, (Object)className);
    }

    public boolean addRoots(String name, Collection<? extends AbstractTreeNode<?>> nodes) {
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name);
        HashSet<Object> set = new HashSet<Object>(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode<?> node : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node);
            if (pair == null || set.contains(pair.getFirst())) continue;
            TreeItem treeItem = new TreeItem(pair);
            list2.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            set.add(pair.getFirst());
            this.appendChildNodes(node, (TreeItem<Pair<AbstractUrl, String>>)treeItem);
        }
        this.rootsChanged();
        return true;
    }

    public boolean canAddRoots(@NotNull String name, @NotNull Collection<? extends AbstractTreeNode<?>> nodes) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(17);
        }
        if (nodes == null) {
            FavoritesManager.$$$reportNull$$$0(18);
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name);
        HashSet set = new HashSet(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode<?> node : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node);
            if (pair == null || set.contains(pair.getFirst())) continue;
            return true;
        }
        return false;
    }

    private void appendChildNodes(AbstractTreeNode node, TreeItem<Pair<AbstractUrl, String>> treeItem) {
        Collection children2 = node.getChildren();
        for (AbstractTreeNode child2 : children2) {
            TreeItem childTreeItem = new TreeItem(this.createPairForNode(child2));
            treeItem.addChild(childTreeItem);
            this.appendChildNodes(child2, (TreeItem<Pair<AbstractUrl, String>>)childTreeItem);
        }
    }

    private <T> boolean findListToRemoveFrom(@NotNull String name, @NotNull List<T> elements2, Function<? super T, ? extends AbstractUrl> convertor) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(19);
        }
        if (elements2 == null) {
            FavoritesManager.$$$reportNull$$$0(20);
        }
        List list2 = this.getFavoritesListRootUrls(name);
        if (elements2.size() > 1) {
            List<T> sublist = elements2.subList(0, elements2.size() - 1);
            for (T obj : sublist) {
                AbstractUrl objUrl = convertor.apply(obj);
                TreeItem<Pair<AbstractUrl, String>> item = FavoritesManager.findNextItem(objUrl, list2);
                if (item == null || item.getChildren() == null) {
                    return false;
                }
                list2 = item.getChildren();
            }
        }
        TreeItem found = null;
        AbstractUrl url = convertor.apply(elements2.get(elements2.size() - 1));
        if (url == null) {
            return false;
        }
        for (TreeItem pair : list2) {
            if (!url.equals(((Pair)pair.getData()).getFirst())) continue;
            found = pair;
            break;
        }
        if (found != null) {
            list2.remove(found);
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public synchronized boolean removeRoot(@NotNull String name, @NotNull List<? extends AbstractTreeNode<?>> elements2) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(21);
        }
        if (elements2 == null) {
            FavoritesManager.$$$reportNull$$$0(22);
        }
        Function<AbstractTreeNode, AbstractUrl> convertor = obj -> FavoritesManager.createUrlByElement(obj.getValue(), this.myProject);
        boolean result2 = true;
        for (AbstractTreeNode<?> element2 : elements2) {
            List<AbstractTreeNode<?>> path = TaskDefaultFavoriteListProvider.getPathToUsualNode(element2);
            result2 &= this.findListToRemoveFrom(name, path.subList(1, path.size()), convertor);
        }
        return result2;
    }

    private static TreeItem<Pair<AbstractUrl, String>> findNextItem(AbstractUrl url, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> list2) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : list2) {
            if (!url.equals(((Pair)treeItem.getData()).getFirst())) continue;
            return treeItem;
        }
        return null;
    }

    private boolean renameFavoritesList(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            FavoritesManager.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            FavoritesManager.$$$reportNull$$$0(24);
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.myName2FavoritesRoots.remove(oldName);
        int index = this.myFavoritesRootsOrder.indexOf(oldName);
        if (index != -1 && newName.length() > 0) {
            this.myFavoritesRootsOrder.remove(oldName);
            this.myFavoritesRootsOrder.remove(newName);
            this.myFavoritesRootsOrder.add(index, newName);
        }
        if (list2 != null && newName.length() > 0) {
            this.myName2FavoritesRoots.put(newName, list2);
            String description = this.myDescriptions.remove(oldName);
            if (description != null) {
                this.myDescriptions.put(newName, description);
            }
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public void setOrder(@NotNull String nameToOrder, String anchorName, boolean above) {
        if (nameToOrder == null) {
            FavoritesManager.$$$reportNull$$$0(25);
        }
        if (!this.canReorder(nameToOrder, anchorName, above)) {
            return;
        }
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toRemove2 = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        this.myFavoritesRootsOrder.add(above ? index : index + 1, nameToOrder);
        this.myFavoritesRootsOrder.remove(toRemove2 > index ? toRemove2 + 1 : toRemove2);
        this.rootsChanged();
    }

    public boolean canReorder(String nameToOrder, String anchorName, boolean above) {
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toReorder = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        if (index == -1 || toReorder == -1 || index == toReorder) {
            return false;
        }
        if (toReorder == index - 1 && above) {
            return false;
        }
        return toReorder != index + 1 || above;
    }

    @Nullable
    public FavoritesListProvider getListProvider(@Nullable String name) {
        return this.getProviders().get(name);
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            FavoritesManager.$$$reportNull$$$0(26);
        }
        this.myName2FavoritesRoots.clear();
        for (Element list2 : element2.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name = list2.getAttributeValue(ATTRIBUTE_NAME);
            List<TreeItem<Pair<AbstractUrl, String>>> roots = FavoritesManager.readRoots(list2, this.myProject);
            this.myName2FavoritesRoots.put(name, roots);
            this.myFavoritesRootsOrder.add(name);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
    }

    private static List<TreeItem<Pair<AbstractUrl, String>>> readRoots(Element list2, Project project) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> result2 = new ArrayList<TreeItem<Pair<AbstractUrl, String>>>();
        FavoritesManager.readFavoritesOneLevel(list2, project, result2);
        return result2;
    }

    private static void readFavoritesOneLevel(Element list2, Project project, Collection<? super TreeItem<Pair<AbstractUrl, String>>> result2) {
        for (Element favorite : list2.getChildren(FAVORITES_ROOT)) {
            String className = favorite.getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement(favorite, project);
            if (abstractUrl == null) continue;
            TreeItem treeItem = new TreeItem((Object)Pair.create((Object)abstractUrl, (Object)className));
            result2.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            FavoritesManager.readFavoritesOneLevel(favorite, project, treeItem.getChildren());
        }
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element2, Project project) {
        String type = element2.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element2.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element2.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrl(type, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (String name : this.myFavoritesRootsOrder) {
            Element list2 = new Element(ELEMENT_FAVORITES_LIST);
            list2.setAttribute(ATTRIBUTE_NAME, name);
            FavoritesManager.writeRoots(list2, (Collection<? extends TreeItem<Pair<AbstractUrl, String>>>)this.myName2FavoritesRoots.get(name));
            element2.addContent(list2);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
        return element2;
    }

    @Nullable
    public static AbstractUrl createUrlByElement(Object element2, Project project) {
        if (element2 instanceof SmartPsiElementPointer) {
            element2 = ((SmartPsiElementPointer)element2).getElement();
        }
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            String url = nodeProvider.getElementUrl(element2);
            if (url == null) continue;
            return new AbstractUrlFavoriteAdapter(url, nodeProvider.getElementModuleName(element2), nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrlByElement(element2);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static void writeRoots(Element element2, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> roots) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : roots) {
            AbstractUrl url = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (url == null) continue;
            Element list2 = new Element(FAVORITES_ROOT);
            url.write(list2);
            list2.setAttribute(CLASS_NAME, (String)((Pair)treeItem.getData()).getSecond());
            element2.addContent(list2);
            List children2 = treeItem.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            FavoritesManager.writeRoots(list2, children2);
        }
    }

    public String getFavoriteListName(@Nullable String currentSubId, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            FavoritesManager.$$$reportNull$$$0(27);
        }
        if (currentSubId != null && this.contains(currentSubId, vFile)) {
            return currentSubId;
        }
        for (String listName : this.myName2FavoritesRoots.keySet()) {
            if (!this.contains(listName, vFile)) continue;
            return listName;
        }
        return null;
    }

    public boolean contains(@NotNull String name, @NotNull VirtualFile vFile) {
        if (name == null) {
            FavoritesManager.$$$reportNull$$$0(28);
        }
        if (vFile == null) {
            FavoritesManager.$$$reportNull$$$0(29);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        HashSet find = new HashSet();
        ContentIterator contentIterator = fileOrDir -> {
            if (fileOrDir.getPath().equals(vFile.getPath())) {
                find.add(Boolean.TRUE);
            }
            return true;
        };
        List<TreeItem<Pair<AbstractUrl, String>>> urls = this.getFavoritesListRootUrls(name);
        for (TreeItem treeItem : urls) {
            NamedLibraryElement namedLibraryElement;
            Object[] files2;
            VirtualFile virtualFile;
            Object[] path;
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (abstractUrl == null || (path = abstractUrl.createPath(this.myProject)) == null || path.length < 1 || path[0] == null) continue;
            Object element2 = path[path.length - 1];
            if (element2 instanceof SmartPsiElementPointer) {
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((SmartPsiElementPointer)element2).getElement());
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element2 instanceof PsiElement) {
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element2));
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element2 instanceof Module) {
                ModuleRootManager.getInstance((Module)((Module)element2)).getFileIndex().iterateContent(contentIterator);
            }
            if (element2 instanceof LibraryGroupElement) {
                boolean inLibrary;
                boolean bl = inLibrary = ModuleRootManager.getInstance((Module)((LibraryGroupElement)element2).getModule()).getFileIndex().isInContent(vFile) && projectFileIndex.isInLibraryClasses(vFile);
                if (inLibrary) {
                    return true;
                }
            }
            if (element2 instanceof NamedLibraryElement && ArrayUtil.find((Object[])(files2 = (namedLibraryElement = (NamedLibraryElement)element2).getOrderEntry().getRootFiles(OrderRootType.CLASSES)), (Object)vFile) > -1) {
                return true;
            }
            if (element2 instanceof ModuleGroup) {
                ModuleGroup group = (ModuleGroup)element2;
                Collection<Module> modules = group.modulesInGroup(this.myProject, true);
                for (Module module : modules) {
                    ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent(contentIterator);
                }
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                if (!provider.elementContainsFile(element2, vFile)) continue;
                return true;
            }
            if (find.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void iterateTreeItems(Collection<? extends TreeItem<Pair<AbstractUrl, String>>> coll, Consumer<? super TreeItem<Pair<AbstractUrl, String>>> consumer) {
        ArrayDeque<? extends TreeItem<Pair<AbstractUrl, String>>> queue = new ArrayDeque<TreeItem<Pair<AbstractUrl, String>>>(coll);
        while (!queue.isEmpty()) {
            TreeItem<Pair<AbstractUrl, String>> item = queue.removeFirst();
            consumer.consume(item);
            List children2 = item.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            queue.addAll(children2);
        }
    }

    protected Collection<VirtualFile> getVirtualFiles(String listName, boolean recursively) {
        if (this.getListProvider(listName) != null) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        List<TreeItem<Pair<AbstractUrl, String>>> roots = this.myName2FavoritesRoots.get(listName);
        if (!recursively) {
            for (TreeItem<Pair<AbstractUrl, String>> item : roots) {
                VirtualFile file2 = this.getVirtualFile(item);
                if (file2 == null) continue;
                result2.add(file2);
            }
        } else {
            FavoritesManager.iterateTreeItems(roots, (Consumer<? super TreeItem<Pair<AbstractUrl, String>>>)((Consumer)arg_0 -> this.lambda$getVirtualFiles$4((Collection)result2, arg_0)));
        }
        return result2;
    }

    @Nullable
    private VirtualFile getVirtualFile(TreeItem<Pair<AbstractUrl, String>> item) {
        Pair data2 = (Pair)item.getData();
        Object[] path = ((AbstractUrl)data2.first).createPath(this.myProject);
        if (path != null && path.length == 1) {
            VirtualFile virtualFile;
            if (path[0] instanceof PsiFile && (virtualFile = ((PsiFile)path[0]).getVirtualFile()) != null && !virtualFile.isDirectory()) {
                return virtualFile;
            }
            if (path[0] instanceof File && (virtualFile = VfsUtil.findFileByIoFile((File)((File)path[0]), (boolean)false)) != null && !virtualFile.isDirectory()) {
                return virtualFile;
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$getVirtualFiles$4(Collection result2, TreeItem item) {
        VirtualFile file2 = this.getVirtualFile((TreeItem<Pair<AbstractUrl, String>>)item);
        if (file2 != null) {
            result2.add(file2);
        }
    }

    static {
        ourAbstractUrlProviders.add(new ModuleUrl(null, null));
        ourAbstractUrlProviders.add(new DirectoryUrl(null, null));
        ourAbstractUrlProviders.add(new ModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new PsiFileUrl(null));
        ourAbstractUrlProviders.add(new LibraryModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new NamedLibraryUrl(null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToOrder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoritesListRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listAdded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFavoritesListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNewList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireListeners";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFavoritesList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFavoritesListRootUrls";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComparator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canAddRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findListToRemoveFrom";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "renameFavoritesList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setOrder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteListName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRootsChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyRootsChangeAdapter() {
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyRootsChangeAdapter.$$$reportNull$$$0(0);
            }
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            PsiElement child2 = event.getChild();
            if (newParent instanceof PsiDirectory) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)newParent);
                if (module == null) {
                    return;
                }
                AbstractUrl childUrl = null;
                if (child2 instanceof PsiFile) {
                    childUrl = new PsiFileUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiFile)child2).getName());
                } else if (child2 instanceof PsiDirectory) {
                    childUrl = new DirectoryUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiDirectory)child2).getName(), module.getName());
                }
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    PsiFileUrl finalChildUrl = childUrl;
                    FavoritesManager.iterateTreeItems(roots, (Consumer<? super TreeItem<Pair<AbstractUrl, String>>>)item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) {
                            return;
                        }
                        Object element2 = path[path.length - 1];
                        if (element2 == child2 && finalChildUrl != null) {
                            item.setData((Object)Pair.create((Object)finalChildUrl, (Object)root.second));
                        } else if (element2 == oldParent) {
                            item.setData((Object)Pair.create((Object)((AbstractUrl)root.first).createUrlByElement(newParent), (Object)root.second));
                        }
                    });
                }
            }
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiElement psiElement;
            if (event == null) {
                MyRootsChangeAdapter.$$$reportNull$$$0(1);
            }
            if ((event.getPropertyName().equals("fileName") || event.getPropertyName().equals("directoryName")) && ((psiElement = event.getChild()) instanceof PsiFile || psiElement instanceof PsiDirectory)) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (module == null) {
                    return;
                }
                String url = ((PsiDirectory)psiElement.getParent()).getVirtualFile().getUrl() + "/" + event.getNewValue();
                AbstractUrl childUrl = psiElement instanceof PsiFile ? new PsiFileUrl(url) : new DirectoryUrl(url, module.getName());
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    FavoritesManager.iterateTreeItems(roots, (Consumer<? super TreeItem<Pair<AbstractUrl, String>>>)item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) {
                            return;
                        }
                        Object element2 = path[path.length - 1];
                        if (element2 == psiElement && psiElement instanceof PsiFile) {
                            item.setData((Object)Pair.create((Object)childUrl, (Object)root.second));
                        } else {
                            item.setData((Object)root);
                        }
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

