/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import a.g.lb;
import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.MutableRemoteCredentialsEx;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshUiData
implements MutableRemoteCredentialsEx,
Cloneable {
    @NotNull
    private SshConfig a;
    @NotNull
    private SshConfig.AuthData b;
    private static final long c = lb.a(-7687479902913516348L, 2540535712963290515L, MethodHandles.lookup().lookupClass()).a(116103981727204L);

    public SshUiData(@NotNull SshConfig config) {
        if (config == null) {
            SshUiData.a(0);
        }
        this(config, true);
    }

    public SshUiData(@NotNull SshConfig config, boolean initAuthDataFromPasswordSafe) {
        if (config == null) {
            SshUiData.a(1);
        }
        this(config, initAuthDataFromPasswordSafe ? config.getAuthDataFromForPasswordSafe() : new SshConfig.AuthData());
    }

    public SshUiData(@NotNull SshConfig config, @NotNull SshConfig.AuthData data) {
        if (config == null) {
            SshUiData.a(2);
        }
        if (data == null) {
            SshUiData.a(3);
        }
        this.a = config;
        this.b = data;
    }

    public String getName() {
        return this.a.getName();
    }

    @NotNull
    public SshConfig getConfig() {
        SshConfig sshConfig = this.a;
        if (sshConfig == null) {
            SshUiData.a(4);
        }
        return sshConfig;
    }

    public SshUiData clone() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.a = this.a.clone();
            sshUiData.b = this.b.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    protected SshUiData copy() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.a = this.a.clone();
            sshUiData.b = this.b.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public void setHost(@Nullable String host) {
        this.a.setHost(host);
    }

    public void setPort(int port2) {
        this.a.setPort(port2);
    }

    public void setLiteralPort(@Nullable String portText) {
        this.a.setLiteralPort(portText);
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshUiData.a(5);
        }
        this.a.setAuthType(authType);
    }

    @NotNull
    public String getHost() {
        String string = this.a.getHost();
        if (string == null) {
            SshUiData.a(6);
        }
        return string;
    }

    public int getPort() {
        return this.a.getPort();
    }

    @NotNull
    public String getLiteralPort() {
        String string = this.a.getLiteralPort();
        if (string == null) {
            SshUiData.a(7);
        }
        return string;
    }

    public void setLocalPort(int port2) {
        this.a.setLocalPort(port2);
    }

    public void setLiteralLocalPort(@Nullable String portText) {
        this.a.setLiteralLocalPort(portText);
    }

    public int getLocalPort() {
        return this.a.getLocalPort();
    }

    @Nullable
    public String getLiteralLocalPort() {
        return this.a.getLiteralLocalPort();
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.a.getAuthType();
        if (authType == null) {
            SshUiData.a(8);
        }
        return authType;
    }

    @Nullable
    public String getPassword() {
        return this.b.getPassword();
    }

    public void setPassword(@Nullable String password) {
        this.b.setPassword(password);
    }

    public boolean isStorePassword() {
        return this.b.isSavePassword();
    }

    public void setStorePassword(boolean savePassword) {
        this.b.setSavePassword(savePassword);
    }

    @NotNull
    public String getPrivateKeyFile() {
        String string = this.a.getKeyPath();
        if (string == null) {
            SshUiData.a(9);
        }
        return string;
    }

    public void setPrivateKeyFile(@Nullable String keyPath) {
        this.a.setKeyPath(keyPath);
    }

    @Nullable
    public String getPassphrase() {
        return this.b.getPassphrase();
    }

    public void setPassphrase(@Nullable String passphrase) {
        this.b.setPassphrase(passphrase);
    }

    public boolean isStorePassphrase() {
        return this.b.isSavePassphrase();
    }

    public void setStorePassphrase(boolean savePassphrase) {
        this.b.setSavePassphrase(savePassphrase);
    }

    public void setUserName(@Nullable String userName) {
        this.a.setUsername(userName);
    }

    @Nullable
    public String getUserName() {
        return this.a.getUsername();
    }

    public boolean hasEqualData(SshUiData item, boolean nullsSameAsEmptyString) {
        return this.a.getId().equals(item.getConfig().getId()) && this.hasEqualConfigAndAuthData(item, nullsSameAsEmptyString);
    }

    public boolean hasEqualConfigAndAuthData(SshUiData item, boolean nullsSameAsEmptyString) {
        return this.a.hasEqualData(item.a, nullsSameAsEmptyString) && this.b.hasEqualData(item.b, nullsSameAsEmptyString);
    }

    public void mergeAndSaveAuthData(SshConfig.AuthData data, boolean retainedExistingKeyPath, boolean retainedRegisteredKeyPath) {
        Pair<String, Boolean> pair = SshUiData.a(this.getPassword(), this.isStorePassword(), data.getPassword(), data.isSavePassword());
        this.setPassword((String)pair.first);
        this.setStorePassword((Boolean)pair.second);
        if (retainedExistingKeyPath && retainedRegisteredKeyPath) {
            Pair<String, Boolean> pair2 = SshUiData.a(this.getPassphrase(), this.isStorePassphrase(), data.getPassphrase(), data.isSavePassphrase());
            this.setPassphrase((String)pair2.first);
            this.setStorePassphrase((Boolean)pair2.second);
        } else if (retainedRegisteredKeyPath) {
            this.setPassphrase(data.getPassphrase());
            this.setStorePassphrase(data.isSavePassphrase());
        }
        this.saveAuthDataToPasswordSafe();
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentialsHolder remoteCredentialsHolder = new RemoteCredentialsHolder();
        remoteCredentialsHolder.copyFrom((RemoteCredentials)this);
        RemoteCredentialsHolder remoteCredentialsHolder2 = remoteCredentialsHolder;
        if (remoteCredentialsHolder2 == null) {
            SshUiData.a(10);
        }
        return remoteCredentialsHolder2;
    }

    @NotNull
    private static @NotNull Pair<String, @NotNull Boolean> a(String string, boolean bl2, String string2, boolean bl3) {
        if (StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)(bl2 || bl3 ? 1 : 0));
        }
        if (!StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)bl2);
        }
        if (StringUtil.isEmpty((String)string) && !StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string2, (Object)bl3);
        }
        if (bl2) {
            return new Pair((Object)string, (Object)true);
        }
        if (bl3) {
            return new Pair((Object)string2, (Object)true);
        }
        return new Pair((Object)string, (Object)false);
    }

    public boolean hasNoCredentials() {
        return this.b.hasNoCredentials(this.a.getAuthType());
    }

    public String toString() {
        long l2 = c ^ 0x60CAEDCA610AL;
        return "SshUiData{ myConfig='" + this.a.getName() + '\'' + ", myAuthData=" + this.b + '}';
    }

    @Nullable
    public static SshUiData findById(List<SshUiData> items, @NotNull String id2) {
        if (id2 == null) {
            SshUiData.a(11);
        }
        return items.stream().filter(sshUiData -> id2.equals(sshUiData.getConfig().getId())).findFirst().orElse(null);
    }

    @Nullable
    public static SshUiData findByName(List<SshUiData> items, @NotNull String name) {
        if (name == null) {
            SshUiData.a(12);
        }
        return items.stream().filter(sshUiData -> name.equals(sshUiData.getName())).findFirst().orElse(null);
    }

    @NotNull
    public @NotNull Pair<@NotNull Credentials, @NotNull Boolean> getCredentialsAndMemoryOnly() {
        long l2 = c ^ 0x6423826AAD2EL;
        switch (this.getAuthType()) {
            case OPEN_SSH: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), (String)null), (Object)true);
                if (pair == null) {
                    SshUiData.a(13);
                }
                return pair;
            }
            case PASSWORD: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), this.getPassword()), (Object)this.isStorePassword());
                if (pair == null) {
                    SshUiData.a(14);
                }
                return pair;
            }
            case KEY_PAIR: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), this.getPassphrase()), (Object)this.isStorePassphrase());
                if (pair == null) {
                    SshUiData.a(15);
                }
                return pair;
            }
        }
        throw new IllegalStateException("Unexpected auth type " + this.getAuthType());
    }

    public void setCredentials(@Nullable Credentials authCredentials, boolean saveCredentialsInPermanentStore) {
        this.b = SshConfig.AuthData.create(this.getAuthType(), authCredentials, saveCredentialsInPermanentStore);
    }

    public void loadFromCredentials(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            SshUiData.a(16);
        }
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)this);
        if (remoteCredentials instanceof MutableRemoteCredentialsEx) {
            this.setLiteralLocalPort(((MutableRemoteCredentialsEx)remoteCredentials).getLiteralLocalPort());
        } else {
            this.setLiteralLocalPort("");
        }
    }

    public void enforceEmptyCredentials() {
        long l2 = c ^ 0x2BA67FF0C985L;
        switch (this.getAuthType()) {
            case OPEN_SSH: {
                return;
            }
            case PASSWORD: {
                if (this.getPassword() == null) {
                    this.setPassword("");
                    this.saveAuthDataToPasswordSafe();
                }
                return;
            }
            case KEY_PAIR: {
                if (this.getPassphrase() == null) {
                    this.setPassphrase("");
                    this.saveAuthDataToPasswordSafe();
                }
                return;
            }
        }
        throw new IllegalStateException("Unexpected auth type " + this.getAuthType());
    }

    public void saveAuthDataToPasswordSafe() {
        this.a.saveAuthDataToPasswordSafe(this.b);
    }

    @Nullable
    public ErrorMessageAndField validate(boolean validateCredentials) {
        long l2 = c ^ 0x171CF561519L;
        try {
            ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.verify(false, "SSH", true, 500L, false, this.getHost(), this.getPort(), this.getUserName(), this.getAuthType(), this.getPrivateKeyFile(), SshBackendLibrary.get());
            if (errorMessageAndField != null) {
                return errorMessageAndField;
            }
            if (validateCredentials) {
                return SshCredentialsVerifier.validateAuthDataProvided(this.getUserName(), this.getAuthType(), this.getPassword(), this.getPrivateKeyFile(), this.getPassphrase(), 500L, SshBackendLibrary.get());
            }
            return null;
        }
        catch (TimeoutException timeoutException) {
            String string = SshBundle.message("ssh.verifier.message.connection.timeout", new Object[0]);
            if (timeoutException.getMessage() != null) {
                string = string + ":" + timeoutException.getMessage();
            }
            return new ErrorMessageAndField(string, null);
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SshUiData sshUiData = (SshUiData)o2;
        return this.a.equals(sshUiData.a) && this.b.equals(sshUiData.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    @NotNull
    public static SshUiData createData(@NotNull String name, @Nullable String id2, @NotNull SshConfigConfigurable.Visibility visibility) {
        if (name == null) {
            SshUiData.a(17);
        }
        if (visibility == null) {
            SshUiData.a(18);
        }
        SshConfig sshConfig = new SshConfig(true);
        if (id2 != null) {
            sshConfig.setId(id2);
        }
        sshConfig.setProjectLevel(visibility == SshConfigConfigurable.Visibility.Project);
        SshConfig.parseContent(name, sshConfig);
        return new SshUiData(sshConfig, false);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x6C66E9FEC542L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAndMemoryOnly";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCredentials";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

