/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularJSIndexingHandler;
import org.angularjs.index.AngularNamedItemDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularIndexUtil {
    public static final int BASE_VERSION = 65;
    public static final Function<JSImplicitElement, ResolveResult> JS_IMPLICIT_TO_RESOLVE_RESULT = JSResolveResult::new;
    private static final ConcurrentMap<String, Key<ParameterizedCachedValue<Collection<String>, Pair<Project, ID<String, ?>>>>> ourCacheKeys = ContainerUtil.newConcurrentMap();
    private static final AngularKeysProvider PROVIDER = new AngularKeysProvider();

    @Nullable
    public static JSImplicitElement resolve(@NotNull Project project, @NotNull StubIndexKey<? super String, JSImplicitElementProvider> index, @NotNull String lookupKey) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(0);
        }
        if (index == null) {
            AngularIndexUtil.$$$reportNull$$$0(1);
        }
        if (lookupKey == null) {
            AngularIndexUtil.$$$reportNull$$$0(2);
        }
        Ref result = new Ref(null);
        Processor processor = element -> {
            result.set(element);
            return !DialectDetector.isTypeScript((PsiElement)element);
        };
        AngularIndexUtil.multiResolve(project, GlobalSearchScope.allScope((Project)project), index, lookupKey, (Processor<? super JSImplicitElement>)processor);
        return (JSImplicitElement)result.get();
    }

    public static void multiResolve(@NotNull Project project, @NotNull StubIndexKey<? super String, JSImplicitElementProvider> index, @NotNull String lookupKey, @NotNull Processor<? super JSImplicitElement> processor) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(3);
        }
        if (index == null) {
            AngularIndexUtil.$$$reportNull$$$0(4);
        }
        if (lookupKey == null) {
            AngularIndexUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            AngularIndexUtil.$$$reportNull$$$0(6);
        }
        AngularIndexUtil.multiResolve(project, GlobalSearchScope.allScope((Project)project), index, lookupKey, processor);
    }

    public static void multiResolve(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull StubIndexKey<? super String, JSImplicitElementProvider> index, @NotNull String lookupKey, @NotNull Processor<? super JSImplicitElement> processor) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            AngularIndexUtil.$$$reportNull$$$0(8);
        }
        if (index == null) {
            AngularIndexUtil.$$$reportNull$$$0(9);
        }
        if (lookupKey == null) {
            AngularIndexUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            AngularIndexUtil.$$$reportNull$$$0(11);
        }
        StubIndex.getInstance().processElements(index, (Object)lookupKey, project, scope, JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData indexingData = provider.getIndexingData();
            if (indexingData != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (!element.getQualifiedName().equals(lookupKey) || (index == AngularDirectivesIndex.KEY || index == AngularDirectivesDocIndex.KEY) && (element.getType().isFunction() || !AngularJSIndexingHandler.isAngularRestrictions(element.getTypeString())) || processor.process((Object)element)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public static ResolveResult @NotNull [] multiResolveAngularNamedDefinitionIndex(@NotNull Project project, @NotNull ID<? super String, AngularNamedItemDefinition> INDEX, @NotNull String id, @NotNull Condition<? super VirtualFile> filter, boolean dirtyResolve) {
        FileBasedIndex instance;
        Collection files;
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(12);
        }
        if (INDEX == null) {
            AngularIndexUtil.$$$reportNull$$$0(13);
        }
        if (id == null) {
            AngularIndexUtil.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            AngularIndexUtil.$$$reportNull$$$0(15);
        }
        if ((files = (instance = FileBasedIndex.getInstance()).getContainingFiles(INDEX, (Object)id, GlobalSearchScope.allScope((Project)project))).isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                AngularIndexUtil.$$$reportNull$$$0(16);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List filtered = ContainerUtil.filter((Collection)files, filter);
        if (filtered.isEmpty()) {
            if (!dirtyResolve) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    AngularIndexUtil.$$$reportNull$$$0(17);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
        } else {
            files = filtered;
        }
        ArrayList<JSOffsetBasedImplicitElement> elements = new ArrayList<JSOffsetBasedImplicitElement>();
        for (VirtualFile file : files) {
            List values = instance.getValues(INDEX, (Object)id, GlobalSearchScope.fileScope((Project)project, (VirtualFile)file));
            for (AngularNamedItemDefinition value : values) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName((String)id);
                JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder((JSQualifiedName)qName, null);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) continue;
                elements.add(new JSOffsetBasedImplicitElement(elementBuilder, (int)value.getStartOffset(), psiFile));
            }
        }
        List list = ContainerUtil.map(elements, JS_IMPLICIT_TO_RESOLVE_RESULT);
        ResolveResult[] resolveResultArray = list.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            AngularIndexUtil.$$$reportNull$$$0(18);
        }
        return resolveResultArray;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull ID<String, ?> index, @NotNull Project project) {
        if (index == null) {
            AngularIndexUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(20);
        }
        String indexId = index.getName();
        Key key = (Key)ConcurrencyUtil.cacheOrGet(ourCacheKeys, (Object)indexId, (Object)Key.create((String)("angularjs.index." + indexId)));
        Pair pair = Pair.create((Object)project, index);
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, key, (ParameterizedCachedValueProvider)PROVIDER, false, (Object)pair);
        if (collection == null) {
            AngularIndexUtil.$$$reportNull$$$0(21);
        }
        return collection;
    }

    public static boolean hasAngularJS(@NotNull Project project) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        return AngularIndexUtil.getAngularJSVersion(project) > 0;
    }

    private static int getAngularJSVersion(@NotNull Project project) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(23);
        }
        if (DumbService.isDumb((Project)project) || NoAccessDuringPsiEvents.isInsideEventProcessing()) {
            return -1;
        }
        return (Integer)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            int version = -1;
            JSImplicitElement resolve = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, "ngMessages");
            if (resolve != null) {
                version = 13;
            } else {
                resolve = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, "ngModel");
                if (resolve != null) {
                    version = 12;
                }
            }
            if (resolve != null) {
                return CachedValueProvider.Result.create((Object)version, (Object[])new Object[]{resolve.getContainingFile()});
            }
            return CachedValueProvider.Result.create((Object)version, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }

    public static boolean hasFileReference(@NotNull PsiElement element, @NotNull PsiFile file) {
        if (element == null) {
            AngularIndexUtil.$$$reportNull$$$0(24);
        }
        if (file == null) {
            AngularIndexUtil.$$$reportNull$$$0(25);
        }
        VirtualFile vf = file.getOriginalFile().getViewProvider().getVirtualFile();
        if (element instanceof JSCallExpression) {
            JSExpression[] args = ((JSCallExpression)element).getArguments();
            if (args.length == 1 && args[0] instanceof JSLiteralExpression) {
                element = args[0];
            } else {
                return false;
            }
        }
        for (PsiReference ref : element.getReferences()) {
            PsiElement resolvedElement = ref.resolve();
            PsiFile resolvedFile = null;
            if (resolvedElement instanceof PsiFile) {
                resolvedFile = (PsiFile)resolvedElement;
            } else if (resolvedElement instanceof ES6ImportedBinding) {
                for (PsiElement importedElement : ((ES6ImportedBinding)resolvedElement).findReferencedElements()) {
                    if (!(importedElement instanceof PsiFile)) continue;
                    resolvedFile = (PsiFile)importedElement;
                    break;
                }
            }
            if (resolvedFile == null || !resolvedFile.getOriginalFile().getViewProvider().getVirtualFile().equals(vf)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<PsiElement> resolveLocally(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            AngularIndexUtil.$$$reportNull$$$0(26);
        }
        if (ref.getQualifier() == null && ref.getReferenceName() != null) {
            List list = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults((String)ref.getReferenceName(), (PsiElement)ref);
            if (list == null) {
                AngularIndexUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            AngularIndexUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static String convertRestrictions(@NotNull Project project, @NotNull String restrictions) {
        if (project == null) {
            AngularIndexUtil.$$$reportNull$$$0(29);
        }
        if (restrictions == null) {
            AngularIndexUtil.$$$reportNull$$$0(30);
        }
        if ("D".equals(restrictions)) {
            return AngularIndexUtil.getAngularJSVersion(project) >= 13 ? "E" : "_";
        }
        String string = restrictions;
        if (string == null) {
            AngularIndexUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupKey";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "INDEX";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/index/AngularIndexUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/index/AngularIndexUtil";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveAngularNamedDefinitionIndex";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRestrictions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveAngularNamedDefinitionIndex";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasAngularJS";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAngularJSVersion";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasFileReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertRestrictions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularKeysProvider
    implements ParameterizedCachedValueProvider<Collection<String>, Pair<Project, ID<String, ?>>> {
        private AngularKeysProvider() {
        }

        public CachedValueProvider.Result<Collection<String>> compute(Pair<Project, ID<String, ?>> projectAndIndex) {
            Project project = (Project)projectAndIndex.first;
            ID id = (ID)projectAndIndex.second;
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            FileBasedIndex fileIndex = FileBasedIndex.getInstance();
            StubIndex stubIndex = StubIndex.getInstance();
            Collection allKeys = id instanceof StubIndexKey ? stubIndex.getAllKeys((StubIndexKey)id, project) : fileIndex.getAllKeys(id, project);
            List filteredKeys = ContainerUtil.filter((Collection)allKeys, key -> id instanceof StubIndexKey ? !stubIndex.processElements((StubIndexKey)id, key, project, scope, PsiElement.class, element -> false) : !fileIndex.processValues(id, key, null, (file, value) -> false, scope));
            return CachedValueProvider.Result.create((Object)filteredKeys, (Object[])new Object[]{PsiManager.getInstance((Project)project).getModificationTracker()});
        }
    }
}

