/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.idCache.XmlFilterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angular2.lang.html.highlighting.Angular2HtmlHighlightingLexer;
import org.angular2.lang.html.lexer.Angular2HtmlTokenTypes;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.parser.Angular2HtmlElementTypes;
import org.angular2.lang.svg.Angular2SvgLanguage;

public class Angular2HtmlFilterLexer
extends BaseFilterLexer {
    private static final Set<Language> SUPPORTED_LANGUAGES = ContainerUtil.newHashSet((Object[])new Language[]{XMLLanguage.INSTANCE, HTMLLanguage.INSTANCE, Angular2HtmlLanguage.INSTANCE, Angular2SvgLanguage.INSTANCE, Angular2Language.INSTANCE, Language.ANY});
    private static final TokenSet IDENTIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES});
    private static final TokenSet COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.COMMENTS, TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS})});
    private static final TokenSet LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.LITERALS});
    private static final TokenSet SKIP_WORDS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SKIP_WORDS_SCAN_SET, XmlFilterLexer.NO_WORDS_TOKEN_SET, TokenSet.create((IElementType[])new IElementType[]{Angular2HtmlTokenTypes.INTERPOLATION_START, Angular2HtmlTokenTypes.INTERPOLATION_END, Angular2HtmlTokenTypes.EXPANSION_FORM_START, Angular2HtmlTokenTypes.EXPANSION_FORM_END, Angular2HtmlTokenTypes.EXPANSION_FORM_CASE_END, Angular2HtmlTokenTypes.EXPANSION_FORM_CASE_START, XmlTokenType.XML_COMMA, Angular2TokenTypes.ESCAPE_SEQUENCE, Angular2HtmlHighlightingLexer.EXPANSION_FORM_COMMA, Angular2HtmlHighlightingLexer.EXPRESSION_WHITE_SPACE})});

    protected Angular2HtmlFilterLexer(OccurrenceConsumer occurrenceConsumer, Lexer originalLexer) {
        super(originalLexer, occurrenceConsumer);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (!SKIP_WORDS.contains(tokenType)) {
            if (IDENTIFIERS.contains(tokenType)) {
                this.addOccurrenceInToken(1);
            } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                this.scanWordsInToken(24, tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, false);
            } else if (COMMENTS.contains(tokenType)) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (LITERALS.contains(tokenType)) {
                this.scanWordsInToken(4, false, false);
            } else if (Angular2HtmlElementTypes.ALL_ATTRIBUTES.contains(tokenType)) {
                Angular2AttributeNameParser.AttributeInfo info = Angular2AttributeNameParser.parse(this.myDelegate.getTokenText());
                if (info.type != Angular2AttributeType.REGULAR) {
                    this.addOccurrenceInToken(1, this.getTokenText().lastIndexOf(info.name), info.name.length());
                }
            } else if (tokenType != null && !SUPPORTED_LANGUAGES.contains(tokenType.getLanguage())) {
                boolean inComments = CacheUtil.isInComments((IElementType)tokenType);
                this.scanWordsInToken(inComments ? 2 : 24, true, false);
                if (inComments) {
                    this.advanceTodoItemCountsInToken();
                }
            } else {
                this.scanWordsInToken(16, false, false);
            }
        }
        this.myDelegate.advance();
    }
}

