/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeInsertHandler
implements InsertHandler<LookupElement> {
    private static final Set<Character> HTML_ATTR_NOT_ALLOWED_CHARS = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('='), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('/'), Character.valueOf('\u0000')});
    private final boolean myShouldRemoveLeftover;
    private final BooleanSupplier myShouldCompleteValue;
    private final String myAddSuffix;

    public Angular2AttributeInsertHandler(boolean shouldRemoveLeftover, @NotNull BooleanSupplier shouldCompleteValue, @Nullable String addSuffix) {
        if (shouldCompleteValue == null) {
            Angular2AttributeInsertHandler.$$$reportNull$$$0(0);
        }
        this.myShouldRemoveLeftover = shouldRemoveLeftover;
        this.myShouldCompleteValue = shouldCompleteValue;
        this.myAddSuffix = addSuffix;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        CharSequence text;
        if (context == null) {
            Angular2AttributeInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            Angular2AttributeInsertHandler.$$$reportNull$$$0(2);
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        if (this.myShouldRemoveLeftover) {
            char ch;
            int deleteOffset;
            boolean isHtml = context.getFile().getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
            CharSequence text2 = document.getCharsSequence();
            for (deleteOffset = caretOffset; deleteOffset < text2.length() && !Character.isWhitespace(ch = text2.charAt(deleteOffset)) && !HTML_ATTR_NOT_ALLOWED_CHARS.contains(Character.valueOf(ch)) && (isHtml || Character.isLetterOrDigit(ch)); ++deleteOffset) {
            }
            if (deleteOffset > caretOffset) {
                document.deleteString(caretOffset, deleteOffset);
            }
        }
        if (this.myShouldCompleteValue.getAsBoolean()) {
            XmlAttributeInsertHandler.INSTANCE.handleInsert(context, item);
        }
        if (this.myAddSuffix != null && !CharArrayUtil.regionMatches((CharSequence)(text = document.getCharsSequence()), (int)caretOffset, (CharSequence)this.myAddSuffix)) {
            document.insertString(caretOffset, (CharSequence)this.myAddSuffix);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldCompleteValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2AttributeInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

