/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class SwingWorker<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.concurrency.SwingWorker");
    private Future<?> myFuture;
    private volatile T value;
    private final ModalityState myModalityState = ModalityState.current();

    protected T getValue() {
        return this.value;
    }

    private void setValue(T x) {
        this.value = x;
    }

    public abstract T construct();

    public void finished() {
    }

    public void onThrowable() {
    }

    public void interrupt() {
        this.myFuture.cancel(true);
    }

    public T get() {
        if (this.myFuture == null) {
            throw new IllegalStateException("The start method has not been called.");
        }
        try {
            this.myFuture.get();
            return this.getValue();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public SwingWorker() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created SwingWorker " + this + " with modality state " + this.myModalityState);
        }
    }

    public void start() {
        this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.setValue(this.construct());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("construct() terminated for " + this);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                this.onThrowable();
                throw new RuntimeException(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoking 'finished' action for " + this);
            }
            ApplicationManager.getApplication().invokeLater(() -> this.finished(), this.myModalityState);
        });
    }
}

