/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.agent;

import com.jetbrains.performancePlugin.tracing.agent.AgentLogger;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import com.jetbrains.performancePlugin.tracing.agent.TracingClassVisitor;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

class TracingTransformer
implements ClassFileTransformer {
    private final Config myConfig;
    private final AgentLogger myLogger;

    TracingTransformer(Config config, AgentLogger logger) {
        this.myConfig = config;
        this.myLogger = logger;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (className == null) {
            return null;
        }
        String fullClassName = className.replace('/', '.');
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        if (loader == null || !this.myConfig.shouldTransform(fullClassName)) {
            return null;
        }
        try {
            loader.loadClass("com.intellij.diagnostic.tracing.MethodTracer");
        }
        catch (ClassNotFoundException e) {
            this.myLogger.error("Tracer cannot be found in classloader of " + className);
            return null;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(cr, 2);
        cr.accept((ClassVisitor)new TracingClassVisitor((ClassVisitor)cw, fullClassName, simpleClassName, this.myConfig, this.myLogger), 4);
        return cw.toByteArray();
    }
}

