/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing;

import com.intellij.codeInsight.hints.filtering.StringMatcher;
import com.intellij.codeInsight.hints.filtering.StringMatcherBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.tracing.MethodTracing;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class MethodPatternsConfig
implements Config {
    private final List<MethodPattern> myPatterns;

    private MethodPatternsConfig(List<MethodPattern> patterns) {
        this.myPatterns = patterns;
    }

    @Override
    public boolean shouldTransform(String className) {
        return this.myPatterns.stream().anyMatch(p -> p.matchesClassName(className));
    }

    @Override
    public boolean shouldTransform(String className, String methodName) {
        return this.myPatterns.stream().anyMatch(p -> p.matchesClassName(className) && p.matchesMethodName(methodName));
    }

    @Nullable
    public static Config readFromDocumentOrFile(File file) {
        List<String> lines = MethodPatternsConfig.linesFromDocument(file);
        return lines != null ? MethodPatternsConfig.config(lines) : MethodPatternsConfig.readFromFile(file);
    }

    @Nullable
    static Config readFromFile(File file) {
        try {
            return MethodPatternsConfig.config(FileUtil.loadLines((File)file));
        }
        catch (IOException e) {
            MethodTracing.LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static List<String> linesFromDocument(File file) {
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        Document document = vfile == null ? null : FileDocumentManager.getInstance().getDocument(vfile);
        return document == null ? null : Arrays.asList(StringUtil.splitByLines((String)document.getText()));
    }

    private static Config config(List<String> lines) {
        List<MethodPattern> patterns = lines.stream().map(s -> StringUtil.trim((String)s)).filter(s -> StringUtil.isNotEmpty((String)s)).map(s -> MethodPattern.fromLine(s.trim())).filter(Objects::nonNull).collect(Collectors.toList());
        return new MethodPatternsConfig(patterns);
    }

    private static class MethodPattern {
        StringMatcher classNameMatcher;
        StringMatcher methodNameMatcher;

        private MethodPattern(String className, String methodName) {
            this.classNameMatcher = StringMatcherBuilder.INSTANCE.create(className);
            this.methodNameMatcher = StringMatcherBuilder.INSTANCE.create(methodName);
        }

        public boolean matchesClassName(String name) {
            return this.classNameMatcher != null && this.classNameMatcher.isMatching(name);
        }

        public boolean matchesMethodName(String name) {
            return this.methodNameMatcher != null && this.methodNameMatcher.isMatching(name);
        }

        static MethodPattern fromLine(String line) {
            int methodNameSeparatorIdx = line.indexOf(35);
            if (methodNameSeparatorIdx < 0) {
                methodNameSeparatorIdx = line.lastIndexOf(46);
            }
            if (methodNameSeparatorIdx > 0) {
                String methodName = line.substring(methodNameSeparatorIdx + 1);
                String className = line.substring(0, methodNameSeparatorIdx);
                return new MethodPattern(className, methodName);
            }
            return null;
        }
    }
}

