/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class VCSCheckoutCommand
extends AbstractCommand {
    public static final String PREFIX = "%vcsCheckout";
    private final Project myProject;

    public VCSCheckoutCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            VCSCheckoutCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String branchName = this.getText().substring(PREFIX.length()).trim();
        List repositories = GitRepositoryManager.getInstance((Project)this.myProject).getRepositories();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Git.getInstance().checkout((GitRepository)repositories.get(0), branchName, null, true, false, new GitLineHandlerListener[0]);
            Disposable disposable = Disposer.newDisposable();
            final MessageBusConnection projectConnection = this.myProject.getMessageBus().connect(disposable);
            projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    projectConnection.disconnect();
                    actionCallback.setDone();
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                SaveAndSyncHandler.getInstance().refreshOpenFiles();
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            });
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/VCSCheckoutCommand", "<init>"));
    }
}

