/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

class DefaultCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;

    public DefaultCoordinateSequence(Coordinate[] coordinates) {
        if (Geometry.hasNullElements(coordinates)) {
            throw new IllegalArgumentException("Null coordinate");
        }
        this.coordinates = coordinates;
    }

    public DefaultCoordinateSequence(CoordinateSequence coordSeq) {
        this.coordinates = new Coordinate[coordSeq.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i] = coordSeq.getCoordinateCopy(i);
        }
    }

    public DefaultCoordinateSequence(int size) {
        this.coordinates = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            this.coordinates[i] = new Coordinate();
        }
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.coordinates[i]);
    }

    @Override
    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.coordinates[index].x;
        coord.y = this.coordinates[index].y;
    }

    @Override
    public double getX(int index) {
        return this.coordinates[index].x;
    }

    @Override
    public double getY(int index) {
        return this.coordinates[index].y;
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index].x;
            }
            case 1: {
                return this.coordinates[index].y;
            }
            case 2: {
                return this.coordinates[index].getZ();
            }
        }
        return Double.NaN;
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index].x = value;
                break;
            }
            case 1: {
                this.coordinates[index].y = value;
                break;
            }
            case 2: {
                this.coordinates[index].setZ(value);
            }
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public DefaultCoordinateSequence copy() {
        Coordinate[] cloneCoordinates = new Coordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            cloneCoordinates[i] = (Coordinate)this.coordinates[i].clone();
        }
        return new DefaultCoordinateSequence(cloneCoordinates);
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            env.expandToInclude(this.coordinates[i]);
        }
        return env;
    }

    public String toString() {
        if (this.coordinates.length > 0) {
            StringBuilder strBuilder = new StringBuilder(17 * this.coordinates.length);
            strBuilder.append('(');
            strBuilder.append(this.coordinates[0]);
            for (int i = 1; i < this.coordinates.length; ++i) {
                strBuilder.append(", ");
                strBuilder.append(this.coordinates[i]);
            }
            strBuilder.append(')');
            return strBuilder.toString();
        }
        return "()";
    }
}

