/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5Action;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceAppletTagAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceFontTagAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.documentation.HtmlCompatibilityData;
import com.intellij.xml.util.documentation.MdnDocumentationUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlDeprecatedTagInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourHtmlReplaceableTags = new HashSet<String>();
    @NonNls
    private static final Set<String> ourCssReplaceableTags;
    @NonNls
    private static final Set<String> ourDeprecatedTags;

    static void registerTag(@NotNull XmlTag tag, @NotNull String message, @NotNull ProblemsHolder holder, LocalQuickFix[] fixes, @NotNull ProblemHighlightType type) {
        XmlToken endTagNameElement;
        if (tag == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(0);
        }
        if (message == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(2);
        }
        if (type == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            return;
        }
        XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        String description = HtmlToolsBundle.message(message, new Object[0]) + " #loc";
        if (startTagNameElement != null) {
            holder.registerProblem((PsiElement)startTagNameElement, description, type, fixes);
        }
        if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null) {
            holder.registerProblem((PsiElement)endTagNameElement, description, type, fixes);
        }
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(5);
        }
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            LocalQuickFix[] fixes;
            String name = tag.isCaseSensitive() ? tag.getName() : StringUtil.toLowerCase((String)tag.getName());
            boolean deprecated = ourDeprecatedTags.contains(name);
            boolean deprecatedInHtml5 = MdnDocumentationUtil.isDeprecated((Map)HtmlCompatibilityData.getTagData((XmlTag)tag));
            if (!deprecated && !deprecatedInHtml5) {
                return;
            }
            boolean inHtml5 = HtmlUtil.isHtml5Context((XmlElement)tag);
            if (!(inHtml5 && deprecatedInHtml5 || !inHtml5 && deprecated)) {
                return;
            }
            if (tag.getDescriptor() == null) {
                return;
            }
            if ("font".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceFontTagAction()};
            } else if ("applet".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceAppletTagAction()};
            } else if (ourCssReplaceableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplaceableTags.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else {
                fixes = ourHtmlReplaceableTags.contains(name) ? new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)} : LocalQuickFix.EMPTY_ARRAY;
            }
            if (!(inHtml5 || deprecatedInHtml5 || HtmlUtil.hasNonHtml5Doctype((XmlElement)tag))) {
                LocalQuickFix[] newFixes = new LocalQuickFix[fixes.length + 1];
                System.arraycopy(fixes, 0, newFixes, 0, fixes.length);
                newFixes[fixes.length] = new SwitchToHtml5Action();
                fixes = newFixes;
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.deprecated.tag", holder, fixes, ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    static {
        ourHtmlReplaceableTags.addAll(Arrays.asList("s", "strike", "u", "menu"));
        ourCssReplaceableTags = new HashSet<String>();
        ourCssReplaceableTags.addAll(Arrays.asList("center", "u", "s", "strike", "xmp"));
        ourDeprecatedTags = new HashSet<String>();
        ourDeprecatedTags.addAll(Arrays.asList("applet", "basefont", "center", "dir", "font", "frame", "frameset", "isindex", "menu", "noframes", "s", "strike", "u", "xmp"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlDeprecatedTagInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

