/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.serviceContainer.BaseComponentAdapter;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.MyComponentAdapter;
import com.intellij.serviceContainer.ServiceComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.Collection;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0007\u001aN\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052<\u0010\t\u001a8\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00030\nH\u0007\u001a<\u0010\u0010\u001a\u00020\u0001\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00010\u0014H\u0007\u001a$\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0007\u00a8\u0006\u0018"}, d2={"checkCanceledIfNotInClassInit", "", "isWorkspaceComponent", "", "container", "Lorg/picocontainer/PicoContainer;", "componentImplementation", "Ljava/lang/Class;", "processAllImplementationClasses", "processor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "componentClass", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "plugin", "processComponentInstancesOfType", "T", "", "baseClass", "Lkotlin/Function1;", "processProjectComponents", "Ljava/util/function/BiConsumer;", "Lcom/intellij/openapi/components/ProjectComponent;", "intellij.platform.serviceContainer"})
public final class ContainerUtilKt {
    @ApiStatus.Internal
    public static final <T> void processComponentInstancesOfType(@NotNull PicoContainer container, @NotNull Class<T> baseClass, @NotNull Function1<? super T, Unit> processor) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(baseClass, (String)"baseClass");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        for (ComponentAdapter adapter : container.getComponentAdapters()) {
            if (!(adapter instanceof MyComponentAdapter) || !baseClass.isAssignableFrom(((MyComponentAdapter)adapter).getComponentImplementation())) continue;
            Object object = ((MyComponentAdapter)adapter).getInitializedInstance();
            if (object == null) {
                continue;
            }
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            processor.invoke(object);
        }
    }

    @ApiStatus.Internal
    public static final void processProjectComponents(@NotNull PicoContainer container, @NotNull BiConsumer<ProjectComponent, PluginDescriptor> processor) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        for (ComponentAdapter adapter : container.getComponentAdapters()) {
            ProjectComponent instance;
            if (!(adapter instanceof MyComponentAdapter)) continue;
            Object object = ((MyComponentAdapter)adapter).getInitializedInstance();
            if (!(object instanceof ProjectComponent)) {
                object = null;
            }
            if ((ProjectComponent)object == null) {
                continue;
            }
            processor.accept(instance, ((MyComponentAdapter)adapter).getPluginDescriptor());
        }
    }

    @ApiStatus.Internal
    public static final void processAllImplementationClasses(@NotNull PicoContainer container, @NotNull Function2<? super Class<?>, ? super PluginDescriptor, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Collection adapters = container.getComponentAdapters();
        if (adapters.isEmpty()) {
            return;
        }
        for (ComponentAdapter o : adapters) {
            Class clazz;
            PluginDescriptor pluginDescriptor;
            Class aClass = null;
            if (o instanceof ServiceComponentAdapter) {
                pluginDescriptor = ((ServiceComponentAdapter)o).getPluginDescriptor();
                try {
                    Class clazz2;
                    if (((ServiceComponentAdapter)o).isImplementationClassResolved()) {
                        clazz2 = ((ServiceComponentAdapter)o).getImplementationClass();
                    } else {
                        Class<?> clazz3 = Class.forName(((ServiceComponentAdapter)o).getDescriptor().getImplementation(), false, pluginDescriptor.getPluginClassLoader());
                        clazz2 = clazz3;
                        Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"Class.forName(o.descript\u2026riptor.pluginClassLoader)");
                    }
                    clazz = clazz2;
                }
                catch (Throwable e) {
                    ComponentManagerImplKt.getLOG().warn(e);
                    continue;
                }
                aClass = clazz;
                if (((Boolean)processor.invoke((Object)aClass, (Object)pluginDescriptor)).booleanValue()) continue;
                break;
            }
            if (o instanceof ExtensionComponentAdapter) continue;
            PluginDescriptor pluginDescriptor2 = pluginDescriptor = o instanceof BaseComponentAdapter ? ((BaseComponentAdapter)o).getPluginDescriptor() : null;
            if (pluginDescriptor == null && !(o instanceof DefaultPicoContainer.InstanceComponentAdapter)) continue;
            try {
                ComponentAdapter componentAdapter = o;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentAdapter, (String)"o");
                Intrinsics.checkExpressionValueIsNotNull((Object)componentAdapter.getComponentImplementation(), (String)"o.componentImplementation");
            }
            catch (Throwable e) {
                ComponentManagerImplKt.getLOG().warn(e);
                continue;
            }
            aClass = clazz;
            if (((Boolean)processor.invoke((Object)aClass, (Object)pluginDescriptor)).booleanValue()) continue;
            break;
        }
    }

    @ApiStatus.Internal
    public static final boolean isWorkspaceComponent(@NotNull PicoContainer container, @Nullable Class<?> componentImplementation) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        for (ComponentAdapter adapter : container.getComponentAdapters()) {
            if (!(adapter instanceof MyComponentAdapter) || !Intrinsics.areEqual(((MyComponentAdapter)adapter).getComponentImplementation(), componentImplementation)) continue;
            return ((MyComponentAdapter)adapter).isWorkspaceComponent();
        }
        return false;
    }

    public static final void checkCanceledIfNotInClassInit() {
        block4: {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                boolean bl;
                block3: {
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"e.stackTrace");
                    StackTraceElement[] $this$any$iv = stackTraceElementArray;
                    boolean $i$f$any = false;
                    StackTraceElement[] stackTraceElementArray2 = $this$any$iv;
                    int n = stackTraceElementArray2.length;
                    for (int i = 0; i < n; ++i) {
                        StackTraceElement element$iv;
                        StackTraceElement it = element$iv = stackTraceElementArray2[i];
                        boolean bl2 = false;
                        StackTraceElement stackTraceElement = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"it");
                        if (!Intrinsics.areEqual((Object)stackTraceElement.getMethodName(), (Object)"<clinit>")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block4;
                throw (Throwable)e;
            }
        }
    }
}

