/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.AbstractAuthenticatingGithubUrlGroupingAction;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends AbstractAuthenticatingGithubUrlGroupingAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_PERFORM_GITHUB_REBASE = "Can't perform GitHub rebase";
    private static final String UPSTREAM_REMOTE = "upstream";

    public GithubRebaseAction() {
        super("Rebase my GitHub fork", "Rebase your GitHub forked repository relative to the origin", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        if (e == null) {
            GithubRebaseAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GithubRebaseAction.$$$reportNull$$$0(2);
        }
        if (remote == null) {
            GithubRebaseAction.$$$reportNull$$$0(3);
        }
        if (remoteUrl == null) {
            GithubRebaseAction.$$$reportNull$$$0(4);
        }
        if (account == null) {
            GithubRebaseAction.$$$reportNull$$$0(5);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        GithubApiRequestExecutor.WithTokenAuth executor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project);
        if (executor == null) {
            return;
        }
        GHRepositoryPath repoPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repoPath == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Invalid Github remote: " + remoteUrl);
            return;
        }
        new RebaseTask(project, executor, Git.getInstance(), account.getServer(), repository, repoPath).queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "repository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "remote";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "remoteUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "account";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/github/GithubRebaseAction";
        objectArray[2] = "actionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RebaseTask
    extends Task.Backgroundable {
        @NotNull
        private final GithubApiRequestExecutor myRequestExecutor;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GithubServerPath myServer;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final GHRepositoryPath myRepoPath;

        RebaseTask(@NotNull Project project, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull Git git, @NotNull GithubServerPath server, @NotNull GitRepository repository, @NotNull GHRepositoryPath repoPath) {
            if (project == null) {
                RebaseTask.$$$reportNull$$$0(0);
            }
            if (requestExecutor == null) {
                RebaseTask.$$$reportNull$$$0(1);
            }
            if (git == null) {
                RebaseTask.$$$reportNull$$$0(2);
            }
            if (server == null) {
                RebaseTask.$$$reportNull$$$0(3);
            }
            if (repository == null) {
                RebaseTask.$$$reportNull$$$0(4);
            }
            if (repoPath == null) {
                RebaseTask.$$$reportNull$$$0(5);
            }
            super(project, "Rebasing GitHub Fork...");
            this.myRequestExecutor = requestExecutor;
            this.myGit = git;
            this.myServer = server;
            this.myRepository = repository;
            this.myRepoPath = repoPath;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            GHRepositoryPath userAndRepo;
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(6);
            }
            this.myRepository.update();
            String upstreamRemoteUrl = this.findUpstreamRemoteUrl();
            if (upstreamRemoteUrl == null) {
                indicator.setText("Configuring upstream remote...");
                LOG.info("Configuring upstream remote");
                upstreamRemoteUrl = this.configureUpstreamRemote(indicator);
                if (upstreamRemoteUrl == null) {
                    return;
                }
            }
            if ((userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl)) == null) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't validate upstream remote: " + upstreamRemoteUrl);
                return;
            }
            if (this.isUpstreamWithSameUsername(indicator, userAndRepo)) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream seems to be your own repository: " + upstreamRemoteUrl);
                return;
            }
            String name = this.getDefaultBranchName(indicator, userAndRepo);
            if (name == null) {
                return;
            }
            String onto = "upstream/" + name;
            LOG.info("Fetching upstream");
            indicator.setText("Fetching upstream...");
            if (!this.fetchParent()) {
                return;
            }
            LOG.info("Rebasing current branch");
            indicator.setText("Rebasing current branch onto " + onto + "...");
            this.rebaseCurrentBranch(indicator, onto);
        }

        @Nullable
        private String findUpstreamRemoteUrl() {
            return this.myRepository.getRemotes().stream().filter(remote -> remote.getName().equals(GithubRebaseAction.UPSTREAM_REMOTE) && remote.getFirstUrl() != null && this.myServer.matches(remote.getFirstUrl())).findFirst().map(GitRemote::getFirstUrl).orElse(null);
        }

        private boolean isUpstreamWithSameUsername(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath userAndRepo) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(7);
            }
            if (userAndRepo == null) {
                RebaseTask.$$$reportNull$$$0(8);
            }
            try {
                String username = this.myRequestExecutor.execute(indicator, GithubApiRequests.CurrentUser.get(this.myServer)).getLogin();
                return userAndRepo.getOwner().equals(username);
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't get user information");
                return true;
            }
        }

        @Nullable
        private String getDefaultBranchName(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath userAndRepo) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(9);
            }
            if (userAndRepo == null) {
                RebaseTask.$$$reportNull$$$0(10);
            }
            try {
                GithubRepo repo = this.myRequestExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, userAndRepo.getOwner(), userAndRepo.getRepository()));
                if (repo == null) {
                    GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't retrieve upstream information for " + userAndRepo);
                    return null;
                }
                return repo.getDefaultBranch();
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't retrieve upstream information for " + userAndRepo, e.getMessage());
                return null;
            }
        }

        @Nullable
        private String configureUpstreamRemote(@NotNull ProgressIndicator indicator) {
            GithubRepoDetailed repositoryInfo;
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(11);
            }
            if ((repositoryInfo = this.loadRepositoryInfo(indicator, this.myRepoPath)) == null) {
                return null;
            }
            if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
                GithubNotifications.showWarningURL(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
                return null;
            }
            String parentRepoUrl = GithubGitHelper.getInstance().getRemoteUrl(this.myServer, repositoryInfo.getParent().getFullPath());
            LOG.info("Adding GitHub parent as a remote host");
            indicator.setText("Adding GitHub parent as a remote host...");
            try {
                this.myGit.addRemote(this.myRepository, GithubRebaseAction.UPSTREAM_REMOTE, parentRepoUrl).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Could not configure \"upstream\" remote:\n" + e.getMessage());
                return null;
            }
            this.myRepository.update();
            return parentRepoUrl;
        }

        @Nullable
        private GithubRepoDetailed loadRepositoryInfo(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath fullPath) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(12);
            }
            if (fullPath == null) {
                RebaseTask.$$$reportNull$$$0(13);
            }
            try {
                GithubRepoDetailed repo = this.myRequestExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, fullPath.getOwner(), fullPath.getRepository()));
                if (repo == null) {
                    GithubNotifications.showError(this.myProject, "Repository " + fullPath.toString() + " was not found", "");
                }
                return repo;
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, "Can't load repository info", e);
                return null;
            }
        }

        private boolean fetchParent() {
            GitRemote remote = GitUtil.findRemoteByName((GitRepository)this.myRepository, (String)GithubRebaseAction.UPSTREAM_REMOTE);
            if (remote == null) {
                LOG.warn("Couldn't find remote  remoteName  in " + this.myRepository);
                return false;
            }
            return GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myRepository, remote).showNotificationIfFailed();
        }

        private void rebaseCurrentBranch(@NotNull ProgressIndicator indicator, String onto) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(14);
            }
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
                List<VirtualFile> rootsToSave = Collections.singletonList(this.myRepository.getRoot());
                GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance((Project)this.myProject).getSaveChangesPolicy();
                GitPreservingProcess process = new GitPreservingProcess(this.myProject, this.myGit, rootsToSave, "Rebasing", onto, saveMethod, indicator, () -> this.doRebaseCurrentBranch(indicator, onto));
                process.execute();
            }
        }

        private void doRebaseCurrentBranch(@NotNull ProgressIndicator indicator, String onto) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(15);
            }
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)this.myProject);
            GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, indicator);
            VirtualFile root = this.myRepository.getRoot();
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{onto});
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
            handler.addLineListener((GitLineHandlerListener)localChangesDetector);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
            String oldText = indicator.getText();
            indicator.setText("Rebasing onto " + onto + "...");
            GitCommandResult rebaseResult = this.myGit.runCommand(handler);
            indicator.setText(oldText);
            repositoryManager.updateRepository(root);
            if (rebaseResult.success()) {
                root.refresh(false, true);
                GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
            } else {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestExecutor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repoPath";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userAndRepo";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullPath";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/GithubRebaseAction$RebaseTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpstreamWithSameUsername";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDefaultBranchName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureUpstreamRemote";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadRepositoryInfo";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rebaseCurrentBranch";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doRebaseCurrentBranch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

