/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.jdbc.dialects.Postgres;
import com.intellij.database.remote.jdba.jdbc.dialects.Redshift;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.CRoachJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.GPlumJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.PgJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RsJdbcHelper;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.execution.rmi.ssl.SslSocketFactory;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgBaseJdbcHelper
extends JdbcHelperImpl {
    public static final String PG_TIMESTAMP_TZ = "timestamptz";
    static final String PG_TIME_TZ_NAME = "timetz";
    private static final String JSON = "json";
    private static final String JSONB = "jsonb";
    protected static final String VARBIT = "varbit";
    protected static final String BIT = "bit";
    private static final String TX_SNAPSHOT = "txid_snapshot";
    private static final Set<String> CUSTOM_OPERATOR_TYPES = PgBaseJdbcHelper.set("point", "polygon");
    protected static final Set<String> NATIVE_TYPES = PgBaseJdbcHelper.union(CUSTOM_OPERATOR_TYPES, new HashSet<String>(Arrays.asList("json", "jsonb", "varbit", "bit", "txid_snapshot", "line", "lseg", "box", "path", "circle", "hstore")));
    private static final Set<String> EDITABLE_TYPES = PgBaseJdbcHelper.union(NATIVE_TYPES, new HashSet<String>(Arrays.asList("pg_lsn", "tsquery", "tsvector")));
    private static final Set<String> PG_UNLIMITED_TYPES = new HashSet<String>(Arrays.asList("int2", "int4", "int8", "bool", "float4", "float8", "money", "date", "\"char\""));

    public PgBaseJdbcHelper(@NotNull Rdbms rdbms, @Nullable String version, @Nullable Connection connection) {
        if (rdbms == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(rdbms, version, connection);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        if (columnInfo == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        int type = columnInfo.getType();
        String typeName = columnInfo.getTypeName();
        String javaClassName = columnInfo.getJavaClassName();
        if (value == null) {
            statement.setNull(idx, PgBaseJdbcHelper.isUuidColumn(typeName) || this.isPgBitColumn(typeName) ? 1111 : type);
        } else if (type == 2003 && value instanceof Object[]) {
            statement.setArray(idx, typeName.replace("_", ""), (Object[])value);
        } else if (Arrays.asList("tid", "uuid", "money", "interval").contains(typeName) || this.isPgBitColumn(typeName) || type == 2003 || type == 2002 || type == 1111 || Object.class.getName().equals(javaClassName)) {
            boolean isBooleanBit;
            boolean bl = isBooleanBit = this.isPgBitColumn(typeName) && value instanceof Boolean;
            statement.setObject(idx, isBooleanBit ? (((Boolean)value).booleanValue() ? "1" : "0") : value, 1111);
        } else if (type == 2009) {
            statement.setObject(idx, this.escapeSqlRegex(value, needsEscaping), 2009);
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    protected boolean isPgBitColumn(@NotNull String name) {
        if (name == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        return this.myRdbms == Postgres.RDBMS && (VARBIT.equalsIgnoreCase(name) || BIT.equalsIgnoreCase(name));
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if (typeName != null && PG_TIMESTAMP_TZ.equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public boolean isZonedTimeColumn(@Nullable String typeName) {
        if (typeName != null && PG_TIME_TZ_NAME.equals(typeName)) {
            return true;
        }
        return super.isZonedTimeColumn(typeName);
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Object result;
        Class<?> c = o.getClass();
        String className = c.getName();
        if (className.startsWith("org.postgresql") && (result = PgBaseJdbcHelper.convertValue(className, o)) != null) {
            return result;
        }
        return super.convertValue(exporter, o);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if ("serial".equals(t)) {
            e.typeName = "int4";
            t = "int4";
        } else if ("bigserial".equals(t)) {
            e.typeName = "int8";
            t = "int8";
        } else if ("char".equals(t)) {
            e.typeName = "\"char\"";
            t = "\"char\"";
        }
        if (e.length == 0 || PG_UNLIMITED_TYPES.contains(t) || "numeric".equals(t) && e.length > 1000 || e.length == Integer.MAX_VALUE) {
            e.length = -1;
        } else if ("time".equals(t) || "timestamp".equals(t) || PG_TIME_TZ_NAME.equals(t) || PG_TIMESTAMP_TZ.equals(t) || "interval".equals(t)) {
            e.length = this.myRdbms == Redshift.RDBMS ? -1 : e.scale;
            e.scale = 0;
        }
    }

    private static boolean isUuidColumn(@Nullable String typeName) {
        return typeName != null && "uuid".equalsIgnoreCase(typeName);
    }

    private static Object convertValue(@NotNull String className, @NotNull Object o) {
        if (className == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (o == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (className.equals("org.postgresql.jdbc4.Jdbc4SQLXML") || className.equals("org.postgresql.jdbc.PgSQLXML")) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return null;
    }

    public static boolean isCustomOperatorType(@NotNull String typeName) {
        if (typeName == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        return CUSTOM_OPERATOR_TYPES.contains(typeName);
    }

    public static boolean canCompare(@NotNull String typeName) {
        if (typeName == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        return !JSON.equalsIgnoreCase(typeName) && !JSONB.equalsIgnoreCase(typeName) && !TX_SNAPSHOT.equalsIgnoreCase(typeName);
    }

    public static boolean isEditableType(@NotNull String typeName, int type) {
        if (typeName == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(9);
        }
        return EDITABLE_TYPES.contains(typeName) || type == 2002;
    }

    @NotNull
    private static Set<String> set(String ... elements) {
        if (elements == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(10);
        }
        return new THashSet(Arrays.asList(elements), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    private static Set<String> union(Set<String> ... elements) {
        if (elements == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        THashSet set = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (Set<String> element : elements) {
            set.addAll(element);
        }
        THashSet tHashSet = set;
        if (tHashSet == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!(JdbcNativeUtil.detectString(product, "redshift") || JdbcNativeUtil.detectString(product, "postgres") || JdbcNativeUtil.detectString(product, "greenplum"))) {
            return null;
        }
        String version = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select version()");
        JdbcNativeUtil.logInfo("version: " + version);
        return JdbcNativeUtil.detectString(version, Redshift.RDBMS.code) ? RsJdbcHelper.create(delegate, version) : (JdbcNativeUtil.detectString(version, "greenplum") ? GPlumJdbcHelper.create(delegate, version) : (JdbcNativeUtil.detectString(version, "cockroachdb") ? CRoachJdbcHelper.create(delegate, version) : PgJdbcHelper.create(delegate, productVer)));
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    @Nullable
    public JdbcSettings.SslMode[] supportedSslModes() {
        return JdbcSettings.SslMode.values();
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        if (sslMode == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(15);
        }
        PgBaseJdbcHelper.setIfEmpty(properties, "ssl", "true");
        PgBaseJdbcHelper.setIfEmpty(properties, "sslmode", PgBaseJdbcHelper.getSslMode(sslMode));
        PgBaseJdbcHelper.setIfEmpty(properties, "sslfactory", SslSocketFactory.class.getName());
    }

    @NotNull
    protected static String getSslMode(@NotNull JdbcSettings.SslMode sslMode) {
        if (sslMode == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(16);
        }
        switch (sslMode) {
            case VERIFY_FULL: {
                return "verify-full";
            }
            case REQUIRE: {
                return "require";
            }
        }
        return "verify-ca";
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            PgBaseJdbcHelper.$$$reportNull$$$0(17);
        }
        return PgBaseJdbcHelper.classNameContains(driver, "postgresql");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/PgBaseJdbcHelper";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/PgBaseJdbcHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPgBitColumn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCustomOperatorType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCompare";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEditableType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSslMode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaseInsensitiveStringHashingStrategy
    implements TObjectHashingStrategy<String> {
        public static final CaseInsensitiveStringHashingStrategy INSTANCE = new CaseInsensitiveStringHashingStrategy();

        private CaseInsensitiveStringHashingStrategy() {
        }

        public int computeHashCode(String s) {
            return s.toLowerCase(Locale.ENGLISH).hashCode();
        }

        public boolean equals(String s1, String s2) {
            return s1.equalsIgnoreCase(s2);
        }
    }
}

