/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.Mysql;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlIntermediateFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.GBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MariaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MemJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MysqlJdbcHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseJdbcHelper
extends JdbcHelperImpl {
    private final String myFlavour;
    private static final List<JdbcHelperImpl.PropertyReplacement> REPLACEMENTS = Collections.singletonList(new JdbcHelperImpl.PropertyReplacement("zeroDateTimeBehavior", Collections.singletonList(Couple.of((Object)"convertToNull", (Object)"CONVERT_TO_NULL"))){

        @Override
        @NotNull
        JdbcHelperImpl.PropertyReplacement.Direction getDirection(@NotNull Driver driver) {
            int version;
            if (driver == null) {
                1.$$$reportNull$$$0(0);
            }
            JdbcHelperImpl.PropertyReplacement.Direction direction = (version = driver.getMajorVersion()) >= 8 ? JdbcHelperImpl.PropertyReplacement.Direction.FORWARD : JdbcHelperImpl.PropertyReplacement.Direction.BACKWARD;
            if (direction == null) {
                1.$$$reportNull$$$0(1);
            }
            return direction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirection";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });

    public MysqlBaseJdbcHelper(@NotNull String flavour, @Nullable String version, @Nullable Connection connection) {
        if (flavour == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(Mysql.RDBMS, version, connection);
        this.myFlavour = flavour;
    }

    @Override
    @NotNull
    public String getDbmsName() {
        String string = this.myFlavour;
        if (string == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        return new MysqlIntermediateFacade(ds, 1, false, MysqlExceptionRecognizer.INSTANCE);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (columnInfo == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        String typeName = columnInfo.getTypeName();
        if (value instanceof String && "bit".equalsIgnoreCase(typeName)) {
            MysqlBaseJdbcHelper.setBits(statement, (String)value, idx);
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    private static void setBits(@NotNull RemotePreparedStatement statement, @NotNull String value, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (value == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        int length = value.length();
        int size = length / 8 + (length % 8 > 0 ? 1 : 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            int start = Math.max(length - (i + 1) * 8, 0);
            int end = length - i * 8;
            String substring = value.substring(start, end);
            bytes[size - i - 1] = (byte)Short.parseShort(substring, 2);
        }
        statement.setBytes(idx, bytes);
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\#";
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 91 && "YEAR".equals(typeName) && Short.class.getCanonicalName().equals(clazz)) {
            return 5;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        int precision;
        String typeName;
        if (options == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        if (metaData == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(9);
        }
        if ("bit".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index)) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return BitString.of(bytes);
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(10);
        }
        if (e.typeName == null) {
            return;
        }
        String us = " unsigned";
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)e.typeName, (CharSequence)us)) {
            int end = e.typeName.length() - us.length();
            e.typeSuffix = e.typeName.substring(end + 1);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        String[] stringArray;
        if (!JdbcNativeUtil.detectString(product, "MySQL") && !JdbcNativeUtil.detectString(product, "MariaDB")) {
            return null;
        }
        if (delegate == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = productVer;
            stringArray2[1] = productVer;
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            stringArray = JdbcNativeUtil.getStrings(delegate, "select version(), @@version_comment, database()");
        }
        String[] v = stringArray;
        String ver = v.length < 1 ? null : v[0];
        String verComment = v.length < 2 ? null : v[1];
        String db = v.length < 3 ? null : v[2];
        JdbcNativeUtil.logInfo("@@version_comment: " + verComment + "\nversion(): " + ver + "\ndatabase(): " + db);
        if (verComment == null && "gitbase".equals(db) && GBaseJdbcHelper.extractVersion(ver) != null) {
            return GBaseJdbcHelper.create(delegate, ver);
        }
        return JdbcNativeUtil.detectString(verComment, "MemSQL") ? MemJdbcHelper.create(delegate, delegate == null ? ver : JdbcNativeUtil.getString(delegate, "select @@memsql_version")) : (JdbcNativeUtil.detectString(ver, "MariaDB") || JdbcNativeUtil.detectString(verComment, "MariaDB") ? MariaJdbcHelper.create(delegate, ver) : MysqlJdbcHelper.create(delegate, ver));
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        return MysqlBaseJdbcHelper.classNameContains(driver, "mysql");
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "useSSL", "true");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "requireSSL", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            MysqlBaseJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", "true");
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "sslMode", MysqlBaseJdbcHelper.getSslMode(sslMode));
    }

    @Override
    @Nullable
    public JdbcSettings.SslMode[] supportedSslModes() {
        return JdbcSettings.SslMode.values();
    }

    @NotNull
    private static String getSslMode(@NotNull JdbcSettings.SslMode sslMode) {
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(15);
        }
        switch (sslMode) {
            case VERIFY_FULL: {
                return "VERIFY_IDENTITY";
            }
            case REQUIRE: {
                return "REQUIRED";
            }
        }
        return "VERIFY_CA";
    }

    @Override
    @Nullable
    public final Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(16);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(17);
        }
        if (extra == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(18);
        }
        return super.connect(driver, url, MysqlBaseJdbcHelper.replaceInvalidProperties(driver, properties, REPLACEMENTS), extra);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavour";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setBits";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSslMode";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

