/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdbc.helpers.Db2BaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2JdbcHelper
extends Db2BaseJdbcHelper {
    public Db2JdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of("DB2"), version, connection);
    }

    public Db2JdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return Db2JdbcHelper.extractVersion(version);
    }

    @NotNull
    static Db2JdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        return new Db2JdbcHelper(Db2JdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }
}

