/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing.handlers;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.CopyLinkToClipboardAction;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.ManageAccessRightsAction;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import com.jetbrains.intellij.datalore.util.StringUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH&J\b\u0010\u001c\u001a\u00020\u001bH\u0004J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingActionWithResultHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myNotebook", "Lcom/intellij/openapi/vfs/VirtualFile;", "mySuccessTitle", "", "myErrorTitle", "myErrorDescription", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "getMyAuthService", "()Lcom/jetbrains/intellij/datalore/services/AuthService;", "getMyNotebook", "()Lcom/intellij/openapi/vfs/VirtualFile;", "myNotebookTrimmedName", "getMyNotebookTrimmedName", "()Ljava/lang/String;", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "myPublishingService", "Lcom/jetbrains/intellij/datalore/services/PublishingService;", "getMyPublishingService", "()Lcom/jetbrains/intellij/datalore/services/PublishingService;", "handle", "", "onFail", "onSuccess", "notebookState", "Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState;", "datalore-intellij-plugin"})
public abstract class PublishingActionWithResultHandler {
    @NotNull
    private final AuthService myAuthService;
    @NotNull
    private final PublishingService myPublishingService;
    @NotNull
    private final String myNotebookTrimmedName;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myNotebook;
    private final String mySuccessTitle;
    private final String myErrorTitle;
    private final String myErrorDescription;

    @NotNull
    protected final AuthService getMyAuthService() {
        return this.myAuthService;
    }

    @NotNull
    protected final PublishingService getMyPublishingService() {
        return this.myPublishingService;
    }

    @NotNull
    protected final String getMyNotebookTrimmedName() {
        return this.myNotebookTrimmedName;
    }

    public abstract void handle();

    protected final void onSuccess(@NotNull PublishingService.PublishedNotebookState notebookState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookState), (String)"notebookState");
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getSUCCESS_ICON(), this.mySuccessTitle, null, DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.ok.description", notebookState.getLink()), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.UrlOpeningListener(false));
        notification.addAction((AnAction)new ManageAccessRightsAction(this.myProject, this.myNotebook, notification, DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.ok.manage_access_rights", new Object[0])));
        notification.addAction((AnAction)new CopyLinkToClipboardAction(this.myProject, notebookState.getLink(), DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.ok.copy_link", new Object[0])));
        notification.notify(this.myProject);
    }

    protected final void onFail() {
        Notification errorNotification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), this.myErrorTitle, null, this.myErrorDescription, NotificationType.ERROR, null);
        errorNotification.notify(this.myProject);
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected final VirtualFile getMyNotebook() {
        return this.myNotebook;
    }

    public PublishingActionWithResultHandler(@NotNull Project myProject, @NotNull VirtualFile myNotebook, @NotNull String mySuccessTitle, @NotNull String myErrorTitle, @NotNull String myErrorDescription) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)myNotebook, (String)"myNotebook");
        Intrinsics.checkParameterIsNotNull((Object)mySuccessTitle, (String)"mySuccessTitle");
        Intrinsics.checkParameterIsNotNull((Object)myErrorTitle, (String)"myErrorTitle");
        Intrinsics.checkParameterIsNotNull((Object)myErrorDescription, (String)"myErrorDescription");
        this.myProject = myProject;
        this.myNotebook = myNotebook;
        this.mySuccessTitle = mySuccessTitle;
        this.myErrorTitle = myErrorTitle;
        this.myErrorDescription = myErrorDescription;
        this.myAuthService = AuthService.Companion.getInstance();
        this.myPublishingService = PublishingService.Companion.getInstance(this.myProject);
        this.myNotebookTrimmedName = StringUtilKt.trimInMiddle$default(this.myNotebook, 0, 1, null);
    }
}

