/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import javax.annotation.Nonnull;
import org.fest.reflect.core.Reflection;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.util.Arrays;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class ApplicationLauncher {
    private final Class<?> applicationType;
    private String[] args = new String[0];

    @Nonnull
    public static ApplicationLauncher application(@Nonnull String applicationTypeName) {
        try {
            Class<?> applicationType = Thread.currentThread().getContextClassLoader().loadClass(applicationTypeName);
            return ApplicationLauncher.application(applicationType);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(Strings.concat((Object[])new Object[]{"Unable to load class ", Strings.quote((String)applicationTypeName)}), e);
        }
    }

    @Nonnull
    public static ApplicationLauncher application(@Nonnull Class<?> applicationType) {
        return new ApplicationLauncher(applicationType);
    }

    private ApplicationLauncher(@Nonnull Class<?> applicationType) {
        this.applicationType = applicationType;
    }

    @Nonnull
    public ApplicationLauncher withArgs(String ... newArgs) {
        this.args = (String[])Arrays.copyOf((Object[])Preconditions.checkNotNull((Object)newArgs));
        return this;
    }

    public void start() {
        Reflection.method((String)"main").withParameterTypes(new Class[]{String[].class}).in(this.applicationType).invoke(new Object[]{this.args});
    }
}

