/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableHeaderLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JTableHeaderDriver
extends JComponentDriver {
    private final JTableHeaderLocation location = new JTableHeaderLocation();

    public JTableHeaderDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex) {
        this.clickColumn(tableHeader, columnIndex, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, int columnIndex, @Nonnull MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location);
        this.robot.click(tableHeader, p, button, times);
        Pause.pause(400L);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        this.clickColumn(tableHeader, columnName, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern) {
        this.clickColumn(tableHeader, columnNamePattern, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nullable String columnName, @Nonnull MouseButton button, int times) {
        this.clickColumn(tableHeader, new StringTextMatcher(columnName), button, times);
    }

    @RunsInEDT
    public void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull Pattern columnNamePattern, @Nonnull MouseButton button, int times) {
        this.clickColumn(tableHeader, new PatternTextMatcher(columnNamePattern), button, times);
    }

    @RunsInEDT
    private void clickColumn(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher, @Nonnull MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtName(tableHeader, matcher, this.location());
        this.robot.click(tableHeader, p, button, times);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, int columnIndex) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location));
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtIndex(final @Nonnull JTableHeader tableHeader, final int columnIndex, final JTableHeaderLocation location) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Point p = location.pointAt(tableHeader, columnIndex);
                ComponentPreconditions.checkEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect(columnIndex));
                return p;
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nullable String columnName) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new StringTextMatcher(columnName), this.location()));
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTableHeader tableHeader, @Nonnull Pattern pattern) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new PatternTextMatcher(pattern), this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtName(final @Nonnull JTableHeader tableHeader, final @Nonnull TextMatcher matcher, final @Nonnull JTableHeaderLocation location) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Pair<Integer, Point> indexAndLocation = location.pointAt(tableHeader, matcher);
                ComponentPreconditions.checkEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect((Integer)indexAndLocation.first));
                return (Point)indexAndLocation.second;
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private JTableHeaderLocation location() {
        return this.location;
    }
}

