/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberStepHelper {
    private static final Logger LOG = Logger.getInstance((String)CucumberStepHelper.class.getName());

    public static PsiFile createStepDefinitionFile(@NotNull PsiDirectory dir, @NotNull String fileNameWithoutExtension, @NotNull BDDFrameworkType frameworkType) {
        CucumberJvmExtensionPoint ep;
        if (dir == null) {
            CucumberStepHelper.$$$reportNull$$$0(0);
        }
        if (fileNameWithoutExtension == null) {
            CucumberStepHelper.$$$reportNull$$$0(1);
        }
        if (frameworkType == null) {
            CucumberStepHelper.$$$reportNull$$$0(2);
        }
        if ((ep = CucumberStepHelper.getExtensionMap().get(frameworkType)) == null) {
            LOG.error(String.format("Unsupported step definition file type %s", frameworkType.toString()));
            return null;
        }
        return ep.getStepDefinitionCreator().createStepDefinitionContainer(dir, fileNameWithoutExtension);
    }

    public static boolean validateNewStepDefinitionFileName(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull BDDFrameworkType frameworkType) {
        if (directory == null) {
            CucumberStepHelper.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            CucumberStepHelper.$$$reportNull$$$0(4);
        }
        if (frameworkType == null) {
            CucumberStepHelper.$$$reportNull$$$0(5);
        }
        CucumberJvmExtensionPoint ep = CucumberStepHelper.getExtensionMap().get(frameworkType);
        assert (ep != null);
        return ep.getStepDefinitionCreator().validateNewStepDefinitionFileName(directory.getProject(), fileName);
    }

    @NotNull
    public static Collection<AbstractStepDefinition> findStepDefinitions(@NotNull PsiFile featureFile, @NotNull GherkinStep step) {
        Module module;
        if (featureFile == null) {
            CucumberStepHelper.$$$reportNull$$$0(6);
        }
        if (step == null) {
            CucumberStepHelper.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile)) == null) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                CucumberStepHelper.$$$reportNull$$$0(8);
            }
            return list;
        }
        String substitutedName = step.getSubstitutedName();
        if (substitutedName == null) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                CucumberStepHelper.$$$reportNull$$$0(9);
            }
            return list;
        }
        HashMap definitionsByClass = new HashMap();
        List<AbstractStepDefinition> allSteps = CucumberStepHelper.loadStepsFor(featureFile, module);
        for (AbstractStepDefinition stepDefinition : allSteps) {
            int newPatternLength;
            if (stepDefinition == null || !stepDefinition.matches(substitutedName) || !stepDefinition.supportsStep(step)) continue;
            Pattern currentLongestPattern = CucumberStepHelper.getPatternByDefinition((AbstractStepDefinition)definitionsByClass.get(stepDefinition.getClass()));
            Pattern newPattern = CucumberStepHelper.getPatternByDefinition(stepDefinition);
            int n = newPatternLength = newPattern != null ? newPattern.pattern().length() : -1;
            if (currentLongestPattern != null && currentLongestPattern.pattern().length() >= newPatternLength) continue;
            definitionsByClass.put(stepDefinition.getClass(), stepDefinition);
        }
        Collection<AbstractStepDefinition> collection = definitionsByClass.values();
        if (collection == null) {
            CucumberStepHelper.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Nullable
    private static Pattern getPatternByDefinition(@Nullable AbstractStepDefinition definition) {
        if (definition == null) {
            return null;
        }
        return definition.getPattern();
    }

    public static List<AbstractStepDefinition> findStepDefinitionsByPattern(@NotNull String pattern, @NotNull Module module) {
        if (pattern == null) {
            CucumberStepHelper.$$$reportNull$$$0(11);
        }
        if (module == null) {
            CucumberStepHelper.$$$reportNull$$$0(12);
        }
        List<AbstractStepDefinition> allSteps = CucumberStepHelper.loadStepsFor(null, module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (AbstractStepDefinition stepDefinition : allSteps) {
            String elementText = stepDefinition.getCucumberRegex();
            if (elementText == null || !elementText.equals(pattern)) continue;
            result.add(stepDefinition);
        }
        return result;
    }

    public static List<AbstractStepDefinition> getAllStepDefinitions(@NotNull PsiFile featureFile) {
        Module module;
        if (featureFile == null) {
            CucumberStepHelper.$$$reportNull$$$0(13);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile)) == null) {
            return Collections.emptyList();
        }
        return CucumberStepHelper.loadStepsFor(featureFile, module);
    }

    private static List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            CucumberStepHelper.$$$reportNull$$$0(14);
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (CucumberJvmExtensionPoint extension : CucumberStepHelper.getCucumberExtensions()) {
            result.addAll(extension.loadStepsFor(featureFile, module));
        }
        return result;
    }

    public static Set<CucumberStepDefinitionCreationContext> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            CucumberStepHelper.$$$reportNull$$$0(15);
        }
        HashSet<CucumberStepDefinitionCreationContext> result = new HashSet<CucumberStepDefinitionCreationContext>();
        for (CucumberJvmExtensionPoint ep : CucumberStepHelper.getCucumberExtensions()) {
            if (ep instanceof OptionalStepDefinitionExtensionPoint && !((OptionalStepDefinitionExtensionPoint)ep).participateInStepDefinitionCreation((PsiElement)featureFile)) continue;
            Collection<? extends PsiFile> psiFiles = ep.getStepDefinitionContainers(featureFile);
            BDDFrameworkType frameworkType = ep.getStepFileType();
            for (PsiFile psiFile : psiFiles) {
                result.add(new CucumberStepDefinitionCreationContext(psiFile, frameworkType));
            }
        }
        return result;
    }

    public static Map<BDDFrameworkType, CucumberJvmExtensionPoint> getExtensionMap() {
        HashMap<BDDFrameworkType, CucumberJvmExtensionPoint> result = new HashMap<BDDFrameworkType, CucumberJvmExtensionPoint>();
        for (CucumberJvmExtensionPoint e : CucumberStepHelper.getCucumberExtensions()) {
            result.put(e.getStepFileType(), e);
        }
        return result;
    }

    public static List<CucumberJvmExtensionPoint> getCucumberExtensions() {
        return CucumberJvmExtensionPoint.EP_NAME.getExtensionList();
    }

    public static int getExtensionCount() {
        return CucumberStepHelper.getCucumberExtensions().size();
    }

    public static boolean isGherkin6Supported(@NotNull Module module) {
        if (module == null) {
            CucumberStepHelper.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        for (CucumberJvmExtensionPoint ep : CucumberStepHelper.getCucumberExtensions()) {
            if (!ep.isGherkin6Supported(module)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/CucumberStepHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/CucumberStepHelper";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitionsByPattern";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllStepDefinitions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isGherkin6Supported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

