/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import com.jetbrains.python.templateLanguages.TemplatesService;
import com.jetbrains.web2py.Web2PyUtils;
import com.jetbrains.web2py.project.Web2PyProjectGenerator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Web2PyProjectConfigurator
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module[] modules;
        if (project == null) {
            Web2PyProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            Web2PyProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            Web2PyProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length > 0) {
            VirtualFile web2Py = baseDir.findChild("web2py");
            if (web2Py != null) {
                TemplatesService.getInstance((Module)modules[0]).setTemplateLanguage("Web2Py");
                Web2PyProjectConfigurator.addRunConfiguration(moduleRef, web2Py);
                Web2PyProjectGenerator.addWeb2PySourceRoots((Project)project, (VirtualFile)baseDir, (VirtualFile)web2Py);
                return;
            }
            VirtualFile gluon = baseDir.findChild("gluon");
            if (gluon != null) {
                TemplatesService.getInstance((Module)((Module)moduleRef.get())).setTemplateLanguage("Web2Py");
                Web2PyProjectConfigurator.addRunConfiguration(moduleRef, baseDir);
                return;
            }
            if (Web2PyUtils.isWeb2PyApp((VirtualFile)baseDir)) {
                Module module = (Module)moduleRef.get();
                VirtualFile parent = baseDir.getParent();
                if (parent == null) {
                    return;
                }
                if ((parent = parent.getParent()) == null) {
                    return;
                }
                gluon = parent.findChild("gluon");
                if (gluon != null) {
                    FacetLibraryConfigurator.attachPythonLibrary((Module)module, null, (String)"Web2Py Library", (List)Lists.newArrayList((Object[])new String[]{gluon.getPath()}));
                    Web2PyProjectConfigurator.addRunConfiguration(moduleRef, parent);
                }
                TemplatesService.getInstance((Module)((Module)moduleRef.get())).setTemplateLanguage("Web2Py");
            }
        }
    }

    private static void addRunConfiguration(@NotNull Ref<Module> moduleRef, @NotNull VirtualFile web2Py) {
        if (moduleRef == null) {
            Web2PyProjectConfigurator.$$$reportNull$$$0(3);
        }
        if (web2Py == null) {
            Web2PyProjectConfigurator.$$$reportNull$$$0(4);
        }
        PythonRunConfigurationParams configuration = PyRunConfigurationFactory.getInstance().createPythonScriptRunConfiguration((Module)moduleRef.get(), web2Py.getPath() + "/web2py.py");
        configuration.getBaseParams().setWorkingDirectory(web2Py.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "web2Py";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/web2py/Web2PyProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

