/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlTagNameSynchronizer
implements CommandListener,
EditorFactoryListener {
    private static final Key<Boolean> SKIP_COMMAND = Key.create((String)"tag.name.synchronizer.skip.command");
    private static final Logger LOG = Logger.getInstance(XmlTagNameSynchronizer.class);
    private static final Set<Language> SUPPORTED_LANGUAGES = ContainerUtil.set((Object[])new Language[]{HTMLLanguage.INSTANCE, XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE});
    private static final Key<TagNameSynchronizer> SYNCHRONIZER_KEY = Key.create((String)"tag_name_synchronizer");

    private XmlTagNameSynchronizer() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(CommandListener.TOPIC, (Object)this);
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Editor editor;
        Project project;
        if (event == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(0);
        }
        if ((project = (editor = event.getEditor()).getProject()) == null || !(editor instanceof EditorImpl)) {
            return;
        }
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        Language language = XmlTagNameSynchronizer.findXmlLikeLanguage(project, file);
        if (language != null) {
            new TagNameSynchronizer((EditorImpl)editor, project, language).listenForDocumentChanges();
        }
    }

    private static Language findXmlLikeLanguage(Project project, VirtualFile file) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = file != null && file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        if (psiFile != null) {
            for (Language language : psiFile.getViewProvider().getLanguages()) {
                if (ContainerUtil.find(SUPPORTED_LANGUAGES, arg_0 -> ((Language)language).isKindOf(arg_0)) == null && !HtmlUtil.supportsXmlTypedHandlers(psiFile) || language instanceof TemplateLanguage) continue;
                return language;
            }
        }
        return null;
    }

    private static TagNameSynchronizer @NotNull [] findSynchronizers(Document document) {
        if (!WebEditorOptions.getInstance().isSyncTagEditing() || document == null) {
            TagNameSynchronizer[] tagNameSynchronizerArray = TagNameSynchronizer.EMPTY;
            if (tagNameSynchronizerArray == null) {
                XmlTagNameSynchronizer.$$$reportNull$$$0(1);
            }
            return tagNameSynchronizerArray;
        }
        Object[] editors = EditorFactory.getInstance().getEditors(document);
        TagNameSynchronizer[] tagNameSynchronizerArray = (TagNameSynchronizer[])ContainerUtil.mapNotNull((Object[])editors, editor -> (TagNameSynchronizer)editor.getUserData(SYNCHRONIZER_KEY), (Object[])TagNameSynchronizer.EMPTY);
        if (tagNameSynchronizerArray == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(2);
        }
        return tagNameSynchronizerArray;
    }

    public void beforeCommandFinished(@NotNull CommandEvent event) {
        TagNameSynchronizer[] synchronizers;
        if (event == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(3);
        }
        for (TagNameSynchronizer synchronizer : synchronizers = XmlTagNameSynchronizer.findSynchronizers(event.getDocument())) {
            synchronizer.beforeCommandFinished();
        }
    }

    public static void runWithoutCancellingSyncTagsEditing(@NotNull Document document, @NotNull Runnable runnable) {
        if (document == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(4);
        }
        if (runnable == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(5);
        }
        document.putUserData(SKIP_COMMAND, (Object)Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            document.putUserData(SKIP_COMMAND, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findSynchronizers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeCommandFinished";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithoutCancellingSyncTagsEditing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TagNameSynchronizer
    implements DocumentListener {
        private static final Key<Couple<RangeMarker>> MARKERS_KEY = Key.create((String)"tag.name.synchronizer.markers");
        private static final TagNameSynchronizer[] EMPTY = new TagNameSynchronizer[0];
        private final PsiDocumentManagerBase myDocumentManager;
        private final Language myLanguage;
        private final EditorImpl myEditor;
        private final Project myProject;
        private boolean myApplying;

        private TagNameSynchronizer(EditorImpl editor, Project project, Language language) {
            this.myEditor = editor;
            this.myLanguage = language;
            this.myDocumentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
            this.myProject = project;
        }

        private void listenForDocumentChanges() {
            Disposable disposable = this.myEditor.getDisposable();
            DocumentEx document = this.myEditor.getDocument();
            document.addDocumentListener((DocumentListener)this, disposable);
            this.myEditor.putUserData(SYNCHRONIZER_KEY, (Object)this);
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                TagNameSynchronizer.$$$reportNull$$$0(0);
            }
            if (!WebEditorOptions.getInstance().isSyncTagEditing()) {
                return;
            }
            Document document = event.getDocument();
            Project project = Objects.requireNonNull(this.myEditor.getProject());
            if (this.myApplying || project.isDefault() || UndoManager.getInstance((Project)project).isUndoInProgress() || !PomModelImpl.isAllowPsiModification() || document.isInBulkUpdate()) {
                return;
            }
            int offset = event.getOffset();
            int oldLength = event.getOldLength();
            CharSequence fragment = event.getNewFragment();
            int newLength = event.getNewLength();
            if (document.getUserData(SKIP_COMMAND) == Boolean.TRUE) {
                return;
            }
            CaretImpl caret = this.myEditor.getCaretModel().getCurrentCaret();
            for (int i = 0; i < newLength; ++i) {
                if (this.isValidTagNameChar(fragment.charAt(i))) continue;
                TagNameSynchronizer.clearMarkers((Caret)caret);
                return;
            }
            Couple markers = (Couple)caret.getUserData(MARKERS_KEY);
            if (markers != null && !TagNameSynchronizer.fitsInMarker((Couple<RangeMarker>)markers, offset, oldLength)) {
                TagNameSynchronizer.clearMarkers((Caret)caret);
                markers = null;
            }
            if (markers == null) {
                RangeMarker support;
                PsiFile file = this.myDocumentManager.getPsiFile(document);
                if (file == null || this.myDocumentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                RangeMarker leader = this.createTagNameMarker((Caret)caret);
                if (leader == null) {
                    return;
                }
                leader.setGreedyToLeft(true);
                leader.setGreedyToRight(true);
                if (this.myDocumentManager.isUncommited(document)) {
                    this.myDocumentManager.commitDocument(document);
                }
                if ((support = this.findSupport(leader, file, document)) == null) {
                    return;
                }
                support.setGreedyToLeft(true);
                support.setGreedyToRight(true);
                markers = Couple.of((Object)leader, (Object)support);
                if (!TagNameSynchronizer.fitsInMarker((Couple<RangeMarker>)markers, offset, oldLength)) {
                    return;
                }
                caret.putUserData(MARKERS_KEY, (Object)markers);
            }
        }

        private static boolean fitsInMarker(Couple<RangeMarker> markers, int offset, int oldLength) {
            RangeMarker leader = (RangeMarker)markers.first;
            return leader.isValid() && offset >= leader.getStartOffset() && offset + oldLength <= leader.getEndOffset();
        }

        private static void clearMarkers(Caret caret) {
            Couple markers = (Couple)caret.getUserData(MARKERS_KEY);
            if (markers != null) {
                ((RangeMarker)markers.first).dispose();
                ((RangeMarker)markers.second).dispose();
                caret.putUserData(MARKERS_KEY, null);
            }
        }

        private RangeMarker createTagNameMarker(Caret caret) {
            int offset = caret.getOffset();
            DocumentEx document = this.myEditor.getDocument();
            CharSequence sequence = document.getCharsSequence();
            int start = -1;
            boolean seenColon = false;
            for (int i = offset - 1; i >= Math.max(0, offset - 50); --i) {
                try {
                    char c = sequence.charAt(i);
                    if (c == '<' || c == '/' && i > 0 && sequence.charAt(i - 1) == '<') {
                        start = i + 1;
                        break;
                    }
                    if (!this.isValidTagNameChar(c)) break;
                    seenColon |= c == ':';
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("incorrect offset:" + i + ", initial: " + offset, new Attachment[]{new Attachment("document.txt", sequence.toString())});
                    return null;
                }
            }
            if (start < 0) {
                return null;
            }
            int end = -1;
            for (int i = offset; i < Math.min(document.getTextLength(), offset + 50); ++i) {
                char c = sequence.charAt(i);
                if (!this.isValidTagNameChar(c) || seenColon && c == ':') {
                    end = i;
                    break;
                }
                seenColon |= c == ':';
            }
            if (end < 0 || start > end) {
                return null;
            }
            return document.createRangeMarker(start, end, true);
        }

        void beforeCommandFinished() {
            CaretAction action = caret -> {
                Couple markers = (Couple)caret.getUserData(MARKERS_KEY);
                if (markers == null || !((RangeMarker)markers.first).isValid() || !((RangeMarker)markers.second).isValid()) {
                    return;
                }
                DocumentEx document = this.myEditor.getDocument();
                Runnable apply = () -> TagNameSynchronizer.lambda$null$0(markers, (Document)document);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
                    if (lookup != null) {
                        lookup.performGuardedChange(apply);
                    } else {
                        apply.run();
                    }
                });
            };
            this.myApplying = true;
            try {
                if (this.myEditor.getCaretModel().isIteratingOverCarets()) {
                    action.perform((Caret)this.myEditor.getCaretModel().getCurrentCaret());
                } else {
                    this.myEditor.getCaretModel().runForEachCaret(action);
                }
            }
            finally {
                this.myApplying = false;
            }
        }

        private RangeMarker findSupport(RangeMarker leader, PsiFile file, Document document) {
            int offset;
            PsiElement element;
            TextRange support;
            TextRange leaderRange = new TextRange(leader.getStartOffset(), leader.getEndOffset());
            if (!TagNameSynchronizer.isSupportRangeValid(document, leaderRange, support = TagNameSynchronizer.findSupportRange(element = this.findNameElement(InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(offset = leader.getStartOffset()))))) && file.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                element = this.findNameElement(file.getViewProvider().findElementAt(offset, this.myLanguage));
                support = TagNameSynchronizer.findSupportRange(element);
            }
            if (!TagNameSynchronizer.isSupportRangeValid(document, leaderRange, support)) {
                return TagNameSynchronizer.findSupportForTagList(leader, element, document);
            }
            return document.createRangeMarker(support.getStartOffset(), support.getEndOffset(), true);
        }

        private PsiElement findNameElement(@Nullable PsiElement element) {
            return element instanceof OuterLanguageElement ? TemplateLanguageUtil.getSameLanguageTreeNext((PsiElement)element) : element;
        }

        private boolean isValidTagNameChar(char c) {
            if (XmlUtil.isValidTagNameChar(c)) {
                return true;
            }
            XmlExtension extension = this.getXmlExtension();
            if (extension == null) {
                return false;
            }
            return extension.isValidTagNameChar(c);
        }

        @Nullable
        private XmlExtension getXmlExtension() {
            PsiFile psiFile;
            DocumentEx document = this.myEditor.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile((Document)document);
            PsiFile psiFile2 = psiFile = file != null && file.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
            if (psiFile == null) {
                return null;
            }
            return XmlExtension.getExtension(psiFile);
        }

        private static RangeMarker findSupportForTagList(RangeMarker leader, PsiElement element, Document document) {
            PsiElement first;
            PsiElement last;
            if (leader.getStartOffset() != leader.getEndOffset() || element == null) {
                return null;
            }
            PsiElement support = null;
            if ("<>".equals(element.getText()) && "</>".equals((last = element.getParent().getLastChild()).getText())) {
                support = last;
            }
            if ("</>".equals(element.getText()) && "<>".equals((first = element.getParent().getFirstChild()).getText())) {
                support = first;
            }
            if (support != null) {
                TextRange range = support.getTextRange();
                return document.createRangeMarker(range.getEndOffset() - 1, range.getEndOffset() - 1, true);
            }
            return null;
        }

        private static boolean isSupportRangeValid(@NotNull Document document, @NotNull TextRange leader, @Nullable TextRange support) {
            if (document == null) {
                TagNameSynchronizer.$$$reportNull$$$0(1);
            }
            if (leader == null) {
                TagNameSynchronizer.$$$reportNull$$$0(2);
            }
            if (support == null) {
                return false;
            }
            return document.getText(leader).equals(document.getText(support));
        }

        @Nullable
        private static TextRange findSupportRange(@Nullable PsiElement leader) {
            if (leader == null || TreeUtil.findSibling((ASTNode)leader.getNode(), (IElementType)XmlTokenType.XML_TAG_END) == null) {
                return null;
            }
            PsiElement support = RenameTagBeginOrEndIntentionAction.findOtherSide(leader, false);
            if (support == null || leader == support) {
                support = RenameTagBeginOrEndIntentionAction.findOtherSide(leader, true);
            }
            if (support == null) {
                return null;
            }
            int start = TagNameSynchronizer.findSupportRangeStart(support);
            int end = TagNameSynchronizer.findSupportRangeEnd(support);
            TextRange supportRange = TextRange.create((int)start, (int)end);
            return InjectedLanguageManager.getInstance((Project)leader.getProject()).injectedToHost((PsiElement)leader.getContainingFile(), supportRange);
        }

        private static int findSupportRangeStart(@NotNull PsiElement support) {
            if (support == null) {
                TagNameSynchronizer.$$$reportNull$$$0(3);
            }
            PsiElement current = support;
            while (current.getPrevSibling() instanceof OuterLanguageElement) {
                current = current.getPrevSibling();
            }
            return current.getTextRange().getStartOffset();
        }

        private static int findSupportRangeEnd(@NotNull PsiElement support) {
            if (support == null) {
                TagNameSynchronizer.$$$reportNull$$$0(4);
            }
            PsiElement current = support;
            while (current.getNextSibling() instanceof OuterLanguageElement) {
                current = current.getNextSibling();
            }
            return current.getTextRange().getEndOffset();
        }

        private static /* synthetic */ void lambda$null$0(Couple markers, Document document) {
            RangeMarker leader = (RangeMarker)markers.first;
            RangeMarker support = (RangeMarker)markers.second;
            if (document.getTextLength() < leader.getEndOffset()) {
                return;
            }
            String name = document.getText(new TextRange(leader.getStartOffset(), leader.getEndOffset()));
            if (document.getTextLength() >= support.getEndOffset() && !name.equals(document.getText(new TextRange(support.getStartOffset(), support.getEndOffset())))) {
                document.replaceString(support.getStartOffset(), support.getEndOffset(), (CharSequence)name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leader";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$TagNameSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupportRangeValid";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findSupportRangeStart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findSupportRangeEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

