/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPivotedQueryExpressionImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlScopeProcessor
implements PsiScopeProcessor {
    public static final PsiScopeProcessor.Event EXPECTED_TYPE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event IGNORE_TYPE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event STRICT_TYPE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event RESOLVE_CONTEXT = new PsiScopeProcessor.Event(){};
    public final SqlLanguageDialectEx dialect;
    public final List<DbDataSource> dataSources;
    public final String referenceName;
    public final PsiElement place;
    private Set<ObjectKind> myExpectedTypes;
    private Set<ObjectKind> myIgnoredTypes;
    private Set<ObjectKind> myEffectiveTypes;
    private Set<ObjectKind> myExpectedParentTypes;
    private boolean myStrict;
    private final Condition<DasObject> myObjectFilter;

    public SqlScopeProcessor(@Nullable String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources2, @Nullable PsiElement place) {
        if (dialect == null) {
            SqlScopeProcessor.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(1);
        }
        this.myExpectedTypes = Collections.singleton(SqlDbElementType.ANY);
        this.myIgnoredTypes = Collections.emptySet();
        this.myEffectiveTypes = null;
        this.myExpectedParentTypes = null;
        this.myStrict = false;
        this.dialect = dialect;
        this.dataSources = dataSources2;
        this.referenceName = referenceName;
        this.place = place;
        this.myObjectFilter = dataSources2.isEmpty() ? Conditions.alwaysTrue() : (Condition)JBIterable.from(dataSources2).reduce((Object)Conditions.alwaysFalse(), (cond, ds) -> Conditions.or((Condition)cond, (Condition)((Condition)ObjectUtils.notNull(DatabaseStructure.buildFilter((DasDataSource)ds), (Object)Conditions.alwaysTrue()))));
    }

    public abstract boolean isResultEmpty();

    @Nullable
    private static DasObject getTarget(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(2);
        }
        if (element2 instanceof DasObject) {
            return (DasObject)element2;
        }
        PomTarget target = SqlImplUtil.getPomTarget(element2);
        return target instanceof DasObject ? (DasObject)target : null;
    }

    public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
        DasObject target;
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(3);
        }
        if (state == null) {
            SqlScopeProcessor.$$$reportNull$$$0(4);
        }
        if ((target = SqlScopeProcessor.getTarget(element2)) != null && !this.myObjectFilter.value((Object)target)) {
            return true;
        }
        return this.executeTarget(target, element2, null, null, state);
    }

    public abstract boolean executeTarget(@Nullable DasObject var1, @NotNull PsiElement var2, @Nullable SqlType var3, @Nullable Boolean var4, @NotNull ResolveState var5);

    protected boolean checkType(@NotNull Object element2, @Nullable SqlType forcedSqlType) {
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(5);
        }
        return this.checkType(element2, forcedSqlType, this.getExpectedTypes(), this.myIgnoredTypes, false);
    }

    protected boolean checkType(@NotNull Object element2, @Nullable SqlType forcedSqlType, @NotNull Set<ObjectKind> forcedExpectedTypes, @NotNull Set<ObjectKind> forcedIgnoredTypes, boolean acceptUnresolvedSynonyms) {
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(6);
        }
        if (forcedExpectedTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(7);
        }
        if (forcedIgnoredTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(8);
        }
        if (forcedSqlType instanceof SqlTableType) {
            return true;
        }
        if (SqlType.Category.REFERENCE.is(forcedSqlType)) {
            return true;
        }
        if (forcedSqlType != null) {
            return forcedExpectedTypes.contains(SqlDbElementType.COLUMN) || forcedExpectedTypes.contains(SqlDbElementType.VARIABLE) || forcedExpectedTypes.contains(SqlDbElementType.ANY);
        }
        return this.acceptsElement(element2, this.dialect, forcedExpectedTypes, forcedIgnoredTypes, this.myStrict, acceptUnresolvedSynonyms, this.place);
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SqlScopeProcessor.$$$reportNull$$$0(9);
        }
        if (event == EXPECTED_TYPE) {
            this.myExpectedTypes = (Set)associated;
            this.myExpectedParentTypes = null;
            this.myEffectiveTypes = null;
        }
        if (event == IGNORE_TYPE) {
            if (!(this.myIgnoredTypes instanceof LinkedHashSet)) {
                this.myIgnoredTypes = new LinkedHashSet<ObjectKind>(this.myIgnoredTypes);
            }
            this.myIgnoredTypes.addAll((Collection)associated);
            this.myExpectedParentTypes = null;
            this.myEffectiveTypes = null;
        } else if (event == STRICT_TYPE) {
            this.myStrict = (Boolean)associated;
        }
    }

    public boolean isExpected(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlScopeProcessor.$$$reportNull$$$0(10);
        }
        if (this.myIgnoredTypes.contains(kind)) {
            return false;
        }
        Set<ObjectKind> expected = this.getExpectedTypes();
        return expected.contains(kind) || expected.contains(SqlDbElementType.ANY);
    }

    @NotNull
    public Set<ObjectKind> getInitialExpectedTypes() {
        Set<ObjectKind> set = this.myExpectedTypes;
        if (set == null) {
            SqlScopeProcessor.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    protected Set<ObjectKind> getIgnoredTypes() {
        Set<ObjectKind> set = this.myIgnoredTypes;
        if (set == null) {
            SqlScopeProcessor.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes() {
        if (this.myEffectiveTypes == null) {
            if (this.myIgnoredTypes.isEmpty()) {
                this.myEffectiveTypes = this.myExpectedTypes;
            } else {
                this.myEffectiveTypes = new LinkedHashSet<ObjectKind>(this.myExpectedTypes);
                this.myEffectiveTypes.removeAll(this.myIgnoredTypes);
            }
        }
        Set<ObjectKind> set = this.myExpectedTypes;
        if (set == null) {
            SqlScopeProcessor.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<ObjectKind> getExpectedParentTypes() {
        if (this.myExpectedParentTypes == null) {
            this.myExpectedParentTypes = new HashSet<ObjectKind>();
            for (ObjectKind kind : this.getExpectedTypes()) {
                SqlImplUtil.getParentTypes(this.dialect, kind, 1, 1, Collections.emptySet(), this.myExpectedParentTypes);
            }
            for (ObjectKind kind : ObjectKind.ourKinds.values()) {
                if (!this.mayAccept(kind)) continue;
                SqlImplUtil.getParentTypes(this.dialect, kind, 1, 1, Collections.emptySet(), this.myExpectedParentTypes);
            }
        }
        Set<ObjectKind> set = this.myExpectedParentTypes;
        if (set == null) {
            SqlScopeProcessor.$$$reportNull$$$0(14);
        }
        return set;
    }

    public static boolean acceptsElement(@NotNull Object element2, @NotNull SqlLanguageDialect dialect, @NotNull ObjectKind expectedType, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place) {
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            SqlScopeProcessor.$$$reportNull$$$0(16);
        }
        if (expectedType == null) {
            SqlScopeProcessor.$$$reportNull$$$0(17);
        }
        return SqlScopeProcessor.acceptsElement(element2, SqlScopeProcessor.getElementType(element2), dialect, Collections.singleton(expectedType), strict, acceptUnresolvedSynonyms, place, false);
    }

    private boolean acceptsElement(@NotNull Object element2, @NotNull SqlLanguageDialect dialect, @NotNull Set<ObjectKind> expectedTypes, @NotNull Set<ObjectKind> ignoredTypes, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place) {
        ObjectKind t;
        if (element2 == null) {
            SqlScopeProcessor.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlScopeProcessor.$$$reportNull$$$0(19);
        }
        if (expectedTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(20);
        }
        if (ignoredTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(21);
        }
        if (ignoredTypes.contains(t = SqlScopeProcessor.getElementType(element2))) {
            return false;
        }
        return SqlScopeProcessor.acceptsElement(element2, t, dialect, expectedTypes, strict, acceptUnresolvedSynonyms, place, this.referenceName == null);
    }

    public boolean mayAccept(@NotNull ObjectKind t) {
        if (t == null) {
            SqlScopeProcessor.$$$reportNull$$$0(22);
        }
        return SqlScopeProcessor.acceptsElement(null, t, this.dialect, this.getExpectedTypes(), this.myStrict, true, this.place, this.referenceName == null);
    }

    public boolean mayAcceptParent(@NotNull ObjectKind t) {
        if (t == null) {
            SqlScopeProcessor.$$$reportNull$$$0(23);
        }
        return SqlScopeProcessor.acceptsElement(null, t, this.dialect, this.getExpectedParentTypes(), false, true, null, this.referenceName == null);
    }

    public static boolean acceptsElement(@Nullable Object element2, @NotNull ObjectKind t, @NotNull SqlLanguageDialect dialect, @NotNull Set<ObjectKind> expectedTypes, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place, boolean isCompletion) {
        if (t == null) {
            SqlScopeProcessor.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            SqlScopeProcessor.$$$reportNull$$$0(25);
        }
        if (expectedTypes == null) {
            SqlScopeProcessor.$$$reportNull$$$0(26);
        }
        if (dialect.isResolveTargetNotAccepted(element2, t, expectedTypes, place, false, isCompletion)) {
            return false;
        }
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        if (t == SqlDbElementType.SYNONYM && !expectedTypes.contains(t)) {
            if (element2 == null) {
                return true;
            }
            t = SqlImplUtil.getKindSynonymAware((DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class));
            if (t == SqlDbElementType.ANY && acceptUnresolvedSynonyms) {
                return true;
            }
        }
        if (expectedTypes.contains(t)) {
            return true;
        }
        if (t == SqlDbElementType.LOCAL_ALIAS) {
            if (expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.VARIABLE)) {
                return true;
            }
            if (expectedTypes.contains(SqlDbElementType.COLUMN)) {
                PsiElement grandParent;
                if (element2 == null) {
                    return true;
                }
                PsiElement parent2 = element2 instanceof PsiElement ? ((PsiElement)element2).getParent() : null;
                PsiElement psiElement = grandParent = parent2 == null ? null : parent2.getParent();
                if (parent2 instanceof SqlClause && grandParent instanceof SqlPivotedQueryExpressionImpl) {
                    return true;
                }
                if (parent2 instanceof SqlSelectClause || parent2 instanceof SqlReturningClause || element2 instanceof SqlFileImpl.FakeDefinition) {
                    return true;
                }
            }
        }
        if (strict) {
            return dialect.isResolveTargetAccepted((PsiElement)ObjectUtils.tryCast((Object)element2, PsiElement.class), t, expectedTypes, place, true, isCompletion);
        }
        if ((t == SqlDbElementType.KEY || t == SqlDbElementType.FOREIGN_KEY || t == SqlDbElementType.CHECK) && expectedTypes.contains(SqlDbElementType.CONSTRAINT)) {
            return true;
        }
        if (t == SqlDbElementType.KEY && expectedTypes.contains(SqlDbElementType.INDEX)) {
            IStubElementType elementType;
            if (element2 == null) {
                return true;
            }
            if (element2 instanceof StubBasedPsiElement ? (elementType = ((StubBasedPsiElement)element2).getElementType()) == SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION || elementType == SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION : element2 instanceof DbTableKey && ((DbTableKey)element2).isPrimary()) {
                return true;
            }
        }
        if ((t == SqlDbElementType.VARIABLE || t == SqlDbElementType.ARGUMENT || t == SqlDbElementType.OBJECT_ATTRIBUTE) && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (t == SqlDbElementType.ARGUMENT && (expectedTypes.contains(SqlDbElementType.VARIABLE) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.VARIABLE && (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.SEQUENCE && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(t) && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if (t == SqlDbElementType.PACKAGE && expectedTypes.contains(SqlDbElementType.SCHEMA)) {
            return true;
        }
        if (t == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        if (t == SqlDbElementType.AGGREGATE && expectedTypes.contains(SqlDbElementType.ROUTINE)) {
            return true;
        }
        if (dialect.isResolveTargetAccepted((PsiElement)ObjectUtils.tryCast((Object)element2, PsiElement.class), t, expectedTypes, place, false, isCompletion)) {
            return true;
        }
        return t == SqlDbElementType.CURSOR && expectedTypes.contains(SqlDbElementType.VARIABLE);
    }

    @NotNull
    public static ObjectKind getElementType(@Nullable Object o) {
        PomTarget pomTarget = SqlImplUtil.getPomTarget(o);
        if (pomTarget != null) {
            if (pomTarget instanceof BuiltinFunction) {
                ObjectKind objectKind = SqlDbElementType.ROUTINE;
                if (objectKind == null) {
                    SqlScopeProcessor.$$$reportNull$$$0(27);
                }
                return objectKind;
            }
            if (pomTarget instanceof SqlImplicitTarget) {
                ObjectKind objectKind = SqlDbElementType.COLUMN;
                if (objectKind == null) {
                    SqlScopeProcessor.$$$reportNull$$$0(28);
                }
                return objectKind;
            }
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlScopeProcessor.$$$reportNull$$$0(29);
            }
            return objectKind;
        }
        ObjectKind objectKind = o instanceof SqlReferenceExpression ? SqlScopeProcessor.getElementType((SqlReferenceExpression)o) : (o instanceof DasObject ? ((DasObject)o).getKind() : SqlDbElementType.ANY);
        if (objectKind == null) {
            SqlScopeProcessor.$$$reportNull$$$0(30);
        }
        return objectKind;
    }

    @NotNull
    private static ObjectKind getElementType(@Nullable SqlReferenceExpression o) {
        ObjectKind objectKind = o == null ? SqlDbElementType.ANY : o.getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlScopeProcessor.$$$reportNull$$$0(31);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedExpectedTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedIgnoredTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlScopeProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredTypes";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlScopeProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialExpectedTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedParentTypes";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExpected";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acceptsElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mayAccept";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mayAcceptParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

