/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0080\u0010\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u001a\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001a*\u00020\u0013H\u0000\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0000\u001a\u0011\u0010\u001c\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001d*\u00020\u0011H\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001e"}, d2={"valuesKeyword", "", "Lcom/intellij/sql/psi/SqlInsertStatement;", "getValuesKeyword", "(Lcom/intellij/sql/psi/SqlInsertStatement;)Ljava/lang/String;", "checkEquivalence", "", "ref1", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "ref2", "getKeywordCaseAware", "text", "project", "Lcom/intellij/openapi/project/Project;", "dialect", "Lcom/intellij/lang/Language;", "deparenthesize", "Lcom/intellij/sql/psi/SqlExpression;", "isAnd", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "isAntiEquality", "isEquality", "isOr", "splitWithReference", "Lkotlin/Pair;", "topParenthesized", "unwrapAlias", "Lorg/jetbrains/annotations/Nullable;", "intellij.database.sql.impl"})
public final class UtilsKt {
    @Nullable
    public static final String getValuesKeyword(@NotNull SqlInsertStatement $this$valuesKeyword) {
        Object v1;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$this$valuesKeyword, (String)"$this$valuesKeyword");
            SqlInsertDmlInstruction sqlInsertDmlInstruction = $this$valuesKeyword.getDmlInstruction();
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)(sqlInsertDmlInstruction != null && (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) != null ? sqlInsertDmlInstruction.getFirstChild() : null), (Function1)valuesKeyword.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it2 = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_VALUES)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        return psiElement != null ? psiElement.getText() : null;
    }

    public static final boolean isEquality(@NotNull SqlBinaryExpression $this$isEquality, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEquality, (String)"$this$isEquality");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isEquality.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQ)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQEQ) && (dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isSqlite());
    }

    public static final boolean isAntiEquality(@NotNull SqlBinaryExpression $this$isAntiEquality, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAntiEquality, (String)"$this$isAntiEquality");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isAntiEquality.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ2)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ3) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ4) && dbms.isOracle();
    }

    public static final boolean isOr(@NotNull SqlBinaryExpression $this$isOr, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isOr, (String)"$this$isOr");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isOr.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_OR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_OR) && dbms.isMysql();
    }

    public static final boolean isAnd(@NotNull SqlBinaryExpression $this$isAnd, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAnd, (String)"$this$isAnd");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isAnd.getOpSign();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_AND)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_AND) && dbms.isMysql();
    }

    @Nullable
    public static final kotlin.Pair<SqlReferenceExpression, SqlExpression> splitWithReference(@NotNull SqlBinaryExpression $this$splitWithReference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitWithReference, (String)"$this$splitWithReference");
        SqlExpression sqlExpression = $this$splitWithReference.getLOperand();
        if (!(sqlExpression instanceof SqlReferenceExpression)) {
            sqlExpression = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression left = sqlReferenceExpression;
        SqlExpression sqlExpression2 = $this$splitWithReference.getROperand();
        if (sqlExpression2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression2, (String)"rOperand ?: return null");
        SqlExpression right = sqlExpression2;
        return TuplesKt.to((Object)left, (Object)right);
    }

    public static final boolean checkEquivalence(@NotNull SqlReferenceExpression ref1, @NotNull SqlReferenceExpression ref2) {
        Intrinsics.checkParameterIsNotNull((Object)ref1, (String)"ref1");
        Intrinsics.checkParameterIsNotNull((Object)ref2, (String)"ref2");
        List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(ref1);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"SqlImplUtil.resolveQualified(ref1)");
        List<Pair<PsiElement, PsiElement>> target1 = list;
        List<Pair<PsiElement, PsiElement>> list2 = SqlImplUtil.resolveQualified(ref2);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"SqlImplUtil.resolveQualified(ref2)");
        List<Pair<PsiElement, PsiElement>> target2 = list2;
        if (Intrinsics.areEqual(target1, target2) ^ true) {
            return false;
        }
        Collection collection = target1;
        boolean bl = false;
        return !collection.isEmpty() || Intrinsics.areEqual((Object)ref1.getText(), (Object)ref2.getText());
    }

    @Nullable
    public static final SqlExpression topParenthesized(@NotNull SqlExpression $this$topParenthesized) {
        Intrinsics.checkParameterIsNotNull((Object)$this$topParenthesized, (String)"$this$topParenthesized");
        Object object = SqlImplUtil.sqlParents($this$topParenthesized.getParent()).takeWhile((Condition)topParenthesized.1.INSTANCE).last();
        if (!(object instanceof SqlExpression)) {
            object = null;
        }
        return (SqlExpression)object;
    }

    @Nullable
    public static final SqlExpression deparenthesize(@NotNull SqlExpression $this$deparenthesize) {
        while (true) {
            SqlExpression nestedExpression;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)$this$deparenthesize, (String)"$this$deparenthesize");
            SqlExpression sqlExpression = $this$deparenthesize;
            if (!(sqlExpression instanceof SqlParenthesizedExpression)) {
                sqlExpression = null;
            }
            SqlExpression sqlExpression2 = (object = (SqlParenthesizedExpression)sqlExpression) != null && (object = object.getExpressionList()) != null ? (SqlExpression)CollectionsKt.singleOrNull((List)object) : (nestedExpression = null);
            if (nestedExpression == null) break;
            $this$deparenthesize = nestedExpression;
        }
        return $this$deparenthesize;
    }

    @NotNull
    public static final String getKeywordCaseAware(@NotNull String text2, @NotNull Project project, @NotNull Language dialect) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(project, dialect)");
        SqlCodeStyleSettings settings = sqlCodeStyleSettings;
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)settings.KEYWORD_CASE);
        Intrinsics.checkExpressionValueIsNotNull((Object)case_, (String)"SqlCodeStyleSettings.get\u2026de(settings.KEYWORD_CASE)");
        Case keywordCase = case_;
        String string = keywordCase.apply(text2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keywordCase.apply(text)");
        return string;
    }

    @NotNull
    public static final SqlExpression unwrapAlias(@NotNull SqlExpression $this$unwrapAlias) {
        SqlAsExpression sqlAsExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$unwrapAlias, (String)"$this$unwrapAlias");
        SqlExpression sqlExpression = $this$unwrapAlias;
        if (!(sqlExpression instanceof SqlAsExpression)) {
            sqlExpression = null;
        }
        if ((sqlAsExpression = (SqlAsExpression)sqlExpression) == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$unwrapAlias;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlAsExpression, (String)"(this as? SqlAsExpression)?.expression ?: this");
        return sqlAsExpression;
    }
}

