/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlConvertJoinOnToUsingIntention;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinOnToUsingIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertJoinOnToUsingIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace ON with USING";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!SqlImplUtil.getSqlDialectSafe(element2).supportsJoinUsing()) {
            return false;
        }
        JoinConditionInfo<SqlJoinConditionClause> info = JoinUtilsKt.getJoinOnInfo(element2);
        if (info == null) return false;
        Collection collection = info.getColumnRefs();
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JoinConditionInfo<SqlJoinConditionClause> joinConditionInfo = JoinUtilsKt.getJoinOnInfo(element2);
        if (joinConditionInfo == null) {
            return;
        }
        JoinConditionInfo<SqlJoinConditionClause> info = joinConditionInfo;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)info.getClause());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(info.clause)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        String joinOp = dbms.isClickHouse() ? "all inner join" : "join";
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain("select * from foo " + joinOp + " bar ").keyword("using ").symbol("(").plain(CollectionsKt.joinToString$default((Iterable)info.getColumnRefs(), null, null, null, (int)0, null, (Function1)invoke.queryText.1.INSTANCE, (int)31, null)).symbol(")");
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder()\n      .conf\u2026\"?\" })\n      .symbol(\")\")");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DdlBuilder()\n      .conf\u2026bol(\")\")\n      .statement");
        String queryText2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText(queryText2, (SqlLanguageDialect)dialect, project);
        if (sqlQueryExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQueryExpression, (String)"SqlPsiElementFactory.cre\u2026Text, dialect, project)!!");
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlUsingClause.class);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.findChildOfT\u2026singClause::class.java)!!");
        SqlUsingClause usingClause = (SqlUsingClause)psiElement;
        info.getClause().replace((PsiElement)usingClause);
    }
}

