/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getTargetExpression", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertBetweenToComparisonIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace BETWEEN expression with comparisons";
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getTargetExpression(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        boolean bl;
        SqlExpression upperBound;
        SqlExpression lowerBound;
        SqlExpression subject;
        SqlLanguageDialectEx dialect;
        SqlBetweenExpression betweenExpr;
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            SqlBetweenExpression sqlBetweenExpression = this.getTargetExpression(element2);
            if (sqlBetweenExpression == null) {
                return;
            }
            betweenExpr = sqlBetweenExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)betweenExpr);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(betweenExpr)");
            dialect = sqlLanguageDialectEx;
            SqlExpression sqlExpression = betweenExpr.getSubject();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"betweenExpr.subject");
            subject = sqlExpression;
            lowerBound = betweenExpr.getLowerBound();
            upperBound = betweenExpr.getUpperBound();
            JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren(betweenExpr.getOperation());
            Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"SqlImplUtil.sqlChildren(betweenExpr.operation)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_NOT)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean isNot = bl;
        boolean needsParentheses = isNot || betweenExpr.getParent() instanceof SqlOperatorExpression;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        if (isNot) {
            builder.keyword("not ");
        }
        if (needsParentheses) {
            builder.symbol("(");
        }
        builder.plain(subject.getText());
        builder.symbol(" >= ");
        Object object = lowerBound;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        builder.plain((String)object);
        builder.plain(" and ");
        builder.plain(subject.getText());
        builder.symbol(" <= ");
        Object object2 = upperBound;
        if (object2 == null || (object2 = object2.getText()) == null) {
            object2 = "";
        }
        builder.plain((String)object2);
        if (needsParentheses) {
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(ddlBuilder.getStatement(), dialect, project, null);
        if (sqlExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026dialect, project, null)!!");
        SqlExpression comparisonExpr = sqlExpression;
        betweenExpr.replace((PsiElement)comparisonExpr);
    }

    private final SqlBetweenExpression getTargetExpression(PsiElement element2) {
        JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBetweenExpression.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil.sqlParents(e\u2026enExpression::class.java)");
        return (SqlBetweenExpression)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
    }
}

