/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlMergeOnBlock;
import com.intellij.sql.formatter.model.SqlMergeUsingBlock;
import com.intellij.sql.formatter.model.SqlMergeWhenBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlMergeBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "hostWrap", "Lcom/intellij/formatting/Wrap;", "getHostWrap$intellij_database_sql_impl", "()Lcom/intellij/formatting/Wrap;", "setHostWrap$intellij_database_sql_impl", "(Lcom/intellij/formatting/Wrap;)V", "configureFormattingAttributes", "", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "whetherToFlatten", "", "intellij.database.sql.impl"})
public final class SqlMergeBlock
extends SqlNodeBlock {
    @Nullable
    private Wrap hostWrap;

    @Nullable
    public final Wrap getHostWrap$intellij_database_sql_impl() {
        return this.hostWrap;
    }

    public final void setHostWrap$intellij_database_sql_impl(@Nullable Wrap wrap) {
        this.hostWrap = wrap;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return node.getElementType() == SqlCompositeElementTypes.SQL_MERGE_DML_INSTRUCTION;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_USING_CLAUSE)) {
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = new SqlMergeUsingBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = sqlNodeBlock;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
            ASTNode aSTNode = node.getFirstChildNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.firstChildNode");
            IElementType iElementType2 = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCommonKeywords.SQL_ON)) {
                void $this$withSetup$iv;
                SqlNodeBlock parent$iv = new SqlMergeOnBlock();
                SqlBlock parent$iv2 = this;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv2, node);
                sqlBlock = (SqlBlock)$this$withSetup$iv;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCommonKeywords.SQL_WHEN)) {
                SqlNodeBlock $this$withSetup$iv = new SqlMergeWhenBlock();
                SqlBlock parent$iv = this;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
                sqlBlock = $this$withSetup$iv;
            } else {
                sqlBlock = super.makeBlock(node);
            }
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    protected void configureFormattingAttributes() {
        this.hostWrap = SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null);
        for (SqlBlock b2 : this.getNestedBlocks()) {
            SqlBlock sqlBlock = b2;
            if (sqlBlock instanceof SqlKeyword) {
                IElementType kwt = SqlFormattingModelFunKt.primaryElementType(b2);
                IElementType iElementType = kwt;
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_INTO)) continue;
                b2.setMyWrap(this.getContext().getSql().INSERT_INTO_NL == 1 ? this.hostWrap : null);
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (!(sqlBlock instanceof SqlMergeUsingBlock) && !(sqlBlock instanceof SqlMergeOnBlock) && !(sqlBlock instanceof SqlMergeWhenBlock)) continue;
            b2.setMyWrap(this.hostWrap);
            b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
        }
    }
}

