/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseScriptDialog
extends DialogWrapper {
    protected final Project myProject;
    protected final DbDataSource mySource;
    protected final SearchPath mySearchPath;
    protected final SqlPreviewPanel myPreviewPanel;
    protected final ScriptOptionsPanel myOptionsPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String title) {
        if (project == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource2;
        this.mySearchPath = searchPath;
        this.myPreviewPanel = new SqlPreviewPanel(this.myProject, this.mySource, this.mySearchPath, "", this.getDimensionServiceKey(), false, () -> this.close(1)){

            @Override
            @NotNull
            public List<AnAction> createActions(@NotNull DbDataSource delegate) {
                if (delegate == null) {
                    1.$$$reportNull$$$0(0);
                }
                List list = ContainerUtil.concat(DatabaseScriptDialog.this.createPreviewActions(), super.createActions(delegate));
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createActions";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            this.applyOptions();
            return Unit.INSTANCE;
        }));
        this.setTitle(title);
    }

    @NotNull
    protected List<AnAction> createPreviewActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected void init() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ScriptingTask task = this.getTask();
            this.myOptionsPanel.adjustOptionsUI(task, task.getOptions());
        }, ModalityState.any());
        super.init();
    }

    protected void applyOptions() {
        this.settingsChanged(this.appendCodeStyle(this.myOptionsPanel.gatherOptions()));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected abstract ScriptingTask getTask();

    public static JBPopup showSettingsPopup(ScriptingTask task, Consumer<ScriptingOptions> callback) {
        Ref panel2 = Ref.create();
        panel2.set((Object)new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            callback.consume((Object)((ScriptOptionsPanel)panel2.get()).gatherOptions());
            return Unit.INSTANCE;
        })));
        ((ScriptOptionsPanel)panel2.get()).adjustOptionsUI(task, task.getOptions());
        JComponent component = ((ScriptOptionsPanel)panel2.get()).getComponent();
        UIUtil.addInsets((JComponent)component, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        return JBPopupFactory.getInstance().createComponentPopupBuilder(component, component).setRequestFocus(true).createPopup();
    }

    public static AnAction createSettingsPopupAction(final Getter<ScriptingTask> task, final Consumer<ScriptingOptions> callback) {
        return new ActionGroup("Settings", null, AllIcons.General.GearPlain){
            {
                super(arg0, arg1, arg2);
                this.setPopup(true);
            }

            public boolean isDumbAware() {
                return true;
            }

            public boolean canBePerformed(@NotNull DataContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean disableIfNoVisibleChildren() {
                return false;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                JBPopup popup = DatabaseScriptDialog.showSettingsPopup((ScriptingTask)task.get(), (Consumer<ScriptingOptions>)callback);
                DbUIUtil.showPopup(popup, null, e);
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                if (AnAction.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canBePerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected ScriptingOptions appendCodeStyle(ScriptingOptions op) {
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)this.mySource);
        if (ds == null) {
            return op;
        }
        SqlCodeStyleSettings style = ScriptingTaskBuilderKt.getSqlCodeStyle(ds);
        DelegateScriptingOptions res = new DelegateScriptingOptions(op);
        res.getOptions().put(ScriptingOptionStatic.CODE_STYLE, style);
        return res;
    }

    protected abstract void settingsChanged(ScriptingOptions var1);

    @Nullable
    protected JComponent createCenterPanel() {
        return JBUI.Panels.simplePanel().addToTop((Component)this.myOptionsPanel.getComponent()).addToCenter((Component)this.myPreviewPanel);
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    protected void doOKAction() {
        this.runScript();
        super.doOKAction();
    }

    @NotNull
    public AsyncTask<?> runScript() {
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.myProject, DbImplUtil.getLocalDataSource((DasDataSource)this.mySource), this.mySearchPath).setStatement(this.getStatement());
        this.fillContext(handler);
        AsyncTask<?> asyncTask = handler.runStatements(false);
        if (asyncTask == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(5);
        }
        return asyncTask;
    }

    protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
        if (handler == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(6);
        }
    }

    protected void updateText(ScriptingResult script) {
        this.updateText(script.getScriptText());
    }

    protected void updateText(String script) {
        this.myPreviewPanel.setQuery(script);
    }

    public void initAndShow() {
        this.init();
        this.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

