/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDumpDialogAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(0);
        }
        Object source = DumpAction.getDumpSource(e);
        e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid != null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(grid.isReady() && !grid.isEmpty());
            e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.text", (Object[])new Object[0]));
            return;
        }
        if (source == null || e.getProject() == null) {
            return;
        }
        if (source instanceof DumpAction.ConsoleSource) {
            ShowDumpDialogAction.updateConsolePresentation((DumpAction.ConsoleSource)source, e);
        } else {
            this.updatePresentation(source, e);
        }
    }

    private static void updateConsolePresentation(@NotNull DumpAction.ConsoleSource source, @NotNull AnActionEvent e) {
        if (source == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(2);
        }
        List<String> queries = DumpAction.getQueries(source);
        e.getPresentation().setEnabledAndVisible(!queries.isEmpty());
        if (queries.isEmpty()) {
            return;
        }
        e.getPresentation().setText(ShowDumpDialogAction.pluralizeInternal(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.ConsoleText", (Object[])new Object[0]), ShowDumpDialogAction.getSize(queries)));
        e.getPresentation().setIcon(AllIcons.Actions.Execute);
    }

    private void updatePresentation(@NotNull Object target, @NotNull AnActionEvent e) {
        if (target == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setText(ShowDumpDialogAction.pluralizeInternal(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.DatabaseViewText", (Object[])new Object[0]), ShowDumpDialogAction.getSize(target)), true);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
    }

    private static int getSize(@Nullable Object object) {
        if (object instanceof DumpAction.ConsoleSource) {
            return ((DumpAction.ConsoleSource)object).model.statements().skip(1).isEmpty() ? 1 : 2;
        }
        if (object instanceof JBIterable) {
            return ((JBIterable)object).skip(1).isEmpty() ? 1 : 2;
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        return 1;
    }

    @NotNull
    private static String pluralizeInternal(@NotNull String s, int count2) {
        if (s == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(5);
        }
        String string = s + (count2 > 1 ? "(s)" : "");
        if (string == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(7);
        }
        Project project = e.getProject();
        Object source = DumpAction.getDumpSource(e);
        if (project != null) {
            new DumpDataDialog(project, e, ShowDumpDialogAction.getSize(source) > 1, ShowDumpDialogAction.getDbms(source), source).show();
        }
    }

    private static Dbms getDbms(Object source) {
        return source instanceof DataGrid ? DataGridUtil.getDbms((DataGrid)source) : (source instanceof DumpAction.ConsoleSource ? ((DumpAction.ConsoleSource)source).console.getDataSource().getDbms() : (source instanceof Iterable ? (Dbms)ObjectUtils.doIfNotNull((Object)ContainerUtil.findInstance((Iterable)((Iterable)source), DbElement.class), e -> e.getDataSource().getDbms()) : Dbms.UNKNOWN));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ShowDumpDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ShowDumpDialogAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralizeInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateConsolePresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pluralizeInternal";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

