/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelConverters;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import gnu.trove.TObjectHashingStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelImporter {
    private static final ModelConverters ourConverters = new ModelConverters();
    private static final Logger LOG = Logger.getInstance(ModelImporter.class);
    @NotNull
    private final ModelFactory myModelFactory;
    public Set<String> myUnconsumedProperties;
    @NotNull
    public Version expectedVersion;
    @Nullable
    public Interner<BasicModElement> interner;
    public final Version[] versionRange;
    public boolean currentFormat;

    public ModelImporter(@NotNull ModelFactory modelFactory) {
        if (modelFactory == null) {
            ModelImporter.$$$reportNull$$$0(0);
        }
        this.myUnconsumedProperties = null;
        this.expectedVersion = Version.INFINITY;
        this.interner = null;
        this.versionRange = new Version[]{Version.ZERO, Version.INFINITY};
        this.myModelFactory = modelFactory;
    }

    @NotNull
    public ModelMem deserializeModel(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) throws ImportException {
        Version formatVersion;
        Dbms dbms;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(1);
        }
        String problemPrefix = dataSourceName != null ? "Problem occurred when reading data source " + dataSourceName + ": " : "";
        String rootNodeName = reader.getNodeName();
        if (!rootNodeName.equalsIgnoreCase("database-model")) {
            throw new ImportException(problemPrefix + "The root node of the database model must be " + "database-model" + ", but found " + rootNodeName);
        }
        String dbmsStr = (String)ObjectUtils.chooseNotNull((Object)reader.getAttribute("dbms"), (Object)reader.getAttribute("family-id"));
        if (dbmsStr != null) {
            dbms = Dbms.byName((String)dbmsStr);
            if (dbms == null) {
                throw new ImportException(problemPrefix + "Unknown dbms: " + dbmsStr);
            }
        } else {
            String rdbmsCode = reader.getAttribute("rdbms");
            if (rdbmsCode != null) {
                String code = rdbmsCode.equalsIgnoreCase("POSTGRE") ? (rdbmsCode = "POSTGRES") : rdbmsCode;
                dbms = Dbms.byName((String)StringUtil.toUpperCase((String)code));
                if (dbms == null) {
                    throw new ImportException(problemPrefix + "Unknown rdbms: " + rdbmsCode);
                }
            } else {
                throw new ImportException(problemPrefix + "Dbms is not specified");
            }
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? (this.currentFormat ? ModelSerializationVersions.CURRENT_VERSION : Version.ZERO) : Version.of((String)formatVersionString);
        }
        catch (Exception e) {
            throw new ImportException(problemPrefix + "Error reading format version: " + e.getMessage(), e);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(dbms);
        mm.setVersion(formatVersion);
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String attrValue;
            String attrName = reader.getAttributeName(i2);
            if (attrName.equalsIgnoreCase("dbms") || attrName.equalsIgnoreCase("family-id") || attrName.equalsIgnoreCase("serializer") || attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i2)) == null || attrValue.isEmpty()) continue;
            mm.getProperties().put(attrName, attrValue);
        }
        if (formatVersion.compareTo(ModelSerializationVersions.MIN_VERSION) < 0 || formatVersion.compareTo(ModelSerializationVersions.CURRENT_VERSION) > 0) {
            String message2 = problemPrefix + "Unsupported format version " + formatVersion + " (the " + ModelSerializationVersions.CURRENT_VERSION + " is expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message2));
        } else {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                this.deserializeObject(reader, null, mm.getNodes());
                reader.moveUp();
            }
        }
        ModelMem modelMem = mm;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(2);
        }
        return modelMem;
    }

    void deserializeObject(@NotNull HierarchicalStreamReader reader, ModelElementMem parent2, List<ModelElementMem> output) throws ImportException {
        Integer parentId;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(3);
        }
        String kind = reader.getNodeName();
        Integer id = ModelImporter.parseId(reader);
        Integer n = parentId = parent2 != null ? parent2.getId() : ModelImporter.parseParentId(reader);
        if (id == null) {
            String fromVerStr = reader.getAttribute("from-version");
            String toVerStr = reader.getAttribute("to-version");
            if (fromVerStr != null || toVerStr != null) {
                Version toVer;
                Version fromVer = fromVerStr == null ? Version.ZERO : Version.of((String)fromVerStr);
                Version version = toVer = toVerStr == null ? Version.INFINITY : Version.of((String)toVerStr);
                if (!this.expectedVersion.isOrGreater(fromVer)) {
                    if (!fromVer.isOrGreater(this.versionRange[1])) {
                        this.versionRange[1] = fromVer;
                    }
                    return;
                }
                if (toVer != Version.INFINITY && this.expectedVersion.isOrGreater(toVer)) {
                    if (!this.versionRange[0].isOrGreater(toVer)) {
                        this.versionRange[0] = toVer;
                    }
                    return;
                }
                if (!this.versionRange[0].isOrGreater(fromVer)) {
                    this.versionRange[0] = fromVer;
                }
                if (!toVer.isOrGreater(this.versionRange[1])) {
                    this.versionRange[1] = toVer;
                }
            }
            id = output.size() + 1;
        }
        String name = DbUtil.intern2((String)StringUtil.nullize((String)reader.getAttribute("name")));
        ModelElementMem em = new ModelElementMem();
        output.add(em);
        em.setKind(kind);
        em.setId(id);
        em.setParentId(parentId);
        em.setName(name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getNodeName();
            ObjectKind ok = (ObjectKind)ObjectKind.ourKinds.get(key);
            if (ok != null && ObjectKind.isDatabaseKind((ObjectKind)ok)) {
                this.deserializeObject(reader, em, output);
            } else {
                key = ModelSerializationFun.normalize(key);
                String value2 = reader.getValue();
                value2 = ModelSerializationFun.normalize(value2);
                value2 = DbUtil.intern2((String)value2);
                if (key != null && value2 != null && !key.equalsIgnoreCase("name") && this.acceptsProperty(em, key)) {
                    em.getProperties().add(new MutableNameAndValue(key, value2));
                }
            }
            reader.moveUp();
        }
    }

    protected boolean acceptsProperty(ModelElementMem em, String name) {
        return true;
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("id")))) {
            return null;
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("parent")))) {
            return null;
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    public BasicModModel importModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(6);
        }
        ourConverters.convertMem(modelMem);
        BasicModModel model = this.createModel2(modelMem.getDbms());
        ((BaseModel)model).modify(model.getRoot(), BasicModRoot.class, true, root2 -> this.populateModel(modelMem, (BasicModRoot)root2));
        ourConverters.convertModel(model, modelMem.getVersion());
        return model;
    }

    private BasicModModel createModel2(@NotNull Dbms dbms) {
        if (dbms == null) {
            ModelImporter.$$$reportNull$$$0(7);
        }
        return this.myModelFactory.createModel(dbms);
    }

    private void populateModel(@NotNull ModelMem modelMem, @NotNull BasicModRoot root2) {
        BasicModElement parent2;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(8);
        }
        if (root2 == null) {
            ModelImporter.$$$reportNull$$$0(9);
        }
        HashMap<Integer, BasicModRoot> elements = new HashMap<Integer, BasicModRoot>(modelMem.getNodes().size());
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        for (ModelElementMem mem : modelMem.getNodes()) {
            BasicModElement element2;
            ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(mem.getKind());
            if (kind == null) {
                LOG.warn("ObjectKind " + mem.getKind() + " not found");
                continue;
            }
            if (mem.getParentId() == null) {
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                element2 = root2;
                this.populateObject(element2, mem, propertiesMap);
            } else {
                parent2 = (BasicModElement)elements.get(mem.getParentId());
                if (parent2 == null) {
                    throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                }
                BasicMetaObject meta = BasicMetaUtils.findChild(parent2.getMetaObject(), kind);
                if (meta == null) {
                    LOG.warn("No family " + kind + " in " + parent2.getKind().code());
                    continue;
                }
                element2 = meta.newDataObject();
                this.populateObject(element2, mem, propertiesMap);
                element2 = this.intern(element2);
            }
            elements.put(mem.getId(), (BasicModRoot)element2);
        }
        for (ModelElementMem mem : modelMem.getNodes()) {
            BasicModElement element3 = (BasicModElement)elements.get(mem.getId());
            Integer parentId = mem.getParentId();
            if (parentId == null) continue;
            parent2 = (BasicModElement)elements.get(parentId);
            if (parent2 == null) {
                LOG.error(mem + "'s parent was not instantiated or lost");
                continue;
            }
            if (!(parent2 instanceof BaseModel.BaseElement)) {
                LOG.error(mem + "'s parent was not added to hierarchy");
                continue;
            }
            BaseModel.BaseFamily family = (BaseModel.BaseFamily)parent2.familyOf(element3.getKind());
            if (family == null) {
                LOG.error(mem + "'s family not in parent");
                continue;
            }
            Object newObject = family.createNewOne(element3);
            elements.put(mem.getId(), (BasicModRoot)newObject);
            this.populateObject((BasicModElement)newObject, mem, (Map<String, String>)propertiesMap);
        }
    }

    private BasicModElement intern(BasicModElement element2) {
        if (this.interner == null) {
            return element2;
        }
        return (BasicModElement)this.interner.intern((Object)element2);
    }

    private void populateObject(BasicModElement element2, ModelElementMem mem, Map<String, String> propertiesMap) {
        propertiesMap.clear();
        for (MutableNameAndValue mutableNameAndValue : mem.getProperties()) {
            propertiesMap.put(ModelImporter.nameFromXmlToHumps(mutableNameAndValue.getName()), mutableNameAndValue.getValue());
        }
        if (StringUtil.isNotEmpty((String)mem.getName())) {
            propertiesMap.put(ModelImporter.nameFromXmlToHumps("name"), mem.getName());
        }
        ModelImporter.importElementProperties(element2, propertiesMap);
        Set<String> unconsumedProperties = this.myUnconsumedProperties;
        if (unconsumedProperties != null) {
            for (BasicMetaProperty<?> property : element2.getMetaObject().properties) {
                propertiesMap.remove(property.name);
            }
            if (!propertiesMap.isEmpty()) {
                BasicModModel basicModModel = element2.getModel();
                String className = (basicModModel == null ? "" : basicModModel.getClass().getSimpleName() + '.') + element2.getClass().getSimpleName() + '.';
                for (String propName : propertiesMap.keySet()) {
                    unconsumedProperties.add(className + propName);
                }
            }
        }
    }

    private static void importElementProperties(@NotNull BasicModElement element2, @NotNull Map<String, String> propertiesMap) {
        if (element2 == null) {
            ModelImporter.$$$reportNull$$$0(10);
        }
        if (propertiesMap == null) {
            ModelImporter.$$$reportNull$$$0(11);
        }
        try {
            element2.importProperties(propertiesMap);
        }
        catch (Exception e) {
            BasicModModel model = element2.getModel();
            BasicMetaModel metaModel = model.getMetaModel();
            Dbms dbms = metaModel.getDbms();
            String message2 = String.format("Importing %s model: failed to import element %s: %s: %s", dbms.getName(), element2.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message2, (Throwable)e);
            }
            LOG.warn(message2);
        }
    }

    public void setUnconsumedProperties(Set<String> unconsumedProperties) {
        this.myUnconsumedProperties = unconsumedProperties;
    }

    @NotNull
    static String nameFromXmlToHumps(@NotNull String name) {
        if (name == null) {
            ModelImporter.$$$reportNull$$$0(12);
        }
        String string = StringUtil.capitalizeWords((String)name, (String)"-", (boolean)true, (boolean)true).replace("-", "");
        if (string == null) {
            ModelImporter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Interner<BasicModElement> createWeakInterner() {
        return new WeakInterner((TObjectHashingStrategy)new TObjectHashingStrategy<BasicModElement>(){

            public int computeHashCode(BasicModElement object) {
                return BasicMetaUtils.hashCode(object);
            }

            public boolean equals(BasicModElement o1, BasicModElement o2) {
                return BasicMetaUtils.equals(o1, o2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "nameFromXmlToHumps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModel";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseParentId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModel2";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importElementProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameFromXmlToHumps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

