/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.util.ObjectUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaObject<M extends BasicModElement> {
    private static final BasicMetaObject<?>[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty<?>[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Supplier<? extends M> dataFactory;
    public final BasicMetaProperty<?>[] properties;
    public final BasicMetaObject<?>[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Supplier<? extends M> dataFactory, BasicMetaProperty<?>[] properties, BasicMetaObject<?>[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.dataFactory = dataFactory;
        this.properties = properties == null ? EMPTY_PROPS_ARRAY : properties;
        for (BasicMetaObject<?> child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            assert (child.myParent == null);
            child.myParent = this;
        }
    }

    @Nullable
    public BasicMetaObject<?> getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public ObjectKind getParentKind(int i2) {
        BasicMetaObject<?> cur;
        for (cur = this; i2 > 0 && cur != null; cur = cur.getParent(), --i2) {
        }
        return cur == null ? null : cur.kind;
    }

    @NotNull
    public BasicMetaModel getModel() {
        Object parent2 = this.myParent;
        while (parent2 instanceof BasicMetaObject) {
            parent2 = ((BasicMetaObject)parent2).myParent;
        }
        BasicMetaModel basicMetaModel = (BasicMetaModel)parent2;
        if (basicMetaModel == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    void setModel(@NotNull BasicMetaModel model) {
        if (model == null) {
            BasicMetaObject.$$$reportNull$$$0(1);
        }
        assert (this.myParent == null);
        this.myParent = model;
    }

    public boolean kindOf(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.apiClass);
    }

    @NotNull
    public M newDataObject() {
        BasicModElement basicModElement = (BasicModElement)this.dataFactory.get();
        if (basicModElement == null) {
            BasicMetaObject.$$$reportNull$$$0(2);
        }
        return (M)basicModElement;
    }

    @NotNull
    public String toString() {
        if (this.myParent instanceof BasicMetaObject) {
            String string = this.myParent.toString() + "." + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myParent instanceof BasicMetaModel) {
            String string = ((BasicMetaModel)this.myParent).dbms.getDisplayName() + ": " + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.kind.code();
        if (string == null) {
            BasicMetaObject.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataObject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

