/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class DataSourceSnapshotManager {
    public static final DataSourceSnapshotManager INSTANCE = new DataSourceSnapshotManager();
    public static final boolean IGNORE_AUTO_MINI_CAT = !Registry.is((String)"database.snapshots.auto");
    private final Map<Dbms, Map<Couple<Version>, Object>> myModels = ConcurrentFactoryMap.create(k -> ContainerUtil.createConcurrentWeakValueMap(), ContainerUtil::createConcurrentSoftMap);
    private final Map<BasicModel, ModelNameIndex> myModelNameIndices = ConcurrentFactoryMap.create(model -> new ModelNameIndex((BasicModel)model){
        final /* synthetic */ BasicModel val$model;
        {
            this.val$model = basicModel;
        }

        @Override
        @NotNull
        protected DasModel getModel() {
            BasicModel basicModel = this.val$model;
            if (basicModel == null) {
                1.$$$reportNull$$$0(0);
            }
            return basicModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataSourceSnapshotManager$1", "getModel"));
        }
    }, ContainerUtil::createConcurrentSoftKeySoftValueMap);
    private final Interner<BasicModElement> myObjectsInterner = ModelImporter.createWeakInterner();

    public void apply(@Nullable Project project, @NotNull LocalDataSource dataSource2) {
        BaseModel model;
        if (dataSource2 == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(0);
        }
        if ((model = (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class)) == null) {
            return;
        }
        DataSourceSchemaMapping mapping = dataSource2.getSchemaMapping();
        DbImplUtil.performSrcOperation(null, model, ModalityState.NON_MODAL, true, () -> model.modify(model.getRoot(), BasicModRoot.class, true, r -> {
            int autoMappedWildcards = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicElement::getChildren).withRoot(r)).expandAndFilter(o -> o instanceof BasicNamespace || o instanceof BasicRoot)).traverse().filter(e -> this.isAutoMappedWildCard((BasicElement)e, mapping)).filterMap(e -> e.getDatabase()).unique().size();
            if (autoMappedWildcards > 10) {
                dataSource2.getSchemaMapping().setUseMiniCat(false);
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Too many pre-introspected objects are used", dataSource2.getName(), "To leverage performance, automatic usage of pre-introspected objects is disabled.\nYou can select the necessary schemas manually.", NotificationType.INFORMATION).notify(project);
            }
            ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicElement::getChildren).withRoot(r)).expandAndFilter(o -> o instanceof BasicNamespace || o instanceof BasicRoot)).filter(BaseModel.BaseElement.class).forEach(e -> this.merge((BaseModel.BaseElement<?>)e, mapping));
        }));
    }

    private void merge(@NotNull BaseModel.BaseElement<?> e, @NotNull DataSourceSchemaMapping mapping) {
        Pair<String, ObjectPath> map2;
        BasicModel miniMod;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(1);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(2);
        }
        BasicModel basicModel = miniMod = (map2 = this.map(e, mapping)) == null ? null : this.getSnapshotModel(e);
        if (miniMod == null) {
            if (e instanceof BasicModMateNamespace) {
                ((BasicModMateNamespace)((Object)e)).setSubstituted(false);
            }
            return;
        }
        JBIterable<DasObject> objs = QNameUtil.findByPath(miniMod, (ObjectPath)map2.second);
        for (BasicElement target : objs.filter(BasicElement.class)) {
            DataSourceSnapshotManager.merge(e, target, true);
        }
    }

    @Nullable
    public Pair<String, ObjectPath> map(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(3);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(4);
        }
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return null;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return map2;
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return null;
        }
        return this.mapAuto(e, mapping);
    }

    @Nullable
    private Pair<String, ObjectPath> mapAuto(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        BasicDatabase db;
        ObjectPath basePath;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(5);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(6);
        }
        if (e.getKind() != ObjectKind.SCHEMA && e.getKind() != ObjectKind.DATABASE) {
            return null;
        }
        BasicNamespace nsp = (BasicNamespace)ObjectUtils.tryCast((Object)e, BasicNamespace.class);
        ObjectPath objectPath = basePath = nsp == null ? null : this.getBasePath(nsp);
        if (basePath == null) {
            return null;
        }
        ObjectPath dbPath = basePath.findParent(ObjectKind.DATABASE, false);
        if (dbPath != null && StringUtil.isEmpty((String)dbPath.name) && (db = e.getDatabase()) != null && !mapping.isIntrospected(db)) {
            return null;
        }
        return Pair.create((Object)"minicat", (Object)basePath);
    }

    private boolean isAutoMappedWildCard(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(8);
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return false;
        }
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return false;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return false;
        }
        map2 = this.mapAuto(e, mapping);
        if (map2 == null) {
            return false;
        }
        ObjectPath db = ((ObjectPath)map2.second).findParent(ObjectKind.DATABASE, false);
        return db != null && StringUtil.isEmpty((String)db.name);
    }

    @Nullable
    private static BaseModel.BaseElement<?> merge(@NotNull BasicModElement e, @Nullable BasicElement target, boolean apply2) {
        BaseModel.BaseElement<?> te;
        boolean exact;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(9);
        }
        if (target == null) {
            return null;
        }
        boolean bl = exact = e.getMetaObject() == target.getMetaObject();
        if (exact) {
            te = (BaseModel.BaseElement<?>)e;
        } else {
            te = DataSourceSnapshotManager.merge(e, target.getParent(), false);
            ObjectPath tp = BasicPaths.of(target);
            BaseModel.BaseElement<?> baseElement = te = te == null ? null : (BaseModel.BaseElement<?>)SqlModelBuilderUtils.createObject(te, tp.name, tp.isQuoted(), tp.getIdentity(), tp.kind);
            if (te == null) {
                return null;
            }
        }
        if (apply2) {
            if (te instanceof BasicModMateNamespace) {
                ((BasicModMateNamespace)((Object)te)).setSubstituted(true);
            }
            te.substituteChildren(target);
        }
        return te;
    }

    private BasicModel getSnapshotModel(@NotNull BasicElement e) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(10);
        }
        Dbms dbms = e.getMetaObject().getModel().getDbms();
        BasicModel model = e.getModel();
        Version version = (Version)ObjectUtils.notNull((Object)(model == null ? null : model.getRoot().getServerVersion()), (Object)Version.INFINITY);
        return this.getSnapshotModel(dbms, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BasicModel getSnapshotModel(@NotNull Dbms dbms, @NotNull Version version) {
        Map<Couple<Version>, Object> models;
        Object res;
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(11);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(12);
        }
        if ((res = DataSourceSnapshotManager.findModel(models = this.myModels.get(dbms), version)) == null) {
            Map<Couple<Version>, Object> map2 = models;
            synchronized (map2) {
                res = DataSourceSnapshotManager.findModel(models, version);
                if (res == null) {
                    Pair<Couple<Version>, BasicModel> loaded = this.loadModel(dbms, version);
                    if (loaded == null) {
                        models.put((Couple<Version>)Couple.of((Object)Version.ZERO, (Object)Version.INFINITY), ObjectUtils.NULL);
                        return null;
                    }
                    models.put((Couple<Version>)loaded.first, loaded.second);
                    return (BasicModel)loaded.second;
                }
            }
        }
        return res == ObjectUtils.NULL ? null : (BasicModel)res;
    }

    @Nullable
    public ModelNameIndex getSnapshotModelIndex(@NotNull Dbms dbms, @NotNull Version version) {
        BasicModel model;
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(13);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(14);
        }
        return (model = this.getSnapshotModel(dbms, version)) != null ? this.myModelNameIndices.get(model) : null;
    }

    @Nullable
    private static Object findModel(@NotNull Map<Couple<Version>, ?> models, @NotNull Version version) {
        if (models == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(15);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(16);
        }
        for (Map.Entry<Couple<Version>, ?> entry : models.entrySet()) {
            if (!version.isOrGreater((Version)entry.getKey().first) || version.isOrGreater((Version)entry.getKey().second) && version != Version.INFINITY) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean canSubstitute(@NotNull BasicNamespace nsp, boolean ignoreWildcard) {
        BasicModel snap;
        if (nsp == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(17);
        }
        if ((snap = this.getSnapshotModel(nsp)) == null) {
            return false;
        }
        JBIterable targets2 = DataSourceSnapshotManager.getTargets((BaseModel.BaseElement)((Object)nsp), snap.getRoot());
        if (ignoreWildcard) {
            targets2 = targets2.filter(o -> !o.getName().isEmpty());
        }
        return targets2.isNotEmpty();
    }

    @Nullable
    public ObjectPath getBasePath(@NotNull BasicNamespace nsp) {
        BasicModel snap;
        if (nsp == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(18);
        }
        if ((snap = this.getSnapshotModel(nsp)) == null) {
            return null;
        }
        BasicElement tgt = (BasicElement)DataSourceSnapshotManager.getTargets((BaseModel.BaseElement)((Object)nsp), snap.getRoot()).first();
        return tgt == null ? null : (ObjectPath)BasicPaths.of(tgt).reduce(null, (parent2, cur) -> cur.getIdentity() == null && parent2 == cur.parent ? cur : ObjectPath.create((String)cur.name, (ObjectKind)cur.kind, (boolean)cur.isQuoted(), null, (ObjectPath)parent2));
    }

    @NotNull
    private static JBIterable<BasicElement> getTargets(@NotNull BaseModel.BaseElement<?> to, @NotNull BasicRoot r) {
        if (to == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(19);
        }
        if (r == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(20);
        }
        if (to instanceof BasicRoot) {
            JBIterable jBIterable = JBIterable.of((Object)r);
            if (jBIterable == null) {
                DataSourceSnapshotManager.$$$reportNull$$$0(21);
            }
            return jBIterable;
        }
        if (to.getParent() == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DataSourceSnapshotManager.$$$reportNull$$$0(22);
            }
            return jBIterable;
        }
        JBIterable<BasicElement> targets2 = DataSourceSnapshotManager.getTargets((BaseModel.BaseElement)to.getParent(), r);
        JBIterable jBIterable = targets2.flatten(o -> JBIterable.of((Object[])new String[]{"", to.getName()}).filterMap(name -> (BasicElement)o.getChildren().filter(c2 -> c2.getKind() == to.getKind() && c2.getName().equals(name)).first()));
        if (jBIterable == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(24);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(25);
        }
        try (InputStream is = DataSourceSnapshotManager.getMiniCatStream(dbms);){
            if (is == null) {
                Pair<Couple<Version>, BasicModel> pair2 = null;
                return pair2;
            }
            Pair<Couple<Version>, BasicModel> pair = this.loadModel(dbms, version, is);
            return pair;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getMiniCatStream(@NotNull Dbms dbms) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(26);
        }
        return DbImplUtil.getDatabaseDialect(dbms).getClass().getResourceAsStream("/" + StringUtil.toLowerCase((String)dbms.getName()) + ".xml");
    }

    @NotNull
    private Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version, InputStream is) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(27);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(28);
        }
        ModelImporter importer = new ModelImporter(new ModelFactory(BlackHoleTextStorage.INSTANCE));
        importer.expectedVersion = version;
        importer.interner = this.myObjectsInterner;
        importer.currentFormat = true;
        BasicModModel model = ModelSerializerKt.deserialize((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(is, CharsetToolkit.UTF8_CHARSET), (XmlPullParser)new MXParser()), importer, dbms.getName() + "/minicat");
        ((BaseModel)model).setFrozen(true);
        Pair pair = Pair.create((Object)Couple.of((Object)importer.versionRange[0], (Object)importer.versionRange[1]), (Object)model);
        if (pair == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @Nullable
    private static ZipEntry findMiniCatXml(@NotNull ZipInputStream zis) throws IOException {
        if (zis == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(30);
        }
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals("minicat.xml")) {
                return entry;
            }
            entry = zis.getNextEntry();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 11: 
            case 13: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/DataSourceSnapshotManager";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/DataSourceSnapshotManager";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapAuto";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoMappedWildCard";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshotModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshotModelIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBasePath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTargets";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMiniCatStream";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findMiniCatXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

