/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001e"}, d2={"INTRO_EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "getINTRO_EP", "()Lcom/intellij/database/DbmsExtension;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "db", "Lcom/intellij/database/dataSource/DatabaseConnection;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dbms", "Lcom/intellij/database/Dbms;", "generic", "", "getCurrentSrcIntrospectionVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "hasNativeIntrospector", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "supportedByNativeIntrospector", "version", "Lcom/intellij/database/util/Version;", "intellij.database.impl"})
@JvmName(name="DBIntrospectorFactory")
public final class DBIntrospectorFactory {
    @NotNull
    private static final DbmsExtension<DBIntrospector.Factory> INTRO_EP = new DbmsExtension("com.intellij.database.introspector");

    @NotNull
    public static final DbmsExtension<DBIntrospector.Factory> getINTRO_EP() {
        return INTRO_EP;
    }

    public static final boolean supportedByNativeIntrospector(@NotNull DatabaseConnection db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Dbms dbms = db.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"db.dbms");
        Version version = db.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"db.version");
        return DBIntrospectorFactory.supportedByNativeIntrospector(dbms, version);
    }

    public static final boolean supportedByNativeIntrospector(@NotNull Dbms dbms, @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        DBIntrospector.Factory factory = (DBIntrospector.Factory)INTRO_EP.forDbms(dbms);
        return factory.isNative() && factory.isSupported(version);
    }

    public static final boolean hasNativeIntrospector(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        return ((DBIntrospector.Factory)INTRO_EP.forDbms(dbms)).isNative();
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory, @NotNull DatabaseConnection db, @NotNull LocalDataSource dataSource2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)dataSource2, (String)"dataSource");
        boolean forceGeneric = dataSource2.useLegacyIntrospector();
        if (!forceGeneric) {
            forceGeneric = !DBIntrospectorFactory.supportedByNativeIntrospector(db);
        }
        Dbms dbms = db.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"db.dbms");
        return DBIntrospectorFactory.createIntrospector(project, modelFactory, dbms, forceGeneric);
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull Project project, @Nullable ModelFactory modelFactory, @NotNull Dbms dbms, boolean generic) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        DBIntrospector.Factory factory = (DBIntrospector.Factory)INTRO_EP.forDbms(generic ? Dbms.UNKNOWN : dbms);
        ModelFactory modelFactory2 = modelFactory;
        if (modelFactory2 == null) {
            modelFactory2 = new ModelFactory(BlackHoleTextStorage.INSTANCE);
        }
        return factory.createIntrospector(dbms, project, modelFactory2);
    }

    public static final int getCurrentSrcIntrospectionVersion(@NotNull Dbms dbms, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return ((DBIntrospector.Factory)INTRO_EP.forDbms(dbms)).getVersion(kind);
    }

    public static final boolean isOutdatedCheckSupported(@NotNull Dbms dbms, boolean generic, @Nullable BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        return ((DBIntrospector.Factory)INTRO_EP.forDbms(generic ? Dbms.UNKNOWN : dbms)).isOutdatedCheckSupported(e);
    }
}

