/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayHtmlValuesExtractor
extends HtmlValuesExtractor {
    private static final String VALUE_SECTION_OPEN = "<div style='margin:2px 10px 2px 10px'><pre style='margin: 0'><code>";
    private static final String VALUE_SECTION_CLOSE = "</code></pre></div>";
    protected final String myHex;
    private final String myBorder;
    private final int myTableWidth;

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter) {
        if (background == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        this(background, converter, 100);
    }

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter, int tableWidth) {
        if (background == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        super(converter);
        this.myHex = GuiUtils.colorToHex((Color)background);
        Color borderColor = StartupUiUtil.isUnderDarcula() ? ColorUtil.brighter((Color)background, (int)1) : ColorUtil.darker((Color)background, (int)1);
        this.myBorder = GuiUtils.colorToHex((Color)borderColor);
        this.myTableWidth = tableWidth;
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, boolean forDisplay, boolean escape) {
        if (dbms == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        if (row == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        if (column == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        return super.getValueAsString(row, column, dbms, forDisplay, false);
    }

    @Override
    @NotNull
    public String getDataPrefix() {
        String string = String.format("<div style='margin-top: 2px;'><div style='background-color: #%s'><table border=0 width='%s%%' cellpadding=0 cellspacing=1>", this.myBorder, this.myTableWidth);
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDataSuffix() {
        return "</table></div></div>";
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        return "<tr align=left>";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        String string = "<td align=left style='background-color: #" + this.myHex + "; margin: 0px 0px 0px 0px;'>" + VALUE_SECTION_OPEN;
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        return "</code></pre></div></td>";
    }

    @Override
    public String getLineSeparator() {
        return "";
    }

    @Override
    @NotNull
    public String getColumnName(DataConsumer.Column column) {
        String string = "<th align=left style='background-color: #" + this.myHex + "'>" + VALUE_SECTION_OPEN + this.getName(column) + VALUE_SECTION_CLOSE + "</th>";
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String getName(@NotNull DataConsumer.Column column) {
        if (column == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(10);
        }
        String string = column.name;
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, @NotNull ExtractionConfig config, boolean isTransposedMode, int ... selectedColumns) {
        if (config == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(12);
        }
        return new DisplayHtmlExtraction(out, dbms, config, allColumns, isTransposedMode, selectedColumns);
    }

    @NotNull
    public static String getHeader() {
        return "<html><body>";
    }

    @NotNull
    public static String getTail() {
        return "</body></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DisplayHtmlValuesExtractor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DisplayHtmlValuesExtractor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startExtraction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisplayHtmlExtraction
    extends HtmlValuesExtractor.HtmlExtraction {
        DisplayHtmlExtraction(CharOut output, @NotNull Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, boolean isTransposedMode, int[] selectedColumnIndices) {
            if (config == null) {
                DisplayHtmlExtraction.$$$reportNull$$$0(0);
            }
            super(DisplayHtmlValuesExtractor.this, output, dbms, config, allColumns, isTransposedMode, selectedColumnIndices);
        }

        @Override
        protected String getHeader() {
            return DisplayHtmlValuesExtractor.this.getDataPrefix();
        }

        @Override
        protected String getFooter() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/extractors/DisplayHtmlValuesExtractor$DisplayHtmlExtraction", "<init>"));
        }
    }
}

