/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PasswordStorageComponent {
    private final ComboBox<LocalDataSource.Storage> myComboBox = new ComboBox((Object[])new LocalDataSource.Storage[]{LocalDataSource.Storage.NO, LocalDataSource.Storage.MEMORY, LocalDataSource.Storage.SESSION, LocalDataSource.Storage.PERSIST});

    public PasswordStorageComponent() {
        this.myComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index2) -> {
            label.setText(PasswordStorageComponent.getText(value2));
            label.setToolTipText(PasswordStorageComponent.getToolTip(value2));
        }));
    }

    private static String getToolTip(LocalDataSource.Storage v) {
        if (v == LocalDataSource.Storage.NO) {
            return "Ask password every time it is required";
        }
        if (v == LocalDataSource.Storage.MEMORY) {
            return "Ask password once per application launch";
        }
        if (v == LocalDataSource.Storage.SESSION) {
            return "Forget password after disconnection";
        }
        if (v == LocalDataSource.Storage.PERSIST) {
            return "Remember password";
        }
        return "";
    }

    private static String getText(LocalDataSource.Storage v) {
        if (v == LocalDataSource.Storage.NO) {
            return "Never";
        }
        if (v == LocalDataSource.Storage.MEMORY) {
            return "Until restart";
        }
        if (v == LocalDataSource.Storage.SESSION) {
            return "For session";
        }
        if (v == LocalDataSource.Storage.PERSIST) {
            return "Forever";
        }
        return "";
    }

    @NotNull
    public JComponent getComponent() {
        ComboBox<LocalDataSource.Storage> comboBox = this.myComboBox;
        if (comboBox == null) {
            PasswordStorageComponent.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    public LocalDataSource.Storage getStorage() {
        return (LocalDataSource.Storage)((Object)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), LocalDataSource.Storage.class), (Object)((Object)LocalDataSource.Storage.NO)));
    }

    public void setPasswordStorage(LocalDataSource.Storage storage) {
        this.myComboBox.setSelectedItem((Object)storage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/PasswordStorageComponent", "getComponent"));
    }
}

