/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConnectionInterceptor
implements DatabaseConnectionInterceptor {
    public static final String SSH_HOST = "localhost";

    @Override
    public @Nullable CompletionStage<@NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        DatabaseConnectionPoint connectionPoint;
        JdbcDriverManager driverManager;
        Integer localPort;
        if (proto == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if ((localPort = (driverManager = JdbcDriverManager.getDriverManager(proto.getRunConfiguration().getProject())).getLocalPort((connectionPoint = proto.getConnectionPoint()).getDataSource())) == null) {
            return null;
        }
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        Ref parser2 = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers(), proto.getUrl(), (Ref<JdbcUrlParser>)parser2);
        if (hostPort == null) {
            return null;
        }
        ((JdbcUrlParser)parser2.get()).setParameter("host", SSH_HOST);
        ((JdbcUrlParser)parser2.get()).setParameter("port", String.valueOf(localPort));
        proto.setUrl(((JdbcUrlParser)parser2.get()).getUrlText());
        return CompletableFuture.completedFuture(proto);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "com/intellij/database/dataSource/SshConnectionInterceptor", "intercept"));
    }
}

