/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface DatabaseAuthProvider
extends DatabaseConnectionInterceptor {
    @NonNls
    @NotNull
    public String getId();

    @Nls
    @NotNull
    public String getDisplayName();

    @Nullable
    public AuthWidget createWidget(@NotNull DatabaseCredentials var1, @NotNull LocalDataSource var2);

    public boolean isApplicable(@NotNull LocalDataSource var1);

    default public boolean isApplicableAsDefault(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(0);
        }
        return this.isApplicable(dataSource2);
    }

    @NotNull
    public static List<DatabaseAuthProvider> getApplicable(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(1);
        }
        List list = JBIterable.from((Iterable)EP_NAME.getExtensionsIfPointIsRegistered()).filter(DatabaseAuthProvider.class).filter(ap -> ap.isApplicable(dataSource2)).toList();
        if (list == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static DatabaseAuthProvider getDefault(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(3);
        }
        DatabaseAuthProvider databaseAuthProvider = (DatabaseAuthProvider)Objects.requireNonNull(EP_NAME.findFirstSafe(e -> e instanceof DatabaseAuthProvider && ((DatabaseAuthProvider)e).isApplicableAsDefault(dataSource2)));
        if (databaseAuthProvider == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(4);
        }
        return databaseAuthProvider;
    }

    @Nullable
    public static DatabaseAuthProvider get(@NotNull String id) {
        if (id == null) {
            DatabaseAuthProvider.$$$reportNull$$$0(5);
        }
        return (DatabaseAuthProvider)EP_NAME.findFirstSafe(e -> e instanceof DatabaseAuthProvider && ((DatabaseAuthProvider)e).getId().equals(id));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseAuthProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseAuthProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableAsDefault";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getApplicable";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AuthWidget {
        public void onChanged(@NotNull DocumentListener var1);

        public void save(@NotNull LocalDataSource var1, boolean var2);

        public void reset(@NotNull LocalDataSource var1, boolean var2);

        public boolean isPasswordChanged();

        public void hidePassword();

        public void reloadCredentials();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        public void forceSave();

        public void updateFromUrl(@NotNull ParametersHolder var1);

        public void updateUrl(@NotNull MutableParametersHolder var1);
    }
}

