/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    public static final String ELEMENT_NAME = "ssh-properties";
    private final String mySshConfigId;
    private final boolean myEnabled;

    public DataSourceSshTunnelConfiguration(boolean enabled, @NotNull String sshConfigId) {
        if (sshConfigId == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(0);
        }
        this.myEnabled = enabled;
        this.mySshConfigId = sshConfigId;
    }

    @Nullable
    public SshConfig getSshConfig(Project project) {
        return SshConfigManager.getInstance((Project)project).findConfigById(this.mySshConfigId);
    }

    public String getSshConfigId() {
        return this.mySshConfigId;
    }

    public void enforceCredentials(@NotNull Project project) {
        SshConfig config;
        if (project == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(1);
        }
        if ((config = this.getSshConfig(project)) == null) {
            return;
        }
        SshUiData data = new SshUiData(config);
        data.enforceEmptyCredentials();
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource2) {
        SshConfig config;
        if (xmlReader == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(3);
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String privateKeyPath = "";
        String remoteHost = "";
        String remotePort = "";
        String localPort = "";
        boolean enabled = false;
        AuthType authType = AuthType.PASSWORD;
        LocalDataSource.Storage passwordStorage = LocalDataSource.Storage.MEMORY;
        String sshConfigName = "";
        String sshConfigId = "";
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name = xmlReader.getNodeName();
            String value2 = xmlReader.getValue();
            if ("proxy-host".equals(name)) {
                proxyHost = value2;
            } else if ("proxy-port".equals(name)) {
                proxyPort = value2;
            } else if ("secret-storage".equals(name)) {
                passwordStorage = LocalDataSource.Storage.deserialize(xmlReader.getValue());
            } else if ("user".equals(name)) {
                user = value2;
            } else if ("use-password".equals(name)) {
                authType = Boolean.parseBoolean(value2) ? AuthType.PASSWORD : AuthType.KEY_PAIR;
            } else if ("auth-type".equals(name)) {
                authType = (AuthType)StringUtil.parseEnum((String)value2, (Enum)AuthType.PASSWORD, AuthType.class);
            } else if ("private-key-path".equals(name)) {
                privateKeyPath = value2;
            } else if ("remote-host".equals(name)) {
                remoteHost = value2;
            } else if ("remote-port".equals(name)) {
                remotePort = value2;
            } else if ("local-port".equals(name)) {
                localPort = value2;
            } else if ("enabled".equals(name)) {
                enabled = Boolean.parseBoolean(value2);
            } else if ("ssh-config-name".equals(name)) {
                sshConfigName = value2;
            } else if ("ssh-config-id".equals(name)) {
                sshConfigId = value2;
            }
            xmlReader.moveUp();
        }
        if (!(StringUtil.isEmpty((String)remoteHost) || StringUtil.isEmpty((String)remotePort) || StringUtil.isEmpty((String)localPort))) {
            String url = dataSource2.getUrl();
            url = url.replace(localPort, remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource2.setUrl(url);
        }
        if (!StringUtil.isEmpty((String)sshConfigId)) {
            return new DataSourceSshTunnelConfiguration(enabled, sshConfigId);
        }
        if (!StringUtil.isEmpty((String)sshConfigName) && (config = SshConfigManager.getInstance((Project)project).findConfigByName(sshConfigName)) != null) {
            return new DataSourceSshTunnelConfiguration(enabled, config.getId());
        }
        if (DataSourceSshTunnelConfiguration.isEmpty(proxyHost, user, privateKeyPath)) {
            return null;
        }
        DatabaseCredentials credentials = DatabaseCredentials.getInstance();
        OneTimeString password = credentials.getSshPassword(dataSource2);
        OneTimeString passphrase = credentials.getSshPassphrase(dataSource2);
        SshConfig sshConfig = SshConfigManager.getInstance((Project)project).register(project != null, proxyHost, proxyPort, localPort, user, authType, password == null ? null : password.toString(true), passphrase == null ? null : passphrase.toString(true), passwordStorage.isPersisted(), passwordStorage.isPersisted(), privateKeyPath, null);
        return new DataSourceSshTunnelConfiguration(enabled, sshConfig.getId());
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(4);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSource.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        LocalDataSource.writeTag(serializer, "ssh-config-id", this.mySshConfigId);
        serializer.endNode();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(5);
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.mySshConfigId), (CharSequence)StringUtil.nullize((String)configuration.mySshConfigId));
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        return StringUtil.isEmpty((String)this.mySshConfigId);
    }

    private static boolean isEmpty(String proxyHost, String user, String privateKeyPath) {
        if (StringUtil.isNotEmpty((String)proxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)user)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)privateKeyPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfigId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enforceCredentials";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "equalConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

