/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseToggleNotebookModeAction
extends ToggleAction {
    private static final Logger LOG = Logger.getInstance(DatabaseToggleNotebookModeAction.class);
    private static final String NOTEBOOK_SETTING_ID_KEY = "database.notebook.setting.id";
    private static final PerProjectFileAttributes ourFileAttributes = new PerProjectFileAttributes("database.notebook.mode", 1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(0);
        }
        JdbcConsole console = DatabaseToggleNotebookModeAction.getConsole(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(1);
        }
        return (console = DatabaseToggleNotebookModeAction.getConsole(e)) != null && console.isNotebookMode();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(2);
        }
        if ((console = DatabaseToggleNotebookModeAction.getConsole(e)) == null) {
            return;
        }
        console.setNotebookMode(state, true);
    }

    public static void setNotebookMode(@NotNull Project project, @NotNull JdbcConsole console, boolean state) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(3);
        }
        if (console == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(4);
        }
        String id = DatabaseToggleNotebookModeAction.getCurrentSettingId();
        DaemonCodeAnalyzer.getInstance((Project)project).restart(console.getFile());
        FileAttribute attribute = ourFileAttributes.get(project);
        if (attribute != null) {
            DbImplUtil.writeVFSAttributeSafe(console.getVirtualFile(), attribute, new Value(id, state).toString());
        }
    }

    public static boolean isNotebookMode(@NotNull Project project, @NotNull VirtualFile file) {
        FileAttribute attribute;
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(6);
        }
        if ((attribute = ourFileAttributes.get(project)) == null) {
            return false;
        }
        String saved = DbImplUtil.readVFSAttributeSafe(file, attribute);
        Value value2 = saved == null ? null : Value.from(saved);
        return value2 == null || !value2.id.equals(DatabaseToggleNotebookModeAction.getCurrentSettingId()) ? DatabaseSettings.getSettings().notebookMode : value2.state;
    }

    public static boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(7);
        }
        return !DbSrcUtils.isDbSrcFile(file.getVirtualFile()) && (DbSqlUtil.isSqlFile(file) || ScriptModelUtil.isJSFile(file));
    }

    public static void forgetSavedState() {
        PropertiesComponent.getInstance().setValue(NOTEBOOK_SETTING_ID_KEY, null);
    }

    @Nullable
    private static JdbcConsole getConsole(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(8);
        }
        return (console = JdbcConsole.findConsole(e)) == null ? null : (DatabaseToggleNotebookModeAction.isAvailable(console.getFile()) ? console : null);
    }

    @NotNull
    private static String getCurrentSettingId() {
        PropertiesComponent component = PropertiesComponent.getInstance();
        String value2 = component.getValue(NOTEBOOK_SETTING_ID_KEY);
        if (value2 == null) {
            String result = UUID.randomUUID().toString();
            component.setValue(NOTEBOOK_SETTING_ID_KEY, result);
            String string = result;
            if (string == null) {
                DatabaseToggleNotebookModeAction.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = value2;
        if (string == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettingId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNotebookMode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNotebookMode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Value {
        final String id;
        final boolean state;

        Value(@NotNull String id, boolean state) {
            if (id == null) {
                Value.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.state = state;
        }

        public String toString() {
            return this.id + " " + this.state;
        }

        @Nullable
        static Value from(@NotNull String s) {
            String[] values2;
            if (s == null) {
                Value.$$$reportNull$$$0(1);
            }
            if ((values2 = s.split(" ")).length != 2) {
                return null;
            }
            try {
                String id = UUID.fromString(values2[0]).toString();
                boolean state = Boolean.parseBoolean(values2[1]);
                return new Value(id, state);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction$Value";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

