/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.signature;

import com.trilead.ssh2.signature.DSAKeyAlgorithm;
import com.trilead.ssh2.signature.ECDSAKeyAlgorithm;
import com.trilead.ssh2.signature.ED25519KeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithm;
import com.trilead.ssh2.signature.RSAKeyAlgorithm;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class KeyAlgorithmManager {
    private static final Collection<KeyAlgorithm<PublicKey, PrivateKey>> supportedAlgorithms = KeyAlgorithmManager.buildSupportAlgorithmsList();

    private KeyAlgorithmManager() {
    }

    public static Collection<KeyAlgorithm<PublicKey, PrivateKey>> getSupportedAlgorithms() {
        return supportedAlgorithms;
    }

    private static Collection<KeyAlgorithm<PublicKey, PrivateKey>> buildSupportAlgorithmsList() {
        ArrayList<KeyAlgorithm> algorithms = new ArrayList<KeyAlgorithm>();
        algorithms.add(new ED25519KeyAlgorithm());
        try {
            KeyFactory.getInstance("EC");
            algorithms.add(new ECDSAKeyAlgorithm.ECDSASha2Nistp521());
            algorithms.add(new ECDSAKeyAlgorithm.ECDSASha2Nistp384());
            algorithms.add(new ECDSAKeyAlgorithm.ECDSASha2Nistp256());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        algorithms.add(new RSAKeyAlgorithm());
        algorithms.add(new DSAKeyAlgorithm());
        return Collections.unmodifiableCollection(algorithms);
    }
}

