/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnsignedShortArrayList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final Logger LOG = Logger.getInstance(PausesStat.class);
    private static final int N_MAX = 100000;
    @NotNull
    private final String myName;
    private boolean started;
    private long startTimeStamp;
    private Thread currentThread;
    private final UnsignedShortArrayList durations;
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;
    private int indexToOverwrite;

    public PausesStat(@NotNull String name) {
        if (name == null) {
            PausesStat.$$$reportNull$$$0(0);
        }
        this.durations = new UnsignedShortArrayList();
        this.myName = name;
    }

    private synchronized void register(int duration, @NotNull String description) {
        if (description == null) {
            PausesStat.$$$reportNull$$$0(1);
        }
        if (duration > this.maxDuration) {
            this.maxDuration = duration;
            this.maxDurationDescription = description;
        }
        ++this.totalNumberRecorded;
        if (this.durations.size() == 100000) {
            this.durations.set(this.indexToOverwrite, duration);
            this.indexToOverwrite = (this.indexToOverwrite + 1) % 100000;
        } else {
            this.durations.add(duration);
        }
    }

    public void started() {
        LOG.assertTrue(!this.started);
        LOG.assertTrue(this.startTimeStamp == 0L, this.startTimeStamp);
        this.currentThread = Thread.currentThread();
        this.startTimeStamp = System.nanoTime();
        this.started = true;
    }

    public void finished(@NotNull String description) {
        if (description == null) {
            PausesStat.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.currentThread == Thread.currentThread());
        LOG.assertTrue(this.started);
        this.currentThread = null;
        this.started = false;
        long finishStamp = System.nanoTime();
        long startTimeStamp = this.startTimeStamp;
        int durationMs = (int)TimeUnit.NANOSECONDS.toMillis(finishStamp - startTimeStamp);
        this.startTimeStamp = 0L;
        if (finishStamp - startTimeStamp < 0L || durationMs < 0) {
            return;
        }
        durationMs = Math.min(durationMs, Short.MAX_VALUE);
        this.register(durationMs, description);
    }

    public synchronized String statistics() {
        int number = this.durations.size();
        int[] duration = this.durations.toArray();
        int total = 0;
        for (int d : duration) {
            total += d;
        }
        return this.myName + " Statistics" + (this.totalNumberRecorded == number ? "" : " (" + this.totalNumberRecorded + " events was recorded in total, but only last " + number + " are reported here)") + ":\nEvent number:     " + number + "\nTotal time spent: " + total + "ms\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms\nMax     duration: " + (this.maxDuration == 65535 ? ">" : "") + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/PausesStat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "finished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

