/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;

    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void debug(Throwable t) {
    }

    @Override
    public void debug(@NonNls String message, Throwable t) {
    }

    @Override
    public void info(String message) {
    }

    @Override
    public void info(String message, Throwable t) {
    }

    @Override
    public void warn(@NonNls String message, @Nullable Throwable t) {
        t = DefaultLogger.checkException(t);
        System.err.println("WARN: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t = DefaultLogger.checkException(t);
        message = message + DefaultLogger.attachmentsToString(t);
        DefaultLogger.dumpExceptionsToStderr(message, t, details);
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(t);
        throw error;
    }

    public static void dumpExceptionsToStderr(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(1);
        }
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            if (details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
    }

    @Override
    public void setLevel(Level level) {
    }

    public static String attachmentsToString(@Nullable Throwable t) {
        Throwable rootCause;
        Throwable throwable = rootCause = t == null ? null : ExceptionUtil.getRootCause(t);
        if (rootCause instanceof ExceptionWithAttachments) {
            return "\n\nAttachments:\n" + StringUtil.join(((ExceptionWithAttachments)((Object)rootCause)).getAttachments(), ATTACHMENT_TO_STRING::apply, "\n----\n");
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    public static void disableStderrDumping(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
        final boolean prev = ourMirrorToStderr;
        ourMirrorToStderr = false;
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ourMirrorToStderr = prev;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpExceptionsToStderr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disableStderrDumping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

