/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    public static final String L10N_MARKER = "\ud83d\udd05";
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    private static boolean assertOnMissedKeys = false;
    private static final String[] SUFFIXES = new String[]{"</body></html>", "</html>"};

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(0);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(1);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(2);
        }
        String string = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string == null) {
            BundleBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value;
        if (key == null) {
            BundleBase.$$$reportNull$$$0(4);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(5);
        }
        if (bundle == null) {
            return defaultValue;
        }
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            value = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result = BundleBase.postprocessValue(bundle, value, params);
        if (SHOW_LOCALIZED_MESSAGES) {
            return BundleBase.appendLocalizationMarker(result);
        }
        return result;
    }

    @NotNull
    protected static String appendLocalizationMarker(@NotNull String result) {
        if (result == null) {
            BundleBase.$$$reportNull$$$0(6);
        }
        for (String suffix : SUFFIXES) {
            if (!result.endsWith(suffix)) continue;
            String string = result.substring(0, result.length() - suffix.length()) + L10N_MARKER + suffix;
            if (string == null) {
                BundleBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = result + L10N_MARKER;
        if (string == null) {
            BundleBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue) {
        if (key == null) {
            BundleBase.$$$reportNull$$$0(9);
        }
        if (defaultValue != null) {
            String string = defaultValue;
            if (string == null) {
                BundleBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (assertOnMissedKeys) assert (false) : "'" + key + "' is not found in " + bundle;
        String string = "!" + key + "!";
        if (string == null) {
            BundleBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    static String postprocessValue(@NotNull ResourceBundle bundle, @Nullable String value, @NotNull Object[] params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(12);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(13);
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
                OrdinalFormat.apply(format);
                value = format.format(params);
            }
            catch (IllegalArgumentException e) {
                value = "!invalid format: `" + value + "`!";
            }
        }
        return value;
    }

    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        if (value == null) {
            BundleBase.$$$reportNull$$$0(14);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(15);
        }
        String string = params.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params) : value;
        if (string == null) {
            BundleBase.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(value="null -> null")
    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/BundleBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/BundleBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLocalizationMarker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "useDefaultValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendLocalizationMarker";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useDefaultValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "postprocessValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

