/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ES6Parser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionParser
extends JavaScriptParserBase {
    protected static final Logger LOG = Logger.getInstance(ExpressionParser.class);
    protected static final Key<IElementType> DESTRUCTURING_VAR_TYPE = Key.create((String)"within.destructuring.expression");
    protected static final Key<Boolean> ALLOW_PIPE_TOPICS = Key.create((String)"allow.pipe.topics");
    protected static final Key<Boolean> HAS_PIPE_TOPICS = Key.create((String)"has.pipe.topics");
    private int myNestedObjectLiterals = 0;

    protected ExpressionParser(JavaScriptParser parser) {
        super(parser);
    }

    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSElementTypes.THIS_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            return true;
        }
        if (firstToken == JSElementTypes.SUPER_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.SUPER_EXPRESSION);
            return true;
        }
        if (firstToken == JSElementTypes.LET_KEYWORD && this.parseLetExpression()) {
            return true;
        }
        if (this.builder.getTokenType() == JSElementTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker classMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            modifierList.done(this.myJavaScriptParser.getFunctionParser().getAttributeListElementType());
            this.myJavaScriptParser.getStatementParser().parseClassNoMarker(classMarker, true, true);
            return true;
        }
        if (this.isIdentifierToken(firstToken) || firstToken == JSElementTypes.ANY_IDENTIFIER) {
            PsiBuilder.Marker start2 = this.builder.mark();
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
            if (this.proceedWithNamespaceReference(start2)) {
                start2.precede().done(JSElementTypes.REFERENCE_EXPRESSION);
            }
            return true;
        }
        if (firstToken == JSElementTypes.NUMERIC_LITERAL || firstToken == JSElementTypes.STRING_LITERAL || firstToken == JSElementTypes.REGEXP_LITERAL || firstToken == JSElementTypes.NULL_KEYWORD || firstToken == JSElementTypes.UNDEFINED_KEYWORD || firstToken == JSElementTypes.FALSE_KEYWORD || firstToken == JSElementTypes.TRUE_KEYWORD) {
            String errorMessage = this.validateLiteral();
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.LITERAL_EXPRESSION);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }
        if (firstToken == JSElementTypes.LPAR) {
            this.parseParenthesizedExpression();
            return true;
        }
        if (firstToken == JSElementTypes.LBRACKET) {
            this.parseArrayLiteralExpression(true, false);
            return true;
        }
        if (firstToken == JSElementTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
            return true;
        }
        if (firstToken == JSElementTypes.FUNCTION_KEYWORD) {
            this.myJavaScriptParser.getFunctionParser().parseFunctionExpression();
            return true;
        }
        if (JSElementTypes.ACCESS_MODIFIERS.contains(firstToken)) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (JSElementTypes.COLON_COLON == this.builder.getTokenType()) {
                this.builder.advanceLexer();
                if (this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.advanceLexer();
                }
            } else {
                marker.drop();
                return false;
            }
            marker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (firstToken == JSElementTypes.AT) {
            PsiBuilder.Marker attrReferenceStartMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            this.myJavaScriptParser.getFunctionParser().parseES7Decorators();
            modifierList.done(this.myJavaScriptParser.getFunctionParser().getAttributeListElementType());
            if (this.builder.getTokenType() == JSElementTypes.CLASS_KEYWORD) {
                this.myJavaScriptParser.getStatementParser().parseClassNoMarker(attrReferenceStartMarker, true, true);
            } else {
                attrReferenceStartMarker.drop();
                this.builder.error("class expected");
            }
            return true;
        }
        if (firstToken == JSElementTypes.INT_KEYWORD || firstToken == JSElementTypes.UINT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (firstToken == JSElementTypes.BACKQUOTE) {
            return this.parseStringTemplate();
        }
        return false;
    }

    private void parseYieldExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.YIELD_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!ExpressionParser.hasSemanticLinefeedBefore(this.builder)) {
            if (this.builder.getTokenType() == JSElementTypes.MULT && this.hasGeneratorsSupport()) {
                this.builder.advanceLexer();
            }
            this.parseAssignmentExpression(true);
        }
        marker.done(JSElementTypes.YIELD_EXPRESSION);
    }

    protected boolean hasGeneratorsSupport() {
        return false;
    }

    protected boolean parseStringTemplate() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.BACKQUOTE);
        PsiBuilder.Marker stringTemplate = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSElementTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error("missing `");
                stringTemplate.done((IElementType)JSElementTypes.STRING_TEMPLATE_EXPRESSION);
                return false;
            }
            if (this.builder.getTokenType() == JSElementTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
                continue;
            }
            if (this.builder.getTokenType() == JSElementTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSElementTypes.LBRACE) continue;
                this.builder.advanceLexer();
                if (!this.parseAssignmentExpression(true)) {
                    this.builder.error("expression expected");
                }
                ExpressionParser.checkMatches(this.builder, JSElementTypes.RBRACE, "} expected");
                continue;
            }
            this.builder.error("missing `");
            this.builder.advanceLexer();
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.BACKQUOTE, "missing `");
        stringTemplate.done((IElementType)JSElementTypes.STRING_TEMPLATE_EXPRESSION);
        return true;
    }

    private boolean parseLetExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LET_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.myJavaScriptParser.getStatementParser().parseLetDeclarations()) {
            marker.rollbackTo();
            return false;
        }
        this.parseExpression();
        marker.done(JSElementTypes.LET_EXPRESSION);
        return true;
    }

    @Nullable
    protected String validateLiteral() {
        IElementType ttype = this.builder.getTokenType();
        if (ttype == JSElementTypes.STRING_LITERAL) {
            String ttext = this.builder.getTokenText();
            assert (ttext != null);
            return ExpressionParser.validateLiteralText(ttext);
        }
        return null;
    }

    protected static String validateLiteralText(String text) {
        if (ExpressionParser.lastSymbolEscaped(text) || text.startsWith("\"") && (!text.endsWith("\"") || text.length() == 1) || text.startsWith("'") && (!text.endsWith("'") || text.length() == 1)) {
            return "Unclosed string literal";
        }
        return null;
    }

    private static boolean lastSymbolEscaped(String text) {
        boolean escapes = false;
        boolean escaped = true;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (escapes) {
                escapes = false;
                escaped = true;
                continue;
            }
            if (c == '\\') {
                escapes = true;
            }
            escaped = false;
        }
        return escapes || escaped;
    }

    protected void parseDestructuringProperty() {
        IElementType nameToken = this.builder.getTokenType();
        PsiBuilder.Marker property = this.builder.mark();
        if (this.isIdentifierToken(nameToken) && this.builder.lookAhead(1) != JSElementTypes.COLON) {
            this.parseDestructuringElement();
            property.done((IElementType)JSElementTypes.DESTRUCTURING_SHORTHANDED_PROPERTY);
            return;
        }
        if (!this.parsePropertyName()) {
            this.builder.advanceLexer();
            property.done((IElementType)JSElementTypes.DESTRUCTURING_PROPERTY);
            return;
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.COLON, ": expected");
        IElementType valueFirstToken = this.builder.getTokenType();
        if (valueFirstToken == JSElementTypes.LBRACE || valueFirstToken == JSElementTypes.LBRACKET || this.isIdentifierToken(valueFirstToken)) {
            this.parseDestructuringElement();
        } else {
            this.builder.error("identifier, { or [ expected");
        }
        property.done((IElementType)JSElementTypes.DESTRUCTURING_PROPERTY);
    }

    public void parseDestructuringElement(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        if (varType == null) {
            ExpressionParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        IElementType elementType = this.parseDestructuringElementNoMarker(varType, parseType, isOuterParameterElement);
        marker.done(elementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IElementType parseDestructuringElementNoMarker(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        if (varType == null) {
            ExpressionParser.$$$reportNull$$$0(1);
        }
        IElementType savedDestructuringVarType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
        try {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)varType);
            IElementType iElementType = this.parseDestructuringElementNoMarker(parseType, isOuterParameterElement);
            return iElementType;
        }
        finally {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)savedDestructuringVarType);
        }
    }

    protected void parseDestructuringArrayElement() {
        this.parseDestructuringElement();
    }

    private void parseDestructuringElement() {
        PsiBuilder.Marker marker = this.builder.mark();
        marker.done(this.parseDestructuringElementNoMarker(false, false));
    }

    protected IElementType parseDestructuringElementNoMarker(boolean parseType, boolean isOuterParameterElement) {
        JSElementTypes.JSElType elementType;
        IElementType firstToken = this.builder.getTokenType();
        boolean isSingleNameBinding = false;
        if (this.isIdentifierToken(firstToken)) {
            isSingleNameBinding = true;
            this.builder.advanceLexer();
        } else if (JSElementTypes.LBRACE == firstToken) {
            this.parseObjectLiteralExpression(true);
        } else if (JSElementTypes.LBRACKET == firstToken) {
            this.parseArrayLiteralExpression(true, true);
        } else {
            this.builder.advanceLexer();
            this.builder.error("identifier expected");
        }
        if (isOuterParameterElement) {
            this.myJavaScriptParser.getFunctionParser().parseParameterOptionalMark();
        }
        if (parseType) {
            this.myJavaScriptParser.getTypeParser().tryParseType();
        }
        if (this.builder.getTokenType() == JSElementTypes.EQ) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
        }
        if (isSingleNameBinding) {
            elementType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (elementType != null);
        } else {
            elementType = isOuterParameterElement ? JSElementTypes.DESTRUCTURING_PARAMETER : JSElementTypes.DESTRUCTURING_ELEMENT;
        }
        return elementType;
    }

    protected void parseObjectLiteralExpression(boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LBRACE);
        ++this.myNestedObjectLiterals;
        if (this.myNestedObjectLiterals > 100) {
            this.builder.advanceLexer();
            return;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        IElementType elementType = this.builder.getTokenType();
        while (elementType != JSElementTypes.RBRACE && elementType != null) {
            if (!this.isPropertyStart(elementType)) {
                this.builder.error("identifier or string literal or numeric literal expected");
                break;
            }
            if (isDestructuring) {
                this.parseDestructuringProperty();
            } else {
                this.parseProperty();
            }
            while (this.myNestedObjectLiterals > 100 && this.builder.getTokenType() == JSElementTypes.RBRACE) {
                --this.myNestedObjectLiterals;
                this.builder.advanceLexer();
            }
            boolean wasCommaBefore = false;
            elementType = this.builder.getTokenType();
            if (elementType == JSElementTypes.RBRACE) break;
            if (elementType == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                wasCommaBefore = true;
            } else {
                this.builder.error(", expected");
            }
            elementType = this.builder.getTokenType();
            if (elementType == JSElementTypes.RBRACE) {
                if (wasCommaBefore) break;
                this.builder.error("property expected");
                continue;
            }
            if (this.isPropertyStart(elementType)) continue;
            break;
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.RBRACE, "} expected");
        expr.done((IElementType)(isDestructuring ? JSElementTypes.DESTRUCTURING_OBJECT : JSElementTypes.OBJECT_LITERAL_EXPRESSION));
        --this.myNestedObjectLiterals;
    }

    protected boolean isPropertyStart(IElementType elementType) {
        return this.isPropertyNameStart(elementType) || elementType == JSElementTypes.DOT || elementType == JSElementTypes.DOT_DOT_DOT;
    }

    public boolean isPropertyNameStart(IElementType elementType) {
        return JSElementTypes.PROPERTY_NAMES.contains(elementType) || elementType == JSElementTypes.LBRACKET;
    }

    public boolean parsePropertyName() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSElementTypes.LBRACKET) {
            PsiBuilder.Marker computedPropertyMarker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseAssignmentExpression(false);
            ExpressionParser.checkMatches(this.builder, JSElementTypes.RBRACKET, "] expected");
            computedPropertyMarker.done((IElementType)JSElementTypes.COMPUTED_NAME);
            return true;
        }
        if (JSElementTypes.PROPERTY_NAMES.contains(tokenType)) {
            this.advancePropertyName(tokenType);
            return true;
        }
        this.builder.error("property name expected");
        return false;
    }

    public void advancePropertyName(@Nullable IElementType tokenType) {
        if (!JSElementTypes.NON_IDENTIFIER_PROPERTY_NAMES.contains(tokenType)) {
            this.advanceIdentifier(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    private void advanceIdentifier(@Nullable IElementType currentTokenType) {
        if (currentTokenType != JSElementTypes.IDENTIFIER) {
            this.builder.remapCurrentToken(JSElementTypes.IDENTIFIER);
        }
        this.builder.advanceLexer();
    }

    protected final void parseProperty() {
        PsiBuilder.Marker mark2 = this.builder.mark();
        if (!this.parsePropertyNoMarker(mark2)) {
            mark2.drop();
        }
    }

    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        if (firstToken == JSElementTypes.LBRACKET) {
            boolean lexerAdvanced = this.parsePropertyName();
            assert (lexerAdvanced) : "must be advanced after LBRACKET";
            if (this.builder.getTokenType() == JSElementTypes.LPAR) {
                this.parseFunctionPropertyNoMarker(property, true);
            } else {
                this.parsePropertyInitializer(false);
                property.done((IElementType)JSElementTypes.PROPERTY);
            }
            return true;
        }
        if (this.isFunctionPropertyStart()) {
            this.parseFunctionPropertyNoMarker(property, false);
            return true;
        }
        if (this.myJavaScriptParser.isIdentifierName(firstToken) && (secondToken == JSElementTypes.COMMA || secondToken == JSElementTypes.RBRACE || this.canBeIncompleteProperty())) {
            PsiBuilder.Marker ref = this.builder.mark();
            this.builder.advanceLexer();
            ref.done(JSElementTypes.REFERENCE_EXPRESSION);
            property.done((IElementType)JSElementTypes.PROPERTY);
            return true;
        }
        if (this.myJavaScriptParser.isIdentifierName(firstToken) && secondToken == JSElementTypes.EQ) {
            PsiBuilder.Marker ref = this.builder.mark();
            this.builder.advanceLexer();
            ref.done(JSElementTypes.REFERENCE_EXPRESSION);
            this.builder.advanceLexer();
            this.parseAssignmentExpression(false);
            property.done((IElementType)JSElementTypes.ASSIGNMENT_PROPERTY);
            return true;
        }
        if (firstToken == JSElementTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(false);
            property.done((IElementType)JSElementTypes.SPREAD_EXPRESSION);
            return true;
        }
        if (JSElementTypes.PROPERTY_NAMES.contains(firstToken)) {
            String errorMessage = this.validateLiteral();
            this.advancePropertyName(firstToken);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
        } else {
            this.builder.error("property name expected");
            this.builder.advanceLexer();
        }
        this.parsePropertyInitializer(JSElementTypes.IDENTIFIER_NAMES.contains(firstToken));
        property.done((IElementType)JSElementTypes.PROPERTY);
        property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    private boolean canBeIncompleteProperty() {
        if (!ExpressionParser.hasSemanticLinefeedAfter(this.builder)) {
            return false;
        }
        return this.isPropertyNameStart(this.builder.getTokenType());
    }

    @Deprecated
    protected void parsePropertyInitializer() {
        this.parsePropertyInitializer(false);
    }

    protected void parsePropertyInitializer(boolean couldHaveComma) {
        if (!ExpressionParser.checkMatches(this.builder, JSElementTypes.COLON, couldHaveComma ? ": or , expected" : ": expected") && ExpressionParser.hasSemanticLinefeedBefore(this.builder)) {
            return;
        }
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error("expression expected");
        }
    }

    protected boolean isFunctionPropertyStart() {
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        return JSElementTypes.PROPERTY_NAMES.contains(firstToken) && secondToken == JSElementTypes.LPAR || ES6Parser.ES6StatementParser.isFunctionAttributeListPart(firstToken) && ES6Parser.ES6StatementParser.isAttributeListPartOrMethodNameStart(secondToken);
    }

    protected void parseFunctionPropertyNoMarker(PsiBuilder.Marker property, boolean skipName) {
        boolean lexerAdvanced = false;
        boolean parsedGenerator = false;
        if (!skipName) {
            if (ES6Parser.ES6StatementParser.isFunctionAttributeListPart(this.builder.getTokenType()) && ES6Parser.ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
                this.myJavaScriptParser.getFunctionParser().parseFunctionExpressionAttributeList();
            }
            if (this.builder.getTokenType() == JSElementTypes.MULT) {
                parsedGenerator = true;
                this.builder.advanceLexer();
            }
            lexerAdvanced = this.parsePropertyName();
        }
        boolean wasGenerator = this.myJavaScriptParser.getFunctionParser().isGeneratorContext();
        this.myJavaScriptParser.getFunctionParser().setIsGenerator(parsedGenerator);
        if (!(lexerAdvanced |= this.myJavaScriptParser.getFunctionParser().parseParameterListAndBody(property, this.getFunctionPropertyElementType()))) {
            this.builder.advanceLexer();
        }
        this.myJavaScriptParser.getFunctionParser().setIsGenerator(wasGenerator);
    }

    protected IElementType getFunctionPropertyElementType() {
        return JSElementTypes.FUNCTION_PROPERTY;
    }

    private void parseArrayLiteralExpression(boolean allowSkippingLeadingElements, boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LBRACKET);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean commaExpected = false;
        boolean first2 = true;
        Ref elementTypeRef = Ref.create((Object)((Object)(isDestructuring ? JSElementTypes.DESTRUCTURING_ARRAY : JSElementTypes.ARRAY_LITERAL_EXPRESSION)));
        while (this.builder.getTokenType() != JSElementTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected) {
                ExpressionParser.checkMatches(this.builder, JSElementTypes.COMMA, ", expected");
            }
            if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                if (!allowSkippingLeadingElements) {
                    this.builder.error("expression expected");
                }
                while (this.builder.getTokenType() == JSElementTypes.COMMA) {
                    PsiBuilder.Marker emptyMark = this.builder.mark();
                    emptyMark.done((IElementType)JSElementTypes.EMPTY_EXPRESSION);
                    this.builder.advanceLexer();
                }
            }
            commaExpected = false;
            if (this.builder.getTokenType() == JSElementTypes.RBRACKET) continue;
            if (isDestructuring) {
                this.parseDestructuringArrayElement();
            } else {
                if (!this.parseArrayElement(first2, (Ref<IElementType>)elementTypeRef)) break;
                first2 = false;
            }
            commaExpected = true;
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.RBRACKET, "] expected");
        marker.done((IElementType)elementTypeRef.get());
    }

    protected boolean parseArrayElement(boolean first2, Ref<IElementType> elementTypeRef) {
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error("expression expected");
            return false;
        }
        if (first2 && this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD) {
            elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
            this.myJavaScriptParser.getStatementParser().parseForLoopHeader();
            if (this.builder.getTokenType() == JSElementTypes.IF_KEYWORD) {
                this.myJavaScriptParser.getStatementParser().parseIfStatementHeader();
            }
            return false;
        }
        return true;
    }

    public void parseParenthesizedExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LPAR);
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.parseExpressionOptional(true, true)) {
            this.builder.error("expression expected");
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        expr.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
    }

    public boolean parseLeftHandSideExpression(boolean onlyMemberExpression) {
        return this.parseLeftHandSideExpression(onlyMemberExpression, true);
    }

    public boolean parseLeftHandSideExpression(boolean onlyMemberExpression, boolean allowIndexer) {
        boolean isNew;
        PsiBuilder.Marker expr = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSElementTypes.SHARP && this.builder.getUserData(ALLOW_PIPE_TOPICS) == Boolean.TRUE) {
            this.builder.advanceLexer();
            expr.done((IElementType)JSElementTypes.EMPTY_EXPRESSION);
            expr = expr.precede();
            isNew = false;
            this.builder.putUserData(HAS_PIPE_TOPICS, (Object)true);
        } else if (type == JSElementTypes.NEW_KEYWORD) {
            isNew = this.parseNewExpression();
        } else if (type == JSElementTypes.COLON_COLON) {
            this.builder.advanceLexer();
            this.parseLeftHandSideExpression(true);
            expr.done(JSElementTypes.BIND_EXPRESSION);
            expr = expr.precede();
            isNew = false;
        } else if (type == JSElementTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.LPAR) {
            this.parseImportCall(expr);
            expr = expr.precede();
            isNew = false;
        } else if (type == JSElementTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.DOT && this.builder.lookAhead(2) == JSElementTypes.IDENTIFIER) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (!"meta".equals(this.builder.getTokenText())) {
                this.builder.error("only 'meta' is accepted as meta property for import");
            }
            this.builder.advanceLexer();
            expr.done(JSElementTypes.META_PROPERTY);
            expr = expr.precede();
            isNew = false;
        } else {
            isNew = false;
            if (!this.parsePrimaryExpression()) {
                expr.drop();
                return false;
            }
        }
        while (true) {
            IElementType tokenType = this.builder.getTokenType();
            boolean parsedSuccessfully = true;
            IElementType safeAccessOperator = this.getSafeAccessOperator();
            if (this.isReferenceQualifierSeparator(tokenType)) {
                IElementType separatorType = tokenType;
                PsiBuilder.Marker dotMark = this.builder.mark();
                this.builder.advanceLexer();
                this.parseAdditionalReferenceSeparator(dotMark);
                if (this.builder.getTokenType() == JSElementTypes.AT) {
                    this.builder.advanceLexer();
                }
                if ((tokenType = this.builder.getTokenType()) == JSElementTypes.ANY_IDENTIFIER || this.myJavaScriptParser.isIdentifierName(tokenType)) {
                    PsiBuilder.Marker identifier = this.builder.mark();
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSElementTypes.COLON_COLON) {
                        identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                        this.proceedWithNamespaceReference(identifier.precede());
                    } else {
                        identifier.drop();
                    }
                } else {
                    if (separatorType != null && separatorType == safeAccessOperator && (this.isParenAfterReferenceSeparator(tokenType) || tokenType == JSElementTypes.LBRACKET)) continue;
                    this.builder.error("name expected");
                }
                expr.done(JSElementTypes.REFERENCE_EXPRESSION);
                expr = expr.precede();
            } else if (allowIndexer && tokenType == JSElementTypes.LBRACKET) {
                this.builder.advanceLexer();
                this.parseExpression();
                ExpressionParser.checkMatches(this.builder, JSElementTypes.RBRACKET, "] expected");
                expr.done(JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
                expr = expr.precede();
            } else if (!onlyMemberExpression && tokenType == JSElementTypes.LPAR) {
                this.parseArgumentList();
                expr.done((IElementType)(isNew ? this.getNewExpressionElementType() : JSElementTypes.CALL_EXPRESSION));
                expr = expr.precede();
                isNew = false;
            } else if (tokenType == JSElementTypes.BACKQUOTE) {
                this.parseStringTemplate();
                expr.done(JSElementTypes.TAGGED_TEMPLATE_EXPRESSION);
                expr = expr.precede();
            } else if (tokenType == JSElementTypes.COLON_COLON && !onlyMemberExpression) {
                if (isNew) {
                    expr.done(this.getNewExpressionElementType());
                    expr = expr.precede();
                    isNew = false;
                }
                this.builder.advanceLexer();
                if (!this.parseLeftHandSideExpression(true)) {
                    this.builder.error("expression expected");
                }
                expr.done(JSElementTypes.BIND_EXPRESSION);
                expr = expr.precede();
            } else {
                Ref ref = Ref.create((Object)expr);
                parsedSuccessfully = this.parseDialectSpecificMemberExpressionPart((Ref<PsiBuilder.Marker>)ref);
                if (parsedSuccessfully) {
                    expr = (PsiBuilder.Marker)ref.get();
                }
            }
            if (!parsedSuccessfully) break;
        }
        if (isNew) {
            expr.done(this.getNewExpressionElementType());
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean isParenAfterReferenceSeparator(IElementType tokenType) {
        return tokenType == JSElementTypes.LPAR;
    }

    public void parseImportCall(PsiBuilder.Marker expr) {
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.parseAssignmentExpression(false);
        if (this.builder.getTokenType() == JSElementTypes.COMMA) {
            this.builder.advanceLexer();
        }
        ExpressionParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        expr.done(JSElementTypes.IMPORT_CALL);
    }

    protected void parseAdditionalReferenceSeparator(PsiBuilder.Marker mark2) {
        mark2.drop();
    }

    @Nullable
    protected IElementType getSafeAccessOperator() {
        return null;
    }

    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return tokenType == JSElementTypes.DOT;
    }

    protected IElementType getNewExpressionElementType() {
        return JSElementTypes.NEW_EXPRESSION;
    }

    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
        return false;
    }

    public boolean proceedWithNamespaceReference(PsiBuilder.Marker identifier) {
        identifier.drop();
        return false;
    }

    public boolean parseQualifiedTypeName() {
        return this.parseQualifiedTypeName(false);
    }

    public boolean parseQualifiedTypeName(boolean allowStar) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            return false;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        return this.parseQualifiedTypeNameRest(allowStar, expr);
    }

    public boolean parseQualifiedTypeNameRest(boolean allowStar, PsiBuilder.Marker expr) {
        while (this.builder.getTokenType() == JSElementTypes.DOT) {
            this.builder.advanceLexer();
            IElementType tokenType = this.builder.getTokenType();
            boolean stop = false;
            if (tokenType == JSElementTypes.ANY_IDENTIFIER && allowStar) {
                this.builder.advanceLexer();
                stop = true;
            } else if (tokenType != JSElementTypes.IDENTIFIER && this.myJavaScriptParser.isIdentifierName(tokenType)) {
                this.builder.advanceLexer();
            } else {
                ExpressionParser.checkMatches(this.builder, JSElementTypes.IDENTIFIER, "name expected");
            }
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
            expr = expr.precede();
            if (!stop) continue;
            break;
        }
        return this.parseQualifiedTypeNameTail(expr);
    }

    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        expr.drop();
        return true;
    }

    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSElementTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.myJavaScriptParser.getFunctionParser().parseFunctionExpression();
            marker.done(this.getNewExpressionElementType());
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseLeftHandSideExpression(true)) {
            this.builder.error("expression expected");
        }
        while (this.builder.getTokenType() == JSElementTypes.LBRACKET) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSElementTypes.RBRACKET) {
                this.builder.error("] expected");
                break;
            }
            this.builder.advanceLexer();
        }
        return true;
    }

    public void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LPAR);
        PsiBuilder.Marker arglist = this.builder.mark();
        this.parseArgumentListNoMarker();
        arglist.done(JSElementTypes.ARGUMENT_LIST);
    }

    protected void parseArgumentListNoMarker() {
        this.builder.advanceLexer();
        this.parseArgumentListNoParNoMarker(true);
        ExpressionParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
    }

    protected void parseArgumentListNoParNoMarker(boolean expectRPar) {
        boolean first2 = true;
        while (this.builder.getTokenType() != JSElementTypes.RPAR && (expectRPar || !this.builder.eof())) {
            if (first2) {
                first2 = false;
            } else if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSElementTypes.RPAR && this.myJavaScriptParser.getFunctionParser().allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(", or ) expected");
                break;
            }
            if (this.parseArgument()) continue;
            this.builder.error("expression expected");
        }
    }

    protected boolean parseArgument() {
        return this.parseGeneratorExpression();
    }

    public void parseExpression() {
        if (!this.parseExpressionOptional()) {
            this.builder.error("expression expected");
        }
    }

    public boolean parseGeneratorExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseAssignmentExpression(true)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD) {
            this.myJavaScriptParser.getStatementParser().parseForLoopHeader();
            if (this.builder.getTokenType() == JSElementTypes.IF_KEYWORD) {
                this.myJavaScriptParser.getStatementParser().parseIfStatementHeader();
            }
            expr.done(JSElementTypes.GENERATOR_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseAssignmentExpression(boolean allowIn) {
        if (this.builder.getTokenType() == JSElementTypes.YIELD_KEYWORD && (this.myJavaScriptParser.getFunctionParser().isGeneratorContext() || ExpressionParser.isDefinitelyYieldExpression(this.builder.lookAhead(1)))) {
            this.parseYieldExpression();
            return true;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        if (JSElementTypes.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            this.builder.error("expression expected");
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error("expression expected");
            }
            expr.done((IElementType)JSElementTypes.ASSIGNMENT_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker definitionExpr = this.builder.mark();
        if (!this.parseConditionalExpression(allowIn)) {
            definitionExpr.drop();
            expr.drop();
            return false;
        }
        if (JSElementTypes.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            definitionExpr.done((IElementType)JSElementTypes.DEFINITION_EXPRESSION);
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error("expression expected");
            }
            expr.done((IElementType)JSElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            definitionExpr.drop();
            expr.drop();
        }
        return true;
    }

    private static boolean isDefinitelyYieldExpression(IElementType tokenType) {
        return JSElementTypes.IDENTIFIER_NAMES.contains(tokenType) || JSElementTypes.LITERALS.contains(tokenType) || tokenType == JSElementTypes.LBRACE || tokenType == JSElementTypes.LBRACKET;
    }

    protected boolean parseConditionalExpression(boolean allowIn) {
        IElementType nextTokenType;
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseBinaryExpression(allowIn)) {
            if (this.builder.getTokenType() == JSElementTypes.QUEST) {
                this.builder.error("expression expected");
            } else {
                expr.drop();
                return false;
            }
        }
        if ((nextTokenType = this.builder.getTokenType()) == JSElementTypes.QUEST) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error("expression expected");
            }
            ExpressionParser.checkMatches(this.builder, JSElementTypes.COLON, ": expected");
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error("expression expected");
            }
            expr.done(JSElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseBinaryExpression(boolean allowIn) {
        IElementType elementType;
        int priority;
        PsiBuilder.Marker currentMarker = this.builder.mark();
        if (!this.parseUnaryExpression()) {
            currentMarker.drop();
            return false;
        }
        if (this.getCurrentBinarySignPriority(allowIn, false) < 0) {
            currentMarker.drop();
            return true;
        }
        int depth = 0;
        ArrayDeque<MarkerData> markers = new ArrayDeque<MarkerData>();
        boolean tempStop = false;
        while ((priority = this.getCurrentBinarySignPriority(allowIn, false)) >= 0) {
            BinaryParsingState parsingState;
            boolean depthExceeded;
            IElementType type = this.builder.getTokenType();
            elementType = this.getBinaryExpressionElementType(type);
            boolean bl = depthExceeded = depth >= 100;
            if (!(depthExceeded || markers.isEmpty() || ((MarkerData)markers.peek()).getPriority() < priority && !tempStop)) {
                int lastPriority;
                currentMarker.drop();
                PsiBuilder.Marker lastPoppedMarker = null;
                while (!markers.isEmpty() && ((MarkerData)markers.peek()).getPriority() > priority) {
                    MarkerData markerData = (MarkerData)markers.pop();
                    lastPoppedMarker = markerData.getMarker();
                    lastPoppedMarker.done(markerData.getElementType());
                }
                int n = lastPriority = markers.isEmpty() ? -1 : ((MarkerData)markers.peek()).getPriority();
                if (lastPriority == priority || tempStop && !markers.isEmpty()) {
                    MarkerData markerData = (MarkerData)markers.pop();
                    PsiBuilder.Marker lastMarker = markerData.getMarker();
                    lastMarker.done(markerData.getElementType());
                    PsiBuilder.Marker precede = lastMarker.precede();
                    markers.push(new MarkerData(priority, precede, elementType));
                } else {
                    assert (lastPriority < priority || tempStop);
                    assert (lastPoppedMarker != null);
                    PsiBuilder.Marker precede = lastPoppedMarker.precede();
                    markers.push(new MarkerData(priority, precede, elementType));
                }
            } else if (!depthExceeded) {
                markers.push(new MarkerData(priority, currentMarker, elementType));
            }
            tempStop = false;
            this.getCurrentBinarySignPriority(allowIn, true);
            if (!depthExceeded) {
                currentMarker = this.builder.mark();
            }
            if (type == JSElementTypes.PIPE) {
                this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)true);
                this.builder.putUserData(HAS_PIPE_TOPICS, (Object)false);
            }
            if ((parsingState = this.parseBinaryRightHandSide()) == BinaryParsingState.FAIL || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                this.builder.error("expression expected");
            }
            if (parsingState == BinaryParsingState.STOP || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                tempStop = true;
            }
            ++depth;
        }
        currentMarker.drop();
        while (!markers.isEmpty()) {
            MarkerData markerData = (MarkerData)markers.pop();
            elementType = markerData.getElementType();
            markerData.getMarker().done(elementType);
            if (elementType != JSElementTypes.PIPE_EXPRESSION) continue;
            this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)false);
        }
        return true;
    }

    protected IElementType getBinaryExpressionElementType(IElementType signType) {
        if (signType == JSElementTypes.PIPE) {
            return JSElementTypes.PIPE_EXPRESSION;
        }
        return JSElementTypes.BINARY_EXPRESSION;
    }

    protected BinaryParsingState parseBinaryRightHandSide() {
        return this.parseUnaryExpression() ? BinaryParsingState.OK : BinaryParsingState.FAIL;
    }

    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int result2 = -1;
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSElementTypes.OROR || tokenType == JSElementTypes.QUEST_QUEST) {
            result2 = 0;
        } else if (tokenType == JSElementTypes.ANDAND) {
            result2 = 1;
        } else if (tokenType == JSElementTypes.OR || tokenType == JSElementTypes.PIPE) {
            result2 = 2;
        } else if (tokenType == JSElementTypes.XOR) {
            result2 = 3;
        } else if (tokenType == JSElementTypes.AND) {
            result2 = 4;
        } else if (JSElementTypes.EQUALITY_OPERATIONS.contains(tokenType)) {
            result2 = 5;
        } else if (JSElementTypes.RELATIONAL_OPERATIONS.contains(tokenType) && (allowIn || this.builder.getTokenType() != JSElementTypes.IN_KEYWORD)) {
            result2 = 6;
        } else if (JSElementTypes.SHIFT_OPERATIONS.contains(tokenType)) {
            result2 = 7;
        } else if (JSElementTypes.ADDITIVE_OPERATIONS.contains(tokenType)) {
            result2 = 8;
        } else if (JSElementTypes.MULTIPLICATIVE_OPERATIONS.contains(tokenType)) {
            result2 = 9;
        } else if (tokenType == JSElementTypes.IS_KEYWORD || tokenType == JSElementTypes.AS_KEYWORD) {
            result2 = 10;
        }
        if (advance && result2 >= 0) {
            this.builder.advanceLexer();
        }
        return result2;
    }

    protected boolean parseUnaryExpression() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSElementTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.builder.error("expression expected");
            }
            expr.done(JSElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePostfixExpression();
    }

    protected boolean parsePostfixExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseLeftHandSideExpression(false)) {
            expr.drop();
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(tokenType != JSElementTypes.PLUSPLUS && tokenType != JSElementTypes.MINUSMINUS || ExpressionParser.hasSemanticLinefeedBefore(this.builder))) {
            this.builder.advanceLexer();
            expr.done(JSElementTypes.POSTFIX_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseExpressionOptional() {
        return this.parseExpressionOptional(true, false);
    }

    public boolean parseExpressionOptional(boolean allowIn, boolean allowGenerator) {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseAssignmentExpression(allowIn)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSElementTypes.IN_KEYWORD) {
            expr.done((IElementType)JSElementTypes.DEFINITION_EXPRESSION);
            return true;
        }
        if (allowGenerator && this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD) {
            this.myJavaScriptParser.getStatementParser().parseForLoopHeader();
            if (this.builder.getTokenType() == JSElementTypes.IF_KEYWORD) {
                this.myJavaScriptParser.getStatementParser().parseIfStatementHeader();
            }
            expr.done(JSElementTypes.GENERATOR_EXPRESSION);
            return true;
        }
        int nestingLevel = 0;
        while (this.builder.getTokenType() == JSElementTypes.COMMA) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error("expression expected");
            }
            if (nestingLevel < 100) {
                expr.done(JSElementTypes.COMMA_EXPRESSION);
                expr = expr.precede();
            }
            ++nestingLevel;
        }
        expr.drop();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "varType";
        objectArray2[1] = "com/intellij/sql/dialects/mongo/js/ExpressionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDestructuringElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDestructuringElementNoMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static enum BinaryParsingState {
        FAIL,
        OK,
        STOP,
        FAIL_AND_STOP;

    }

    private static class MarkerData {
        private final int myPriority;
        private final PsiBuilder.Marker myMarker;
        private final IElementType myElementType;

        public int getPriority() {
            return this.myPriority;
        }

        public PsiBuilder.Marker getMarker() {
            return this.myMarker;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        MarkerData(int priority, PsiBuilder.Marker marker, IElementType elementType) {
            this.myPriority = priority;
            this.myMarker = marker;
            this.myElementType = elementType;
        }
    }
}

