/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.sql.dialects.base.EvaluationHelperBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/dialects/cassandra/CassEvaluationHelper;", "Lcom/intellij/sql/dialects/base/EvaluationHelperBase;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "generateSelectStatement", "", "text", "sqlElement", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.dialects.cassandra"})
public final class CassEvaluationHelper
extends EvaluationHelperBase {
    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)sqlElement, (String)"sqlElement");
        if (sqlElement instanceof SqlTypeCastExpression) {
            return "SELECT " + text + " FROM system.local";
        }
        String type = "???";
        if (sqlElement instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)sqlElement).getSqlType();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlType, (String)"sqlElement.sqlType");
            SqlType sqlType2 = sqlType;
            if (sqlType2 instanceof SqlPrimitiveType && Intrinsics.areEqual((Object)sqlType2, (Object)SqlType.UNKNOWN) ^ true) {
                String string = sqlType2.getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sqlType.getDisplayName()");
                type = string;
            } else if (sqlType2 instanceof SqlParametrizedType) {
                DataType dataType = ((SqlParametrizedType)sqlType2).getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sqlType.dataType");
                String string = dataType.getSpecification();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sqlType.dataType.specification");
                type = string;
            }
        }
        return "SELECT (" + type + ") " + text + " FROM system.local";
    }

    public CassEvaluationHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

